/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.AbapExceptionModel;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.Jarm;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AbapRepository
extends BasicRepository {
    protected static final DefaultRecordMetaData funint_v2 = new DefaultRecordMetaData("RFC_FUNINT", 12);
    protected static final DefaultRecordMetaData fields_v2 = new DefaultRecordMetaData("RFC_FIELDS", 7);
    protected static final DefaultRecordMetaData funint_v3 = new DefaultRecordMetaData("RFC_FUNINT", 11);
    protected static final DefaultRecordMetaData fields_v3 = new DefaultRecordMetaData("RFC_FIELDS", 7);
    protected static final DefaultRecordMetaData rsimp_v3 = new DefaultRecordMetaData("RSIMP", 8);
    protected static final DefaultRecordMetaData rstbl_v3 = new DefaultRecordMetaData("RSTBL", 5);
    protected static final DefaultRecordMetaData x030l_v4 = new DefaultRecordMetaData("X030L", 25);
    protected static final DefaultRecordMetaData dfies_v4 = new DefaultRecordMetaData("DFIES", 42);
    protected static final DefaultRecordMetaData ddtypelist_v4 = new DefaultRecordMetaData("DDTYPELIST", 3);
    protected static final DefaultRecordMetaData dfies_v5 = new DefaultRecordMetaData("DFIES", 44);
    protected static final DefaultRecordMetaData x030l_v5 = new DefaultRecordMetaData("X030L", 27);
    protected static final DefaultRecordMetaData ddtypelist_v5 = new DefaultRecordMetaData("DDTYPELIST", 3);
    protected static final DefaultListMetaData getFunctionInterfaceImports = new DefaultListMetaData("FUNINTIMP", 2);
    protected static final DefaultListMetaData getFunctionInterfaceExports = new DefaultListMetaData("FUNINTEXP", 1);
    protected static final DefaultListMetaData getFunctionInterfaceTables_v2 = new DefaultListMetaData("FUNINTTAB", 1);
    protected static final DefaultListMetaData getFunctionInterfaceTables_v3 = new DefaultListMetaData("FUNINTTAB", 1);
    protected static final DefaultListMetaData getFunctionInterfaceTables_v4;
    protected static final DefaultListMetaData getFunctionInterfaceTables_v5;
    protected static final DefaultListMetaData getStructureDefinitionImports_v2;
    protected static final DefaultListMetaData getStructureDefinitionImports_v3;
    protected static final DefaultListMetaData getStructureDefinitionExports;
    protected static final DefaultListMetaData getStructureDefinitionTables_v2;
    protected static final DefaultListMetaData getStructureDefinitionTables_v3;
    protected static final DefaultListMetaData ddifFieldInfoGetImports;
    protected static final DefaultListMetaData ddifFieldInfoGetExports_v4;
    protected static final DefaultListMetaData ddifFieldInfoGetExports_v462;
    protected static final DefaultListMetaData ddifFieldInfoGetExports_v5;
    protected static final DefaultListMetaData ddifFieldInfoGetTables_v4;
    protected static final DefaultListMetaData ddifFieldInfoGetTables_v5;
    protected static final byte[] ddifFieldInfoGetNUC;
    protected static final byte[] ddifFieldInfoGetUC;
    protected static final DefaultListMetaData functionImportInterfaceImports;
    protected static final DefaultListMetaData functionImportInterfaceTables;
    protected static final String[] ABAP_TYPES;
    protected static final char[] ABAP_EXIDS;
    protected int repository_version = 0;
    protected InternalDestination destination = null;
    LinkedList<InternalDestination> availableDestinations;
    JCoFunctionTemplate getFunctionInterfaceTemplate;
    JCoFunctionTemplate functionImportInterfaceTemplate;
    JCoFunctionTemplate getStructureDefinitionTemplate;
    JCoFunctionTemplate ddifFieldInfoGetTemplate;
    String partnerRelease = null;
    private AbapRepositoryMonitor monitor = null;
    long lastRemoteQueryTimestamp = 0L;
    private static final boolean DEBUG = false;

    protected AbapRepository(String name) {
        super(name, true);
    }

    protected AbapRepository(String name, JCoDestination destination) throws JCoException {
        this(name, (InternalDestination)destination);
    }

    protected AbapRepository(String name, InternalDestination destination) throws JCoException {
        super(name, false);
        if (destination != null) {
            this.destination = destination;
            this.partnerRelease = destination.getAttributes().getPartnerRelease();
        }
        this.availableDestinations = new LinkedList();
        this.containsUnicodeInfo = this.getVersion() > 463;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int getVersion() {
        if (this.repository_version == 0) {
            AbapRepository abapRepository = this;
            synchronized (abapRepository) {
                if (this.destination != null) {
                    ClientConnection client = null;
                    try {
                        client = ConnectionManager.getConnectionManager().getClient(this.destination, true);
                        this.repository_version = client.getAttributes().getPartnerReleaseNumber();
                    }
                    catch (Throwable t) {
                    }
                    finally {
                        if (client != null) {
                            try {
                                ConnectionManager.getConnectionManager().releaseClient(client);
                            }
                            catch (JCoException je) {}
                        }
                    }
                }
            }
        }
        return this.repository_version;
    }

    protected JCoFunctionTemplate queryFunctionTemplateWithRetry(String function_name) throws JCoException {
        JCoFunctionTemplate meta = null;
        try {
            meta = this.queryFunctionTemplate(function_name);
        }
        catch (JCoException first_ex) {
            switch (first_ex.getGroup()) {
                case 102: 
                case 104: {
                    try {
                        if (!this.changeDestination()) {
                            throw first_ex;
                        }
                        meta = this.queryFunctionTemplate(function_name);
                        break;
                    }
                    catch (Exception ex) {
                        throw first_ex;
                    }
                }
                default: {
                    throw first_ex;
                }
            }
        }
        return meta;
    }

    protected JCoRecordMetaData queryRecordMetaDataWithRetry(String structure_name) throws JCoException {
        JCoRecordMetaData meta = null;
        try {
            meta = this.queryRecordMetaData(structure_name);
        }
        catch (JCoException first_ex) {
            switch (first_ex.getGroup()) {
                case 102: 
                case 104: {
                    try {
                        if (!this.changeDestination()) {
                            throw first_ex;
                        }
                        meta = this.queryRecordMetaData(structure_name);
                        break;
                    }
                    catch (Exception ex) {
                        throw first_ex;
                    }
                }
                default: {
                    throw first_ex;
                }
            }
        }
        return meta;
    }

    public JCoFunctionTemplate getFunctionTemplate(String functionName) throws JCoException {
        AbapException exc;
        JCoFunctionTemplate template;
        block6: {
            template = null;
            template = super.getFunctionTemplate(functionName);
            if (template != null) {
                return template;
            }
            exc = null;
            try {
                template = this.queryFunctionTemplateWithRetry(functionName);
            }
            catch (AbapException ae) {
                if ("FU_NOT_FOUND".equalsIgnoreCase(ae.getKey())) break block6;
                exc = ae;
            }
        }
        if (template != null) {
            super.addFunctionTemplate(template);
            template = super.getFunctionTemplate(functionName);
        } else if (exc != null) {
            throw exc;
        }
        return template;
    }

    public JCoRecordMetaData getRecordMetaData(String recordName) throws JCoException {
        AbapException exc;
        JCoRecordMetaData meta;
        block7: {
            meta = null;
            meta = super.getRecordMetaData(recordName);
            if (meta != null) {
                return meta;
            }
            exc = null;
            try {
                meta = this.queryRecordMetaDataWithRetry(recordName);
            }
            catch (AbapException ae) {
                if ("NOT_FOUND".equalsIgnoreCase(ae.getKey()) || "TABLE_NOT_ACTIVE".equalsIgnoreCase(ae.getKey())) break block7;
                exc = ae;
            }
        }
        if (meta != null) {
            JCoRecordMetaData saved = super.getRecordMetaData(recordName);
            if (saved != meta) {
                super.addRecordMetaData(meta);
            }
        } else if (exc != null) {
            throw exc;
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JCoFunctionTemplate queryFunctionTemplate(String functionName) throws JCoException {
        Jarm.Monitor jarm_monitor;
        block73: {
            int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
            jarm_monitor = null;
            if (Trace.isOn(64, true)) {
                Trace.fireTrace(64, "[JCoAPI] queryFunctionTemplate(" + functionName + ") for repository " + this.name + " using destination " + (this.destination != null ? this.destination.getDestinationName() : "null"));
            }
            if ((mode & 1) != 0) {
                try {
                    jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.conn.jco.AbapRepository");
                    if (jarm_monitor != null) {
                        jarm_monitor.startComponent();
                    }
                }
                catch (Throwable th) {
                    if (!Trace.isOn(4)) break block73;
                    Trace.fireTrace(4, "[JCoAPI] Exception within JARM component: " + th.toString());
                }
            }
        }
        JCoTable funint = null;
        AbapFunctionTemplate functionTemplate = null;
        if (this.destination == null) {
            throw new JCoException(106, "JCO_ERROR_RESOURCE", "Invalid destination reference encountered (destination is null)");
        }
        ClientConnection client = ConnectionManager.getConnectionManager().getClient(this.destination, true);
        try {
            String tabname;
            String pdflt;
            char pclass;
            int irow;
            int version = this.getVersion();
            JCoFunction rfcGetFunctionInterface = this.getRfcGetFunctionInterfaceTemplate().getFunction();
            rfcGetFunctionInterface.getImportParameterList().setValue(0, functionName);
            if (this.containsUnicodeInfo) {
                rfcGetFunctionInterface.getImportParameterList().setValue(1, "X");
            }
            client.execute(rfcGetFunctionInterface);
            funint = rfcGetFunctionInterface.getTableParameterList().getTable(0);
            boolean supportsASXML = false;
            int changingCount = 0;
            int importCount = 0;
            int exportCount = 0;
            int tableCount = 0;
            int exceptionCount = 0;
            block30: for (irow = 0; irow < funint.getNumRows(); ++irow) {
                funint.setRow(irow);
                pclass = funint.getChar(0);
                switch (pclass) {
                    case 'I': {
                        ++importCount;
                        continue block30;
                    }
                    case 'E': {
                        ++exportCount;
                        continue block30;
                    }
                    case 'C': {
                        ++changingCount;
                        continue block30;
                    }
                    case 'T': {
                        ++tableCount;
                        continue block30;
                    }
                    case 'X': {
                        ++exceptionCount;
                        continue block30;
                    }
                }
            }
            DefaultListMetaData template_imports = null;
            DefaultListMetaData template_exports = null;
            DefaultListMetaData template_changing = null;
            DefaultListMetaData template_tables = null;
            AbapExceptionModel[] exceptions = null;
            if (importCount > 0) {
                template_imports = new DefaultListMetaData("INPUT", importCount);
            }
            if (exportCount > 0) {
                template_exports = new DefaultListMetaData("OUTPUT", exportCount);
            }
            if (changingCount > 0) {
                template_changing = new DefaultListMetaData("CHANGING", changingCount);
            }
            if (tableCount > 0) {
                template_tables = new DefaultListMetaData("TABLES", tableCount);
            }
            if (exceptionCount > 0) {
                exceptions = new AbapExceptionModel[exceptionCount];
                exceptionCount = 0;
            }
            block31: for (irow = 0; irow < funint.getNumRows(); ++irow) {
                int flags = 0;
                funint.setRow(irow);
                pclass = funint.getChar(0);
                pdflt = version > 200 && version < 460 ? funint.getString(9).trim() : funint.getString(11);
                tabname = funint.getString(2);
                String fieldname = funint.getString(3);
                String stype = funint.getString(4);
                int ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                String sdefault = null;
                String descript = funint.getString(10).trim();
                String string = descript = descript.length() > 0 ? descript : null;
                if (ptype == -1 && (pclass == 'I' || pclass == 'E' || pclass == 'C')) {
                    for (int j = 0; j < ABAP_TYPES.length && ptype == -1; ++j) {
                        if (!tabname.equals(ABAP_TYPES[j])) continue;
                        ptype = AbstractMetaData.getJCOType(ABAP_EXIDS[j]);
                    }
                }
                if (version >= 462 && pclass != 'X' && pclass != 'T' && (ptype == -1 || ptype == 17 || ptype == 99)) {
                    JCoFunction ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                    JCoStructure dfies_wa2 = null;
                    JCoParameterList ddifImports = ddifFieldInfoGet.getImportParameterList();
                    JCoParameterList ddifExports = ddifFieldInfoGet.getExportParameterList();
                    ddifImports.setValue(0, tabname);
                    ddifImports.setValue(1, "X");
                    if (fieldname.length() > 0) {
                        ddifImports.setValue(2, fieldname);
                        ddifImports.setActive(3, false);
                        ddifExports.setActive(1, false);
                        ddifExports.setActive(2, false);
                        ddifExports.setActive(3, false);
                        client.execute(ddifFieldInfoGet);
                        dfies_wa2 = ddifExports.getStructure(0);
                        stype = dfies_wa2.getString(13);
                        ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                        if (ptype == 17 || ptype == 99) {
                            tabname = dfies_wa2.getString(6);
                        }
                    } else if (ptype == -1 || ptype == 17) {
                        ddifImports.setActive(2, false);
                        ddifImports.setActive(3, false);
                        ddifExports.setActive(0, false);
                        ddifExports.setActive(1, false);
                        ddifExports.setActive(3, false);
                        client.execute(ddifFieldInfoGet);
                        String ddobjtype = ddifExports.getString(2);
                        ptype = ddobjtype.equalsIgnoreCase("INTTAB") || ddobjtype.equalsIgnoreCase("TRANSP") || ddobjtype.equalsIgnoreCase("POOL") || ddobjtype.equalsIgnoreCase("CLUSTER") ? 17 : (ddobjtype.equalsIgnoreCase("TTYP") ? 99 : -1);
                    }
                }
                switch (ptype) {
                    case -1: 
                    case 17: 
                    case 99: {
                        fieldname = null;
                        break;
                    }
                    default: {
                        if (fieldname.length() != 0) break;
                        fieldname = null;
                    }
                }
                switch (pclass) {
                    case 'I': {
                        flags |= 2;
                        if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                            flags |= 1;
                        }
                        if (ptype == -1) {
                            ptype = 17;
                        }
                        sdefault = (sdefault = funint.getString(9).trim()).length() > 0 ? sdefault : null;
                        template_imports.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, fieldname, null);
                        continue block31;
                    }
                    case 'E': {
                        flags |= 5;
                        if (ptype == -1) {
                            ptype = 17;
                        }
                        template_exports.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, fieldname, null);
                        continue block31;
                    }
                    case 'C': {
                        flags |= 8;
                        if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                            flags |= 1;
                        }
                        if (ptype == -1) {
                            ptype = 17;
                        }
                        sdefault = (sdefault = funint.getString(9).trim()).length() > 0 ? sdefault : null;
                        template_changing.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, fieldname, null);
                        continue block31;
                    }
                    case 'T': {
                        flags = 0;
                        if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                            flags |= 1;
                        }
                        ptype = 99;
                        template_tables.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, null, null);
                        continue block31;
                    }
                    case 'X': {
                        flags = 0;
                        ptype = 98;
                        if (descript == null) {
                            descript = funint.getString(1);
                        }
                        AbapExceptionModel ae = new AbapExceptionModel(funint.getString(1), descript);
                        exceptions[exceptionCount++] = ae;
                        continue block31;
                    }
                }
            }
            if (version > 463) {
                AbstractMetaData[] templates = new AbstractMetaData[]{template_imports, template_exports, template_changing, template_tables};
                for (int tidx = 0; tidx < templates.length; ++tidx) {
                    if (templates[tidx] == null) continue;
                    int numFields = templates[tidx].numFields;
                    block34: for (int field = 0; field < numFields; ++field) {
                        switch (templates[tidx].type[field]) {
                            case 0: 
                            case 1: 
                            case 3: 
                            case 6: {
                                templates[tidx].length[1][field] = templates[tidx].length[0][field] * 2;
                                continue block34;
                            }
                            case 17: 
                            case 99: {
                                JCoRecordMetaData subRecord;
                                if (client != null) {
                                    ConnectionManager.getConnectionManager().releaseClient(client);
                                    client = null;
                                }
                                if ((subRecord = this.getRecordMetaData(templates[tidx].getRecordTypeName(field))) != null) {
                                    templates[tidx].length[1][field] = subRecord.getUnicodeRecordLength();
                                    templates[tidx].length[0][field] = subRecord.getRecordLength();
                                    continue block34;
                                }
                                templates[tidx].length[1][field] = 0;
                                templates[tidx].length[0][field] = 0;
                                continue block34;
                            }
                            default: {
                                templates[tidx].length[1][field] = templates[tidx].length[0][field];
                            }
                        }
                    }
                }
                if (version >= 710) {
                    JCoParameterList exports = rfcGetFunctionInterface.getExportParameterList();
                    boolean bl = supportsASXML = exports.getChar(0) == 'X';
                }
            }
            if (version > 200 && version < 460) {
                JCoFunction functionImportInterface = this.getFunctionImportInterfaceTemplate().getFunction();
                functionImportInterface.getImportParameterList().setValue(0, functionName);
                client.execute(functionImportInterface);
                JCoTable rsimp = functionImportInterface.getTableParameterList().getTable(0);
                block35: for (irow = 0; irow < rsimp.getNumRows(); ++irow) {
                    rsimp.setRow(irow);
                    pdflt = rsimp.getString(4).trim();
                    if (pdflt.length() == 0) continue;
                    tabname = rsimp.getString(0);
                    for (int i = 0; i < template_imports.name.length; ++i) {
                        if (!template_imports.name[i].equals(tabname)) continue;
                        int n = i;
                        template_imports.flags[n] = (byte)(template_imports.flags[n] | 1);
                        continue block35;
                    }
                }
                JCoTable rstbl = functionImportInterface.getTableParameterList().getTable(1);
                block37: for (irow = 0; irow < rstbl.getNumRows(); ++irow) {
                    rstbl.setRow(irow);
                    pdflt = rstbl.getString(3).trim();
                    if (pdflt.length() == 0) continue;
                    tabname = rstbl.getString(0);
                    for (int i = 0; i < template_tables.name.length; ++i) {
                        if (!template_tables.name[i].equals(tabname)) continue;
                        int n = i;
                        template_tables.flags[n] = (byte)(template_tables.flags[n] | 1);
                        continue block37;
                    }
                }
            }
            if (template_changing != null) {
                template_changing.lock();
            }
            if (template_imports != null) {
                template_imports.lock();
            }
            if (template_exports != null) {
                template_exports.lock();
            }
            if (template_tables != null) {
                template_tables.lock();
            }
            functionTemplate = new AbapFunctionTemplate(functionName, template_imports, template_exports, template_changing, template_tables, exceptions, supportsASXML);
            funint.firstRow();
        }
        finally {
            block75: {
                if (client != null) {
                    ConnectionManager.getConnectionManager().releaseClient(client);
                }
                if (jarm_monitor != null) {
                    try {
                        jarm_monitor.compAction(functionName);
                        jarm_monitor.endComponent();
                        jarm_monitor.endRequest();
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4)) break block75;
                        Trace.fireTrace(4, "[JCoAPI] Exception within JARM component: " + th.toString());
                    }
                }
            }
            this.lastRemoteQueryTimestamp = System.currentTimeMillis();
        }
        return functionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JCoRecordMetaData queryRecordMetaData(String recordName) throws JCoException {
        Jarm.Monitor jarm_monitor;
        block36: {
            int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
            jarm_monitor = null;
            if (this.destination == null) {
                throw new JCoException(106, "JCO_ERROR_RESOURCE", "Invalid destination reference encountered (destination is null)");
            }
            if ((mode & 1) != 0) {
                try {
                    jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.conn.jco.AbapRepository");
                    if (jarm_monitor != null) {
                        jarm_monitor.startComponent();
                    }
                }
                catch (Throwable th) {
                    if (!Trace.isOn(4)) break block36;
                    Trace.fireTrace(4, "[JCoAPI] Exception within JARM component: " + th.toString());
                }
            }
        }
        AbstractMetaData meta = null;
        ClientConnection client = ConnectionManager.getConnectionManager().getClient(this.destination, true);
        try {
            int irow;
            int version = this.getVersion();
            if (Trace.isOn(64)) {
                Trace.fireTrace(64, new FastStringBuffer(120).append("[JCoAPI] AbapRepository.queryRecordMetaData(\"").append(recordName).append("\") for repository ").append(this.name).append(" version ").append(version).append(" using destination").append(this.destination != null ? this.destination.getDestinationName() : "null").toString());
            }
            if (version >= 200 && version < 300) {
                JCoFunction rfcGetStructureDefinition = this.getRfcGetStructureDefinitionTemplate().getFunction();
                rfcGetStructureDefinition.getImportParameterList().setValue(0, recordName);
                client.execute(rfcGetStructureDefinition);
                JCoTable fields = rfcGetStructureDefinition.getTableParameterList().getTable(0);
                int num_rows = fields.getNumRows();
                meta = new DefaultRecordMetaData(recordName, num_rows);
                for (irow = 0; irow < num_rows; ++irow) {
                    fields.setRow(irow);
                    String stype = fields.getString(6);
                    byte ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                    ((DefaultRecordMetaData)meta).add(fields.getString(1), ptype, fields.getInt(4), fields.getInt(3), 0, 0, fields.getInt(5), null, null, null);
                }
                ((DefaultRecordMetaData)meta).setRecordLength(rfcGetStructureDefinition.getExportParameterList().getInt(0), 0);
                fields.firstRow();
            } else if (version >= 300 && version < 400) {
                JCoFunction rfcGetStructureDefinition = this.getRfcGetStructureDefinitionTemplate().getFunction();
                rfcGetStructureDefinition.getImportParameterList().setValue(0, recordName);
                client.execute(rfcGetStructureDefinition);
                JCoTable fields = rfcGetStructureDefinition.getTableParameterList().getTable(0);
                int num_rows = fields.getNumRows();
                meta = new DefaultRecordMetaData(recordName, num_rows);
                ((DefaultRecordMetaData)meta).setRecordLength(rfcGetStructureDefinition.getExportParameterList().getInt(0), 0);
                for (irow = 0; irow < num_rows; ++irow) {
                    fields.setRow(irow);
                    String stype = fields.getString(6);
                    byte ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                    ((DefaultRecordMetaData)meta).add(fields.getString(1), ptype, fields.getInt(4), fields.getInt(3), 0, 0, fields.getInt(5), null, null, null);
                }
                fields.firstRow();
            } else if (version >= 400 && version < 462) {
                JCoFunction ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                JCoParameterList ddifImports = ddifFieldInfoGet.getImportParameterList();
                JCoParameterList ddifExports = ddifFieldInfoGet.getExportParameterList();
                ddifImports.setValue(0, recordName);
                ddifImports.setValue(1, "X");
                ddifImports.setActive(2, false);
                ddifImports.setActive(3, false);
                ddifExports.setActive(2, false);
                ddifExports.setActive(3, false);
                client.execute(ddifFieldInfoGet);
                JCoStructure x030l_wa = ddifExports.getStructure(1);
                JCoStructure dfies_wa = ddifExports.getStructure(0);
                JCoTable dfies_tab = ddifFieldInfoGet.getTableParameterList().getTable(0);
                int num_rows = dfies_tab.getNumRows();
                if (num_rows == 0) {
                    ddifImports.setValue(0, dfies_wa.getString(6));
                    client.execute(ddifFieldInfoGet);
                }
                num_rows = dfies_tab.getNumRows();
                meta = new DefaultRecordMetaData(recordName, num_rows);
                ((DefaultRecordMetaData)meta).setRecordLength(x030l_wa.getInt(7), 0);
                for (irow = 0; irow < num_rows; ++irow) {
                    dfies_tab.setRow(irow);
                    String stype = dfies_tab.getString(13);
                    byte ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                    ((DefaultRecordMetaData)meta).add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4), 0, 0, dfies_tab.getInt(11), dfies_tab.getString(27), dfies_tab.getString(6), null);
                }
                dfies_tab.firstRow();
            } else if (version >= 462) {
                byte flag3;
                JCoTable dfies_tab = null;
                JCoTable dfies_tab_UC = null;
                JCoFunction ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                JCoParameterList ddifImports = ddifFieldInfoGet.getImportParameterList();
                JCoParameterList ddifExports = ddifFieldInfoGet.getExportParameterList();
                if (this.containsUnicodeInfo) {
                    ddifImports.setValue(3, ddifFieldInfoGetNUC);
                } else {
                    ddifImports.setActive(3, false);
                }
                ddifImports.setValue(0, recordName);
                ddifImports.setValue(1, "X");
                ddifImports.setActive(2, false);
                ddifExports.setActive(2, false);
                client.execute(ddifFieldInfoGet);
                JCoStructure dfies_wa = ddifExports.getStructure(0);
                JCoStructure x030l_wa = ddifExports.getStructure(1);
                JCoTable lines_descr = ddifExports.getTable(3);
                dfies_tab = ddifFieldInfoGet.getTableParameterList().getTable(0);
                JCoStructure dfies_wa_UC = null;
                JCoRecord x030l_wa_UC = null;
                JCoRecord lines_descr_UC = null;
                if (this.containsUnicodeInfo) {
                    ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                    ddifImports = ddifFieldInfoGet.getImportParameterList();
                    ddifExports = ddifFieldInfoGet.getExportParameterList();
                    ddifImports.setValue(0, recordName);
                    ddifImports.setValue(1, "X");
                    ddifImports.setActive(2, false);
                    ddifImports.setValue(3, ddifFieldInfoGetUC);
                    ddifExports.setActive(2, false);
                    client.execute(ddifFieldInfoGet);
                    dfies_wa_UC = ddifExports.getStructure(0);
                    x030l_wa_UC = ddifExports.getStructure(1);
                    lines_descr_UC = ddifExports.getTable(3);
                    dfies_tab_UC = ddifFieldInfoGet.getTableParameterList().getTable(0);
                }
                meta = new DefaultRecordMetaData(recordName);
                if (x030l_wa.getChar(11) == 'L') {
                    if (lines_descr.getNumRows() == 1) {
                        dfies_tab = lines_descr.getTable(2);
                        if (lines_descr_UC != null) {
                            dfies_tab_UC = lines_descr_UC.getTable(2);
                        }
                        ((DefaultRecordMetaData)meta).typeName = lines_descr.getString(0);
                    } else if (dfies_tab.getNumRows() == 0) {
                        dfies_tab.copyFrom(dfies_wa);
                        if (dfies_wa_UC != null) {
                            dfies_tab_UC.copyFrom(dfies_wa_UC);
                        }
                    }
                }
                boolean isNestedType1 = ((flag3 = x030l_wa.getByteArray(16)[0]) & 1) != 0 && (flag3 & 2) == 0;
                ((DefaultRecordMetaData)meta).setRecordLength(x030l_wa.getInt(7), x030l_wa_UC == null ? 0 : x030l_wa_UC.getInt(7));
                ((DefaultRecordMetaData)meta).type1MetaData = isNestedType1 ? new DefaultRecordMetaData.Type1MetaData((DefaultRecordMetaData)meta) : null;
                meta = this.constructMetaData(client, version, dfies_tab, dfies_tab_UC, lines_descr, (JCoTable)lines_descr_UC, (DefaultRecordMetaData)meta, null, 0, 0, 1);
                if (((DefaultRecordMetaData)meta).type1MetaData != null) {
                    ((DefaultRecordMetaData)meta).type1MetaData.constructMetaData();
                }
            }
        }
        finally {
            block38: {
                if (client != null) {
                    ConnectionManager.getConnectionManager().releaseClient(client);
                }
                if (jarm_monitor != null) {
                    try {
                        jarm_monitor.compAction(recordName);
                        jarm_monitor.endComponent();
                        jarm_monitor.endRequest();
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4)) break block38;
                        Trace.fireTrace(4, "[JCoAPI] Exception within JARM component: " + th.toString());
                    }
                }
            }
            this.lastRemoteQueryTimestamp = System.currentTimeMillis();
        }
        meta.lock();
        return meta;
    }

    private DefaultRecordMetaData constructMetaData(ClientConnection client, int version, JCoTable dfies_tab, JCoTable dfies_tab_UC, JCoTable lines_descr, JCoTable lines_descr_UC, DefaultRecordMetaData meta, String lfieldname, int base_offset, int base_offset_UC, int level) throws JCoException {
        DefaultRecordMetaData cached;
        int num_rows = dfies_tab.getNumRows();
        if (num_rows == 0 || dfies_tab.getRow() >= num_rows) {
            return meta;
        }
        do {
            if (lfieldname != null && !dfies_tab.getString(43).startsWith(lfieldname)) {
                if (level <= 1) break;
                dfies_tab.previousRow();
                if (dfies_tab_UC == null) break;
                dfies_tab_UC.previousRow();
                break;
            }
            char comptype = dfies_tab.getChar(42);
            String stype = dfies_tab.getString(13);
            int ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
            if (ptype == -1) {
                String datatype = dfies_tab.getString(12);
                if (datatype.equals("STRU")) {
                    ptype = 17;
                } else if (datatype.equals("TTYP")) {
                    ptype = 99;
                }
            }
            if (ptype == 17 || ptype == 99) {
                DefaultRecordMetaData meta_new;
                String rollname = dfies_tab.getString(6);
                if (comptype == 'S') {
                    meta_new = new DefaultRecordMetaData(rollname);
                    meta_new.setRecordLength(dfies_tab.getInt(9), dfies_tab_UC.getInt(9));
                    meta_new.type1MetaData = meta.isNestedType1Structure() ? new DefaultRecordMetaData.Type1MetaData(meta_new) : null;
                    String lfieldname_new = dfies_tab.getString(43) + "-";
                    int offset_new = dfies_tab.getInt(4);
                    int offset_UC_new = dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4);
                    meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), meta_new, null);
                    dfies_tab.nextRow();
                    if (dfies_tab_UC != null) {
                        dfies_tab_UC.nextRow();
                    }
                    this.constructMetaData(client, version, dfies_tab, dfies_tab_UC, lines_descr, lines_descr_UC, meta_new, lfieldname_new, offset_new, offset_UC_new, level + 1);
                    if (meta.isNestedType1Structure() && meta_new.numOdata > 0) {
                        meta_new.type1MetaData.constructMetaData();
                        continue;
                    }
                    if (meta_new.numOdata > 0) {
                        if (!AbapRepository.checkType1(meta_new)) continue;
                        meta_new.type1MetaData = new DefaultRecordMetaData.Type1MetaData(meta_new);
                        meta_new.type1MetaData.constructMetaData();
                        continue;
                    }
                    meta_new.type1MetaData = null;
                    continue;
                }
                if (comptype == 'L' || comptype == 'T') {
                    meta_new = null;
                    if (comptype == 'T') {
                        meta.typeName = rollname;
                    }
                    if (rollname.length() > 0 && this.containsRecordMetaData(rollname)) {
                        meta_new = (DefaultRecordMetaData)this.getRecordMetaData(rollname);
                        if (comptype == 'L' || dfies_tab.getNumRows() == 1 && "TTYP".equals(dfies_tab.getString(12))) {
                            meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), meta_new, null);
                            continue;
                        }
                        String curr_rec_name = meta.recName;
                        meta.copy(meta_new);
                        meta.recName = curr_rec_name;
                        meta.typeName = meta_new.recName;
                        continue;
                    }
                    if (rollname.length() > 0) {
                        DefaultRecordMetaData cached2;
                        JCoRecord x030l_wa_UC;
                        JCoStructure x030l_wa;
                        JCoParameterList ddifExports;
                        JCoParameterList ddifImports;
                        JCoFunction ddifFieldInfoGet;
                        JCoTable dfies_tab_new = null;
                        JCoTable dfies_tab_UC_new = null;
                        String rollname_new = rollname;
                        int irow = 0;
                        String dataType = null;
                        String rollNameTemp = null;
                        while (irow < lines_descr.getNumRows() && dfies_tab_new == null) {
                            lines_descr.setRow(irow);
                            if (lines_descr_UC != null) {
                                lines_descr_UC.setRow(irow);
                            }
                            ++irow;
                            if (rollname_new.length() <= 0 || !lines_descr.getString(0).equals(rollname_new)) continue;
                            dfies_tab_new = lines_descr.getTable(2);
                            dfies_tab_new.firstRow();
                            if (lines_descr_UC != null) {
                                dfies_tab_UC_new = lines_descr_UC.getTable(2);
                                dfies_tab_UC_new.firstRow();
                            }
                            dataType = dfies_tab_new.getString(12);
                            rollNameTemp = dfies_tab_new.getString(6);
                            if (dfies_tab_new.getNumRows() != 1 || !dfies_tab_new.getString(42).equals("T")) continue;
                            if (rollNameTemp.length() == 0) {
                                rollname_new = null;
                                continue;
                            }
                            if (rollNameTemp.equals(dfies_tab_new.getString(5))) {
                                rollname_new = rollNameTemp;
                                continue;
                            }
                            if (!"STRU".equals(dataType) && !"TTYP".equals(dataType)) continue;
                            rollname_new = rollNameTemp;
                            dfies_tab_new = null;
                            dfies_tab_UC_new = null;
                            irow = 0;
                        }
                        if (dfies_tab_new != null && (comptype == 'L' || dfies_tab.getNumRows() == 1 && "TTYP".equals(dfies_tab.getString(12)))) {
                            meta_new = new DefaultRecordMetaData(rollname);
                            meta_new.typeName = rollname_new;
                            ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                            ddifImports = ddifFieldInfoGet.getImportParameterList();
                            ddifExports = ddifFieldInfoGet.getExportParameterList();
                            ddifImports.setValue(0, rollname);
                            ddifImports.setValue(1, "X");
                            ddifImports.setActive(2, false);
                            if (this.containsUnicodeInfo) {
                                ddifImports.setValue(3, ddifFieldInfoGetNUC);
                            } else {
                                ddifImports.setActive(3, false);
                            }
                            ddifExports.setActive(0, false);
                            ddifExports.setActive(2, false);
                            ddifExports.setActive(3, false);
                            ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                            client.execute(ddifFieldInfoGet);
                            x030l_wa = ddifExports.getStructure(1);
                            x030l_wa_UC = null;
                            if (this.containsUnicodeInfo) {
                                ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                                ddifImports = ddifFieldInfoGet.getImportParameterList();
                                ddifExports = ddifFieldInfoGet.getExportParameterList();
                                ddifImports.setValue(0, rollname);
                                ddifImports.setValue(1, "X");
                                ddifImports.setActive(2, false);
                                ddifImports.setValue(3, ddifFieldInfoGetUC);
                                ddifExports.setActive(0, false);
                                ddifExports.setActive(2, false);
                                ddifExports.setActive(3, false);
                                ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                                client.execute(ddifFieldInfoGet);
                                x030l_wa_UC = ddifExports.getStructure(1);
                            }
                            meta_new.setRecordLength(x030l_wa.getInt(7), x030l_wa_UC == null ? 0 : x030l_wa_UC.getInt(7));
                            this.constructMetaData(client, version, dfies_tab_new, dfies_tab_UC_new, lines_descr, lines_descr_UC, meta_new, null, 0, 0, level + 1);
                            if (rollname_new != null && rollname_new.length() > 0) {
                                cached2 = (DefaultRecordMetaData)super.getRecordMetaData(meta_new.getName());
                                if (!meta_new.equals(cached2)) {
                                    this.addRecordMetaData(meta_new);
                                } else {
                                    meta_new = cached2;
                                }
                            }
                        } else {
                            if (dfies_tab_new != null && comptype == 'T') {
                                ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                                ddifImports = ddifFieldInfoGet.getImportParameterList();
                                ddifExports = ddifFieldInfoGet.getExportParameterList();
                                ddifImports.setValue(0, rollname);
                                ddifImports.setValue(1, "X");
                                ddifImports.setActive(2, false);
                                if (this.containsUnicodeInfo) {
                                    ddifImports.setValue(3, ddifFieldInfoGetNUC);
                                } else {
                                    ddifImports.setActive(3, false);
                                }
                                ddifExports.setActive(0, false);
                                ddifExports.setActive(2, false);
                                ddifExports.setActive(3, false);
                                ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                                client.execute(ddifFieldInfoGet);
                                x030l_wa = ddifExports.getStructure(1);
                                x030l_wa_UC = null;
                                if (this.containsUnicodeInfo) {
                                    ddifFieldInfoGet = this.getDdifFieldInfoGetTemplate().getFunction();
                                    ddifImports = ddifFieldInfoGet.getImportParameterList();
                                    ddifExports = ddifFieldInfoGet.getExportParameterList();
                                    ddifImports.setValue(0, rollname);
                                    ddifImports.setValue(1, "X");
                                    ddifImports.setActive(2, false);
                                    ddifImports.setValue(3, ddifFieldInfoGetUC);
                                    ddifExports.setActive(0, false);
                                    ddifExports.setActive(2, false);
                                    ddifExports.setActive(3, false);
                                    ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                                    client.execute(ddifFieldInfoGet);
                                    x030l_wa_UC = ddifExports.getStructure(1);
                                }
                                meta.setRecordLength(x030l_wa.getInt(7), x030l_wa_UC == null ? 0 : x030l_wa_UC.getInt(7));
                                this.constructMetaData(client, version, dfies_tab_new, dfies_tab_UC_new, lines_descr, lines_descr_UC, meta, null, 0, 0, level + 1);
                                if (rollname_new == null || rollname_new.length() <= 0) continue;
                                cached2 = (DefaultRecordMetaData)super.getRecordMetaData(meta.getName());
                                if (!meta.equals(cached2)) {
                                    this.addRecordMetaData(meta);
                                    continue;
                                }
                                meta = cached2;
                                continue;
                            }
                            String msg = new FastStringBuffer(200).append("Could not find referenced or embedded table/structure ").append(rollname).append(" which was requested by ").append(meta.getName()).append(", comptype=").append(comptype).toString();
                            Trace.fireTraceCritical("[JCoAPI] " + msg);
                            throw new JCoException(108, "JCO_ERROR_INTERNAL", msg);
                        }
                    }
                    meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), meta_new, null);
                    continue;
                }
                meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), dfies_tab.getString(6), null);
                continue;
            }
            meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), dfies_tab.getString(6), null);
        } while (dfies_tab.nextRow() && (dfies_tab_UC == null || dfies_tab_UC.nextRow()));
        if (!meta.equals(cached = (DefaultRecordMetaData)super.getRecordMetaData(meta.getName()))) {
            this.addRecordMetaData(meta);
        } else {
            meta = cached;
        }
        int save_row = dfies_tab.getRow();
        if (dfies_tab_UC == null) {
            dfies_tab.firstRow();
            dfies_tab.setRow(save_row);
        } else {
            dfies_tab_UC.firstRow();
            dfies_tab_UC.setRow(save_row);
        }
        return meta;
    }

    private JCoFunctionTemplate getRfcGetFunctionInterfaceTemplate() {
        if (this.getFunctionInterfaceTemplate == null) {
            int version = this.getVersion();
            if (version >= 200 && version < 300) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v2, (AbapExceptionModel[])null, false);
            } else if (version >= 300 && version < 400) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v3, (AbapExceptionModel[])null, false);
            } else if (version >= 400 && version < 500) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v4, (AbapExceptionModel[])null, false);
            } else if (version >= 500 && version < 710) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v5, (AbapExceptionModel[])null, false);
            } else if (version >= 710) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, (JCoListMetaData)getFunctionInterfaceExports, null, (JCoListMetaData)getFunctionInterfaceTables_v5, (AbapExceptionModel[])null, false);
            }
        }
        return this.getFunctionInterfaceTemplate;
    }

    private JCoFunctionTemplate getDdifFieldInfoGetTemplate() {
        if (this.ddifFieldInfoGetTemplate == null) {
            DefaultListMetaData exp = null;
            DefaultListMetaData tab = null;
            int version = this.getVersion();
            if (version < 462) {
                exp = ddifFieldInfoGetExports_v4;
                tab = ddifFieldInfoGetTables_v4;
            } else if (version < 500) {
                exp = ddifFieldInfoGetExports_v462;
                tab = ddifFieldInfoGetTables_v5;
            } else {
                exp = ddifFieldInfoGetExports_v5;
                tab = ddifFieldInfoGetTables_v5;
            }
            this.ddifFieldInfoGetTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("DDIF_FIELDINFO_GET", (JCoListMetaData)ddifFieldInfoGetImports, (JCoListMetaData)exp, null, (JCoListMetaData)tab, (AbapExceptionModel[])null, false);
        }
        return this.ddifFieldInfoGetTemplate;
    }

    private JCoFunctionTemplate getFunctionImportInterfaceTemplate() {
        if (this.functionImportInterfaceTemplate == null) {
            this.functionImportInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("FUNCTION_IMPORT_INTERFACE", (JCoListMetaData)functionImportInterfaceImports, null, null, (JCoListMetaData)functionImportInterfaceTables, (AbapExceptionModel[])null, false);
        }
        return this.functionImportInterfaceTemplate;
    }

    private JCoFunctionTemplate getRfcGetStructureDefinitionTemplate() {
        if (this.getStructureDefinitionTemplate == null) {
            int version = this.getVersion();
            if (version >= 200 && version < 300) {
                this.getStructureDefinitionTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_STRUCTURE_DEFINITION", (JCoListMetaData)getStructureDefinitionImports_v2, (JCoListMetaData)getStructureDefinitionExports, null, (JCoListMetaData)getStructureDefinitionTables_v2, (AbapExceptionModel[])null, false);
            } else if (version >= 300 && version < 400) {
                this.getStructureDefinitionTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_STRUCTURE_DEFINITION", (JCoListMetaData)getStructureDefinitionImports_v3, (JCoListMetaData)getStructureDefinitionExports, null, (JCoListMetaData)getStructureDefinitionTables_v3, (AbapExceptionModel[])null, false);
            }
        }
        return this.getStructureDefinitionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeDestination() {
        if (this.availableDestinations.size() > 0) {
            LinkedList<InternalDestination> linkedList = this.availableDestinations;
            synchronized (linkedList) {
                this.availableDestinations.addLast(this.destination);
                this.destination = this.availableDestinations.removeFirst();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDestination(InternalDestination destinationToAdd) {
        LinkedList<InternalDestination> linkedList = this.availableDestinations;
        synchronized (linkedList) {
            if (this.destination == null) {
                this.destination = destinationToAdd;
            } else {
                this.availableDestinations.addLast(destinationToAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDestination(InternalDestination destinationToRemove) {
        LinkedList<InternalDestination> linkedList = this.availableDestinations;
        synchronized (linkedList) {
            if (this.availableDestinations.size() > 0) {
                this.availableDestinations.remove(destinationToRemove);
            }
            if (this.destination != null && this.destination.equals(destinationToRemove)) {
                this.destination = null;
            }
            if (this.destination == null && this.availableDestinations.size() > 0) {
                this.destination = this.availableDestinations.getFirst();
            }
        }
    }

    public String getMetaDataRelease() {
        return this.partnerRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbapRepositoryMonitor getMonitor() {
        AbapRepository abapRepository = this;
        synchronized (abapRepository) {
            if (this.monitor == null) {
                this.monitor = new AbapRepositoryMonitor();
            }
        }
        return this.monitor;
    }

    static {
        getFunctionInterfaceTables_v5 = getFunctionInterfaceTables_v4 = getFunctionInterfaceTables_v2;
        getStructureDefinitionImports_v2 = new DefaultListMetaData("STRDEFIMP", 1);
        getStructureDefinitionImports_v3 = new DefaultListMetaData("STRDEFIMP", 1);
        getStructureDefinitionExports = new DefaultListMetaData("STRDEFEXP", 1);
        getStructureDefinitionTables_v2 = new DefaultListMetaData("STRDEFTAB", 1);
        getStructureDefinitionTables_v3 = new DefaultListMetaData("STRDEFTAB", 1);
        ddifFieldInfoGetImports = new DefaultListMetaData("DDIFIMP", 4);
        ddifFieldInfoGetExports_v4 = new DefaultListMetaData("DDIFEXP", 4);
        ddifFieldInfoGetExports_v462 = new DefaultListMetaData("DDIFEXP", 4);
        ddifFieldInfoGetExports_v5 = new DefaultListMetaData("DDIFEXP", 4);
        ddifFieldInfoGetTables_v4 = new DefaultListMetaData("DDIFTAB", 1);
        ddifFieldInfoGetTables_v5 = new DefaultListMetaData("DDIFTAB", 1);
        ddifFieldInfoGetNUC = new byte[]{1};
        ddifFieldInfoGetUC = new byte[]{2};
        functionImportInterfaceImports = new DefaultListMetaData("FUNIMPINTIMP", 1);
        functionImportInterfaceTables = new DefaultListMetaData("FUNIMPINTTAB", 2);
        ABAP_TYPES = new String[]{"b", "I", "P", "D", "N", "T", "C", "F", "s", "X", "STRING", "XSTRING", "u", "v", "h", "DECFLOAT16", "DECFLOAT34"};
        ABAP_EXIDS = new char[]{'b', 'I', 'P', 'D', 'N', 'T', 'C', 'F', 's', 'X', 'g', 'y', 'u', 'v', 'h', 'a', 'e'};
        funint_v2.add("PARAMCLASS", 0, 1, 0, 2, 0);
        funint_v2.add("PARAMETER", 0, 30, 1, 60, 2);
        funint_v2.add("TABNAME", 0, 30, 31, 60, 62);
        funint_v2.add("FIELDNAME", 0, 30, 61, 60, 122);
        funint_v2.add("EXID", 0, 1, 91, 2, 182);
        funint_v2.add("POSITION", 8, 4, 92, 4, 184);
        funint_v2.add("OFFSET", 8, 4, 96, 4, 188);
        funint_v2.add("INTLENGTH", 8, 4, 100, 4, 192);
        funint_v2.add("DECIMALS", 8, 4, 104, 4, 196);
        funint_v2.add("DEFAULT", 0, 21, 108, 42, 200);
        funint_v2.add("PARAMTEXT", 0, 79, 129, 158, 242);
        funint_v2.add("OPTIONAL", 0, 1, 208, 2, 400);
        funint_v2.setRecordLength(216, 404);
        funint_v2.lock();
        fields_v2.add("TABNAME", 0, 30, 0, 0, 0);
        fields_v2.add("FIELDNAME", 0, 30, 30, 0, 0);
        fields_v2.add("POSITION", 8, 4, 60, 0, 0);
        fields_v2.add("OFFSET", 8, 4, 64, 0, 0);
        fields_v2.add("INTLENGTH", 8, 4, 68, 0, 0);
        fields_v2.add("DECIMALS", 8, 4, 72, 0, 0);
        fields_v2.add("EXID", 0, 1, 76, 0, 0);
        fields_v2.setRecordLength(77, 0);
        fields_v2.lock();
        funint_v3.add("PARAMCLASS", 0, 1, 0, 0, 0);
        funint_v3.add("PARAMETER", 0, 30, 1, 0, 0);
        funint_v3.add("TABNAME", 0, 10, 31, 0, 0);
        funint_v3.add("FIELDNAME", 0, 10, 41, 0, 0);
        funint_v3.add("EXID", 0, 1, 51, 0, 0);
        funint_v3.add("POSITION", 8, 4, 52, 0, 0);
        funint_v3.add("OFFSET", 8, 4, 56, 0, 0);
        funint_v3.add("INTLENGTH", 8, 4, 60, 0, 0);
        funint_v3.add("DECIMALS", 8, 4, 64, 0, 0);
        funint_v3.add("DEFAULT", 0, 21, 68, 0, 0);
        funint_v3.add("PARAMTEXT", 0, 79, 89, 0, 0);
        funint_v3.setRecordLength(168, 0);
        funint_v3.lock();
        fields_v3.add("TABNAME", 0, 10, 0, 0, 0);
        fields_v3.add("FIELDNAME", 0, 10, 10, 0, 0);
        fields_v3.add("POSITION", 8, 4, 20, 0, 0);
        fields_v3.add("OFFSET", 8, 4, 24, 0, 0);
        fields_v3.add("INTLENGTH", 8, 4, 28, 0, 0);
        fields_v3.add("DECIMALS", 8, 4, 32, 0, 0);
        fields_v3.add("EXID", 0, 1, 36, 0, 0);
        fields_v3.setRecordLength(40, 0);
        fields_v3.lock();
        rsimp_v3.add("PARAMETER", 0, 30, 0, 0, 0);
        rsimp_v3.add("DBFIELD", 0, 26, 30, 0, 0);
        rsimp_v3.add("DEFAULT", 0, 21, 56, 0, 0);
        rsimp_v3.add("TYPES", 0, 1, 77, 0, 0);
        rsimp_v3.add("OPTIONAL", 0, 1, 78, 0, 0);
        rsimp_v3.add("REFERENCE", 0, 1, 79, 0, 0);
        rsimp_v3.add("CHANGING", 0, 1, 80, 0, 0);
        rsimp_v3.add("TYP", 0, 30, 81, 0, 0);
        rsimp_v3.setRecordLength(112, 0);
        rsimp_v3.lock();
        rstbl_v3.add("PARAMETER", 0, 30, 0, 0, 0);
        rstbl_v3.add("DBSTRUCT", 0, 26, 30, 0, 0);
        rstbl_v3.add("TYPES", 0, 1, 56, 0, 0);
        rstbl_v3.add("OPTIONAL", 0, 1, 57, 0, 0);
        rstbl_v3.add("TYP", 0, 30, 58, 0, 0);
        rstbl_v3.setRecordLength(88, 0);
        rstbl_v3.lock();
        x030l_v4.add("TABNAME", 0, 30, 0, 0, 0);
        x030l_v4.add("DBASE", 0, 1, 30, 0, 0);
        x030l_v4.add("UUID", 4, 16, 31, 0, 0);
        x030l_v4.add("CRSTAMP", 0, 14, 47, 0, 0);
        x030l_v4.add("ABSTAMP", 0, 14, 61, 0, 0);
        x030l_v4.add("DYSTAMP", 0, 14, 75, 0, 0);
        x030l_v4.add("FLDCNT", 4, 2, 89, 0, 0);
        x030l_v4.add("TABLEN", 4, 2, 91, 0, 0);
        x030l_v4.add("KEYCNT", 4, 1, 93, 0, 0);
        x030l_v4.add("KEYLEN", 4, 1, 94, 0, 0);
        x030l_v4.add("CLPOS", 4, 1, 95, 0, 0);
        x030l_v4.add("TABTYPE", 0, 1, 96, 0, 0);
        x030l_v4.add("TABFORM", 0, 1, 97, 0, 0);
        x030l_v4.add("REFNAME", 0, 30, 98, 0, 0);
        x030l_v4.add("FLAGBYTE", 4, 1, 128, 0, 0);
        x030l_v4.add("EXROUT", 4, 1, 129, 0, 0);
        x030l_v4.add("FLAG3", 4, 1, 130, 0, 0);
        x030l_v4.add("FLAG4", 4, 1, 131, 0, 0);
        x030l_v4.add("FLAG5", 4, 1, 132, 0, 0);
        x030l_v4.add("FLAG6", 4, 1, 133, 0, 0);
        x030l_v4.add("BUFSTATE", 0, 1, 134, 0, 0);
        x030l_v4.add("BUFPARM", 4, 2, 135, 0, 0);
        x030l_v4.add("ALIGN", 4, 1, 137, 0, 0);
        x030l_v4.add("POINTERLG", 4, 1, 138, 0, 0);
        x030l_v4.add("UNICODELG", 4, 1, 139, 0, 0);
        x030l_v4.setRecordLength(140, 0);
        x030l_v4.lock();
        dfies_v4.add("TABNAME", 0, 30, 0, 60, 0);
        dfies_v4.add("FIELDNAME", 0, 30, 30, 60, 60);
        dfies_v4.add("LANGU", 0, 1, 60, 2, 120);
        dfies_v4.add("POSITION", 6, 4, 61, 8, 122);
        dfies_v4.add("OFFSET", 6, 6, 65, 12, 130);
        dfies_v4.add("DOMNAME", 0, 30, 71, 60, 142);
        dfies_v4.add("ROLLNAME", 0, 30, 101, 60, 202);
        dfies_v4.add("CHECKTABLE", 0, 30, 131, 60, 262);
        dfies_v4.add("LENG", 6, 6, 161, 12, 322);
        dfies_v4.add("INTLEN", 6, 6, 167, 12, 334);
        dfies_v4.add("OUTPUTLEN", 6, 6, 173, 12, 346);
        dfies_v4.add("DECIMALS", 6, 6, 179, 12, 358);
        dfies_v4.add("DATATYPE", 0, 4, 185, 8, 370);
        dfies_v4.add("INTTYPE", 0, 1, 189, 2, 378);
        dfies_v4.add("REFTABLE", 0, 30, 190, 60, 380);
        dfies_v4.add("REFFIELD", 0, 30, 220, 60, 440);
        dfies_v4.add("PRECFIELD", 0, 30, 250, 60, 500);
        dfies_v4.add("AUTHORID", 0, 3, 280, 6, 560);
        dfies_v4.add("MEMORYID", 0, 20, 283, 40, 566);
        dfies_v4.add("LOGFLAG", 0, 1, 303, 2, 606);
        dfies_v4.add("MASK", 0, 20, 304, 40, 608);
        dfies_v4.add("MASKLEN", 6, 4, 324, 8, 648);
        dfies_v4.add("CONVEXIT", 0, 5, 328, 10, 656);
        dfies_v4.add("HEADLEN", 6, 2, 333, 4, 666);
        dfies_v4.add("SCRLEN1", 6, 2, 335, 4, 670);
        dfies_v4.add("SCRLEN2", 6, 2, 337, 4, 674);
        dfies_v4.add("SCRLEN3", 6, 2, 339, 4, 678);
        dfies_v4.add("FIELDTEXT", 0, 60, 341, 120, 682);
        dfies_v4.add("REPTEXT", 0, 55, 401, 110, 802);
        dfies_v4.add("SCRTEXT_S", 0, 10, 456, 20, 912);
        dfies_v4.add("SCRTEXT_M", 0, 20, 466, 40, 932);
        dfies_v4.add("SCRTEXT_L", 0, 40, 486, 80, 972);
        dfies_v4.add("KEYFLAG", 0, 1, 526, 2, 1052);
        dfies_v4.add("LOWERCASE", 0, 1, 527, 2, 1054);
        dfies_v4.add("MAC", 0, 1, 528, 2, 1056);
        dfies_v4.add("GENKEY", 0, 1, 529, 2, 1058);
        dfies_v4.add("NOFORKEY", 0, 1, 530, 2, 1060);
        dfies_v4.add("VALEXI", 0, 1, 531, 2, 1062);
        dfies_v4.add("NOAUTHCH", 0, 1, 532, 2, 1064);
        dfies_v4.add("SIGN", 0, 1, 533, 2, 1066);
        dfies_v4.add("DYNPFLD", 0, 1, 534, 2, 1068);
        dfies_v4.add("F4AVAILABL", 0, 1, 535, 2, 1070);
        dfies_v4.setRecordLength(536, 1072);
        dfies_v4.lock();
        ddtypelist_v4.add("TYPENAME", 0, 30, 0, 60, 0);
        ddtypelist_v4.add("TYPEKIND", 0, 4, 30, 8, 60);
        ddtypelist_v4.add("FIELDS", 99, 8, 34, 8, 72, 0, null, dfies_v4, null);
        ddtypelist_v4.setRecordLength(48, 80);
        ddtypelist_v4.lock();
        x030l_v5.add("TABNAME", 0, 30, 0, 60, 0);
        x030l_v5.add("DBASE", 0, 1, 30, 2, 60);
        x030l_v5.add("UUID", 4, 16, 31, 16, 62);
        x030l_v5.add("CRSTAMP", 0, 14, 47, 28, 78);
        x030l_v5.add("ABSTAMP", 0, 14, 61, 28, 106);
        x030l_v5.add("DYSTAMP", 0, 14, 75, 28, 134);
        x030l_v5.add("FLDCNT", 4, 2, 89, 2, 162);
        x030l_v5.add("TABLEN", 4, 4, 91, 4, 164);
        x030l_v5.add("KEYCNT", 4, 1, 95, 1, 168);
        x030l_v5.add("KEYLEN", 4, 2, 96, 2, 169);
        x030l_v5.add("CLPOS", 4, 1, 98, 1, 171);
        x030l_v5.add("TABTYPE", 0, 1, 99, 2, 172);
        x030l_v5.add("TABFORM", 0, 1, 100, 2, 174);
        x030l_v5.add("REFNAME", 0, 30, 101, 60, 176);
        x030l_v5.add("FLAGBYTE", 4, 1, 131, 1, 236);
        x030l_v5.add("EXROUT", 4, 1, 132, 1, 237);
        x030l_v5.add("FLAG3", 4, 1, 133, 1, 238);
        x030l_v5.add("FLAG4", 4, 1, 134, 1, 239);
        x030l_v5.add("FLAG5", 4, 1, 135, 1, 240);
        x030l_v5.add("FLAG6", 4, 1, 136, 1, 241);
        x030l_v5.add("BUFSTATE", 0, 1, 137, 2, 242);
        x030l_v5.add("BUFPARM", 4, 2, 138, 2, 244);
        x030l_v5.add("ALIGN", 4, 1, 140, 1, 246);
        x030l_v5.add("POINTERLG", 4, 1, 141, 1, 247);
        x030l_v5.add("UNICODELG", 4, 1, 142, 1, 248);
        x030l_v5.add("COMPCNT", 4, 2, 143, 2, 249);
        x030l_v5.add("LEAFCNT", 4, 2, 145, 2, 251);
        x030l_v5.setRecordLength(147, 254);
        x030l_v5.lock();
        dfies_v5.copy(dfies_v4);
        dfies_v5.add("COMPTYPE", 0, 1, 536, 2, 1072);
        dfies_v5.add("LFIELDNAME", 0, 132, 537, 264, 1074);
        dfies_v5.setRecordLength(669, 1338);
        dfies_v5.lock();
        ddtypelist_v5.add("TYPENAME", 0, 30, 0, 60, 0);
        ddtypelist_v5.add("TYPEKIND", 0, 4, 30, 8, 60);
        ddtypelist_v5.add("FIELDS", 99, 8, 34, 8, 72, 0, null, dfies_v5, null);
        ddtypelist_v5.setRecordLength(48, 80);
        ddtypelist_v5.lock();
        getStructureDefinitionImports_v2.add("TABNAME", 0, 30, 60, 2);
        getStructureDefinitionImports_v2.lock();
        getStructureDefinitionImports_v3.add("TABNAME", 0, 10, 20, 2);
        getStructureDefinitionImports_v3.lock();
        getStructureDefinitionExports.add("TABLENGTH", 8, 4, 4, 4);
        getStructureDefinitionExports.lock();
        getStructureDefinitionTables_v2.add("FIELDS", 99, fields_v2, 0);
        getStructureDefinitionTables_v2.lock();
        getStructureDefinitionTables_v3.add("FIELDS", 99, fields_v3, 0);
        getStructureDefinitionTables_v3.lock();
        getFunctionInterfaceImports.add("FUNCNAME", 0, 30, 60, 2);
        getFunctionInterfaceImports.add("NONE_UNICODE_LENGTH", 0, 1, 2, 3);
        getFunctionInterfaceImports.lock();
        getFunctionInterfaceExports.add("REMOTE_BASXML_SUPPORTED", 0, 1, 2, 4);
        getFunctionInterfaceExports.lock();
        getFunctionInterfaceTables_v2.add("PARAMS", 99, funint_v2, 0);
        getFunctionInterfaceTables_v2.lock();
        getFunctionInterfaceTables_v3.add("PARAMS", 99, funint_v3, 0);
        getFunctionInterfaceTables_v3.lock();
        functionImportInterfaceImports.add("FUNCNAME", 0, 30, 0, 2);
        functionImportInterfaceImports.lock();
        functionImportInterfaceTables.add("IMPORT_PARAMETER", 99, rsimp_v3, 0);
        functionImportInterfaceTables.add("TABLES_PARAMETER", 99, rstbl_v3, 0);
        functionImportInterfaceTables.lock();
        ddifFieldInfoGetImports.add("TABNAME", 0, 30, 60, 2);
        ddifFieldInfoGetImports.add("ALL_TYPES", 0, 1, 2, 3);
        ddifFieldInfoGetImports.add("LFIELDNAME", 0, 132, 264, 3);
        ddifFieldInfoGetImports.add("UCLEN", 4, 1, 1, 3);
        ddifFieldInfoGetImports.lock();
        ddifFieldInfoGetExports_v4.add("DFIES_WA", 17, dfies_v4, 4);
        ddifFieldInfoGetExports_v4.add("X030L_WA", 17, x030l_v4, 4);
        ddifFieldInfoGetExports_v4.add("DDOBJTYPE", 0, 31, 62, 4);
        ddifFieldInfoGetExports_v4.add("LINES_DESCR", 99, ddtypelist_v4, 4);
        ddifFieldInfoGetExports_v4.lock();
        ddifFieldInfoGetExports_v462.add("DFIES_WA", 17, dfies_v5, 4);
        ddifFieldInfoGetExports_v462.add("X030L_WA", 17, x030l_v4, 4);
        ddifFieldInfoGetExports_v462.add("DDOBJTYPE", 0, 31, 62, 4);
        ddifFieldInfoGetExports_v462.add("LINES_DESCR", 99, ddtypelist_v5, 4);
        ddifFieldInfoGetExports_v462.lock();
        ddifFieldInfoGetTables_v4.add("DFIES_TAB", 99, dfies_v4, 0);
        ddifFieldInfoGetTables_v4.lock();
        ddifFieldInfoGetExports_v5.add("DFIES_WA", 17, dfies_v5, 4);
        ddifFieldInfoGetExports_v5.add("X030L_WA", 17, x030l_v5, 4);
        ddifFieldInfoGetExports_v5.add("DDOBJTYPE", 0, 31, 62, 4);
        ddifFieldInfoGetExports_v5.add("LINES_DESCR", 99, ddtypelist_v5, 4);
        ddifFieldInfoGetExports_v5.lock();
        ddifFieldInfoGetTables_v5.add("DFIES_TAB", 99, dfies_v5, 0);
        ddifFieldInfoGetTables_v5.lock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AbapRepositoryMonitor
    extends BasicRepository.BasicRepositoryMonitor {
        AbapRepositoryMonitor() {
            super(AbapRepository.this);
        }

        @Override
        public long getLastRemoteQueryTimestamp() {
            return AbapRepository.this.lastRemoteQueryTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getDestinationIDs() {
            ArrayList<String> ids = new ArrayList<String>(AbapRepository.this.availableDestinations.size() + 1);
            LinkedList<InternalDestination> linkedList = AbapRepository.this.availableDestinations;
            synchronized (linkedList) {
                for (InternalDestination iDest : AbapRepository.this.availableDestinations) {
                    ids.add(iDest.getDestinationID());
                }
            }
            if (AbapRepository.this.destination != null) {
                ids.add(AbapRepository.this.destination.getDestinationID());
            }
            return ids;
        }

        @Override
        public JCoDestinationMonitor getRespositoryDestinationMonitor(String destinationID) {
            DefaultDestinationManager mgr = JCoRuntimeFactory.getRuntime().getDestinationManager();
            return mgr.getRepositoryDestinationMonitor(destinationID);
        }
    }
}

