/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.util.I18NConverters;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertXToC;

public class Converter {
    private static char[] ZERO_ARRAY = "\u0000\u0000\u0000\u0000".toCharArray();
    ConvertCToX c2xConverter;
    ConvertXToC x2cConverter;
    String receiveCodepage;
    String sendCodepage;
    boolean littleEndian;
    int receiveI;
    int sendI;

    public Converter() {
        this(AbSysInfo.charset, AbSysInfo.charset, false);
    }

    public Converter(RfcIoOpenCntl currentCntl) {
        this(currentCntl.getCommunicationCodepage(), currentCntl.pcs == 2 ? currentCntl.getCodepage() : currentCntl.getCommunicationCodepage(), 1 == currentCntl.intformat);
    }

    public Converter(String receiveCodepage, String sendCodepage, boolean littleEndian) {
        this.init(receiveCodepage, sendCodepage, littleEndian);
    }

    private void init(String receiveCodepage, String sendCodepage, boolean littleEndian) {
        this.x2cConverter = I18NConverters.getConvertXToC(receiveCodepage);
        this.c2xConverter = I18NConverters.getConvertCToX(sendCodepage);
        this.receiveCodepage = receiveCodepage;
        this.sendCodepage = sendCodepage;
        this.littleEndian = littleEndian;
        this.receiveI = receiveCodepage.startsWith("410") ? 1 : 0;
        this.sendI = sendCodepage.startsWith("410") ? 1 : 0;
    }

    public void update(String receiveCodepage, String sendCodepage, boolean littleEndian) {
        this.init(receiveCodepage, sendCodepage, littleEndian);
    }

    protected final void encodeNumber(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int end = offset + ilength - 1;
        System.arraycopy(ZERO_ARRAY, 0, temp_data, iboffset, rec.metaData.blength[index]);
        if (ilength > 2 * rec.metaData.blength[index]) {
            ilength = 2 * rec.metaData.blength[index];
        }
        if (this.littleEndian) {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                temp_data[n] = (char)(temp_data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                temp_data[n] = (char)(temp_data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        }
    }

    protected final void encodeBinary(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int iend = iboffset + rec.metaData.blength[index];
        for (int i = iboffset; i < iend; ++i) {
            temp_data[i] = '\u0000';
        }
        if (ilength > 2 * rec.metaData.blength[index]) {
            ilength = 2 * rec.metaData.blength[index];
        }
        for (int k = 0; k < ilength; ++k) {
            int n = iboffset + (k >> 1);
            temp_data[n] = (char)(temp_data[n] | (char)((value[offset + k] & 0xFF) << (1 - (k & 1) << 3)));
        }
    }

    protected final void encodeChar(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int iend = iboffset + rec.metaData.blength[index];
        int fieldEnd = Math.min(offset + ilength, value.length);
        int filledChars = this.x2cConverter.ConvertArr(value, offset, fieldEnd, temp_data, iboffset, iend);
        for (int i = iboffset + filledChars; i < iend; ++i) {
            temp_data[i] = 32;
        }
    }

    protected final void decodeNumber(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int end = offset + ilength - 1;
        if (ilength > 2 * rec.metaData.blength[index]) {
            ilength = 2 * rec.metaData.blength[index];
        }
        if (AbSysInfo.littleEndianPlatform) {
            for (int k = 0; k < ilength; ++k) {
                buffer[end - k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        }
    }

    protected final void decodeBinary(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        if (ilength > 2 * rec.metaData.blength[index]) {
            ilength = 2 * rec.metaData.blength[index];
        }
        for (int k = 0; k < ilength; ++k) {
            buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    protected final void decodeChar(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int iend = iboffset + rec.metaData.blength[index];
        this.c2xConverter.ConvertArr(temp_data, iboffset, iend, buffer, offset, offset + ilength);
    }

    protected final void encodeDecNumber(AbstractRecord rec, byte[] value, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int end = offset + ilength - 1;
        if (this.littleEndian) {
            for (int k = 0; k < ilength; k += 2) {
                char c = (char)((value[end - k] & 0xFF) << 8);
                temp_data[iboffset + (k >> 1)] = c = (char)(c | (char)(value[end - k - 1] & 0xFF));
            }
        } else {
            for (int k = 0; k < ilength; k += 2) {
                char c = (char)((value[offset + k] & 0xFF) << 8);
                temp_data[iboffset + (k >> 1)] = c = (char)(c | (char)(value[offset + k + 1] & 0xFF));
            }
        }
    }

    protected final void decodeDecNumber(AbstractRecord rec, byte[] buffer, int index, int offset, int ilength) {
        char[] temp_data = rec.recType == 4 ? rec.tableDataRows[rec.row] : rec.data;
        int iboffset = rec.metaData.boffset[index];
        int end = offset + ilength - 1;
        if (AbSysInfo.littleEndianPlatform) {
            for (int k = 0; k < ilength; ++k) {
                buffer[end - k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                buffer[offset + k] = (byte)(temp_data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        }
    }

    protected final void encodeNestedType1Number(DefaultStructure rec, byte[] value, int index) {
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.receiveI][index];
        int end = rec.type1Record.type1MetaData.type1Offset[this.receiveI][index] + rec.type1Record.type1MetaData.type1Length[this.receiveI][index] - 1;
        System.arraycopy(ZERO_ARRAY, 0, rec.type1Record.type1Data, iboffset, rec.type1Record.type1MetaData.type1BLnegth[index]);
        if (ilength > 2 * rec.type1Record.type1MetaData.type1BLnegth[index]) {
            ilength = 2 * rec.type1Record.type1MetaData.type1BLnegth[index];
        }
        if (this.littleEndian) {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[rec.type1Record.type1MetaData.type1Offset[this.receiveI][index] + k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        }
    }

    protected final void encodeNestedType1Binary(DefaultStructure rec, byte[] value, int index) {
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.receiveI][index];
        int iend = iboffset + rec.type1Record.type1MetaData.type1BLnegth[index];
        for (int i = iboffset; i < iend; ++i) {
            rec.type1Record.type1Data[i] = '\u0000';
        }
        if (ilength > 2 * rec.type1Record.type1MetaData.type1BLnegth[index]) {
            ilength = 2 * rec.type1Record.type1MetaData.type1BLnegth[index];
        }
        for (int k = 0; k < ilength; ++k) {
            int n = iboffset + (k >> 1);
            rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[rec.type1Record.type1MetaData.type1Offset[this.receiveI][index] + k] & 0xFF) << (1 - (k & 1) << 3)));
        }
    }

    protected final void encodeNestedType1Char(DefaultStructure rec, byte[] value, int index) {
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int iend = iboffset + rec.type1Record.type1MetaData.type1BLnegth[index];
        int fieldEnd = Math.min(rec.type1Record.type1MetaData.type1Offset[this.receiveI][index] + rec.type1Record.type1MetaData.type1Length[this.receiveI][index], value.length);
        int filledChars = this.x2cConverter.ConvertArr(value, rec.type1Record.type1MetaData.type1Offset[this.receiveI][index], fieldEnd, rec.type1Record.type1Data, iboffset, iend);
        for (int i = iboffset + filledChars; i < iend; ++i) {
            rec.type1Record.type1Data[i] = 32;
        }
    }

    protected final void decodeNestedType1Number(DefaultStructure rec, byte[] buffer, int index) {
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.sendI][index];
        int end = rec.type1Record.type1MetaData.type1Offset[this.sendI][index] + rec.type1Record.type1MetaData.type1Length[this.sendI][index] - 1;
        if (ilength > 2 * rec.type1Record.type1MetaData.type1BLnegth[index]) {
            ilength = 2 * rec.type1Record.type1MetaData.type1BLnegth[index];
        }
        if (AbSysInfo.littleEndianPlatform) {
            for (int k = 0; k < ilength; ++k) {
                buffer[end - k] = (byte)(rec.type1Record.type1Data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                buffer[rec.type1Record.type1MetaData.type1Offset[this.sendI][index] + k] = (byte)(rec.type1Record.type1Data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        }
    }

    protected final void encodeNestedType1DecNumber(DefaultStructure rec, byte[] value, int index) {
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.receiveI][index];
        int end = rec.type1Record.type1MetaData.type1Offset[this.receiveI][index] + rec.type1Record.type1MetaData.type1Length[this.receiveI][index] - 1;
        if (this.littleEndian) {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[end - k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                int n = iboffset + (k >> 1);
                rec.type1Record.type1Data[n] = (char)(rec.type1Record.type1Data[n] | (char)((value[rec.type1Record.type1MetaData.type1Offset[this.receiveI][index] + k] & 0xFF) << (1 - (k & 1) << 3)));
            }
        }
    }

    protected final void decodeNestedType1DecNumber(DefaultStructure rec, byte[] buffer, int index) {
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int ilength = rec.type1Record.type1MetaData.type1Length[this.sendI][index];
        int end = rec.type1Record.type1MetaData.type1Offset[this.sendI][index] + rec.type1Record.type1MetaData.type1Length[this.sendI][index] - 1;
        if (AbSysInfo.littleEndianPlatform) {
            for (int k = 0; k < ilength; ++k) {
                buffer[end - k] = (byte)(rec.type1Record.type1Data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        } else {
            for (int k = 0; k < ilength; ++k) {
                buffer[rec.type1Record.type1MetaData.type1Offset[this.sendI][index] + k] = (byte)(rec.type1Record.type1Data[iboffset + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
            }
        }
    }

    protected final void decodeNestedType1Binary(DefaultStructure rec, byte[] buffer, int index) {
        int ilength = rec.type1Record.type1MetaData.type1Length[this.sendI][index];
        if (ilength > 2 * rec.type1Record.type1MetaData.type1BLnegth[index]) {
            ilength = 2 * rec.type1Record.type1MetaData.type1BLnegth[index];
        }
        for (int k = 0; k < ilength; ++k) {
            buffer[rec.type1Record.type1MetaData.type1Offset[this.sendI][index] + k] = (byte)(rec.type1Record.type1Data[rec.type1Record.type1MetaData.type1BOffset[index] + (k >> 1)] >> (1 - (k & 1) << 3) & 0xFF);
        }
    }

    protected final void decodeNestedType1Char(DefaultStructure rec, byte[] buffer, int index) {
        int iboffset = rec.type1Record.type1MetaData.type1BOffset[index];
        int iend = iboffset + rec.type1Record.type1MetaData.type1BLnegth[index];
        this.c2xConverter.ConvertArr(rec.type1Record.type1Data, iboffset, iend, buffer, rec.type1Record.type1MetaData.type1Offset[this.sendI][index], rec.type1Record.type1MetaData.type1Offset[this.sendI][index] + rec.type1Record.type1MetaData.type1Length[this.sendI][index]);
    }
}

