/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoResponse;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.CallbackHandler;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultRequest;
import com.sap.conn.jco.rt.DefaultResponse;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.ExtendedCallHandlerFactory;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.ServerAuthorizationData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerWorker;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoApplicationAuthorizationException;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandler;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;
import com.sap.conn.jco.server.JCoServerRunnable;
import com.sap.conn.jco.server.JCoServerSecurityHandler;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import com.sap.conn.jco.util.FastStringBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DefaultServerWorker
extends ServerWorker
implements JCoServerRunnable {
    private CallbackHandler callbackHandler = new CallbackHandlerImpl();
    protected JCoServerSecurityHandler securityHandler;
    protected JCoServerTIDHandler tidManager;
    protected JCoServerCallHandlerFactory sessionManager;
    protected ServerContext ctx = new ServerContext();
    protected CallDispatcher callDispatcher;
    private static ThreadLocal<DefaultServerWorker> localWorker = new ThreadLocalWorker();
    boolean stopping = false;
    volatile Thread workerThread = null;
    private volatile SessionReferenceProvider sessionRefProvider = null;
    private volatile boolean sessionProviderNotified = false;

    protected DefaultServerWorker(DefaultServer server) {
        this.server = server;
        JCoServerCallHandlerFactory callHandlerFactory = server.getCallHandlerFactory();
        if (callHandlerFactory instanceof JCoServerFunctionHandlerFactory) {
            this.callDispatcher = new FunctionDispatcher((JCoServerFunctionHandlerFactory)callHandlerFactory);
        } else if (callHandlerFactory instanceof JCoServerRequestHandlerFactory) {
            this.callDispatcher = new RequestDispatcher((JCoServerRequestHandlerFactory)callHandlerFactory);
        }
        this.tidManager = server.getTIDHandler();
        this.securityHandler = server.getSecurityHandler();
        this.sessionManager = callHandlerFactory;
    }

    protected static DefaultServerWorker getThreadLocalServerWorker() {
        return localWorker.get();
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public JCoServerContext getContext() throws IllegalStateException {
        ServerConnection sConn = this.getConnection();
        if (sConn == null || !sConn.isValid()) {
            throw new IllegalStateException("connection was not assinged or was already removed");
        }
        return this.ctx;
    }

    protected void fireServerErrorOccurred(Error error) {
        this.server.fireServerErrorOccurred(this, this.conn, error);
    }

    protected void fireServerExceptionOccurred(Exception exception) {
        this.server.fireServerExceptionOccurred(this, this.conn, exception);
    }

    protected boolean checkAuthorization(String functionName, ServerAuthorizationData authData) {
        if (this.securityHandler != null) {
            try {
                this.securityHandler.checkAuthorization(this.ctx, functionName, authData);
            }
            catch (JCoApplicationAuthorizationException ae) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTraceCritical("Application declines the authorization", ae);
                }
                return false;
            }
            catch (Throwable th) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTraceCritical("security handler throws error on authorization request", th);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchRequest(JCoFunction function) throws AbapException {
        try {
            localWorker.set(this);
            this.callDispatcher.handleRequest(this.ctx, function);
        }
        finally {
            localWorker.set(null);
        }
    }

    protected JCoFunction getFunction(String functionName) throws JCoException {
        try {
            return this.callDispatcher.getFunction(this.ctx, functionName);
        }
        catch (RuntimeException ex) {
            this.fireServerExceptionOccurred(ex);
            throw ex;
        }
    }

    void destroy() {
        this.workerThread = null;
        this.conn = null;
        this.server = null;
    }

    public Thread getThread() {
        return this.workerThread;
    }

    protected boolean onCheckTID(String tid) {
        this.ctx.tid = tid;
        return this.tidManager.checkTID(this.ctx, tid);
    }

    protected void onCommit(String tid) {
        this.ctx.tid = null;
        this.tidManager.commit(this.ctx, tid);
    }

    protected void onConfirmTID(String tid) {
        this.tidManager.confirmTID(this.ctx, tid);
    }

    protected void onRollback(String tid) {
        this.ctx.tid = null;
        this.tidManager.rollback(this.ctx, tid);
    }

    public void run() {
        this.workerThread = Thread.currentThread();
        this.loop();
        if (Trace.isOn(16)) {
            Trace.fireTrace(16, new StringBuffer("[JCoAPI] JCoServer.run() leave run method in ").append(Thread.currentThread().getName()).append(" thread").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatch() {
        if (Trace.isOn(32)) {
            StringBuilder sb = new StringBuilder();
            sb.append("[JCoAPI] JCoServer.dispatch ").append(this.getThread().getName()).append(": handle ");
            if (this.conn != null) {
                sb.append(this.conn.getConnectionHandle());
            } else {
                sb.append("null");
            }
            Trace.fireTrace(32, sb.toString());
        }
        if (this.conn == null && Trace.isOn(4, true)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Throwable t = new Throwable();
            t.fillInStackTrace();
            t.printStackTrace(pw);
            pw.close();
            Trace.fireTrace(4, "ERROR: connection null in JCO.Server.work" + sw.getBuffer().toString());
        }
        String lastErrorMsg = null;
        try {
            this.conn.middlewareServer.listen(this);
        }
        catch (JCoException ex) {
            this.fireServerExceptionOccurred(ex);
            lastErrorMsg = new StringBuffer(ex.getKey()).append(": ").append(ex.getMessage()).toString();
        }
        catch (Exception ex) {
            this.fireServerExceptionOccurred(ex);
            lastErrorMsg = ex.toString();
        }
        catch (Error err) {
            this.fireServerErrorOccurred(err);
            lastErrorMsg = err.toString();
        }
        finally {
            block25: {
                if (lastErrorMsg != null && this.conn.isValid()) {
                    this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                    try {
                        this.abort(lastErrorMsg);
                    }
                    catch (Throwable t) {
                        if (!Trace.isOn(4, true)) break block25;
                        Trace.fireTrace(4, new StringBuffer("[JCoAPI] Error during sending the error message [").append(lastErrorMsg).append("] to backend: ").append(t.toString()).toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loop() {
        while (!this.stopping) {
            DefaultServer.RequestQueue requestQueue = this.server.getRequestQueue();
            synchronized (requestQueue) {
                this.conn = this.server.getRequestQueue().getRequest();
            }
            try {
                if (this.conn == null) continue;
                try {
                    this.dispatch();
                }
                catch (Throwable t) {
                    Trace.fireTraceCritical("[JCoAPI] ERROR: exception in dispatch ", t);
                }
            }
            finally {
                if (this.server == null) continue;
                this.server.releaseListener(this);
            }
        }
        this.server.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void abort(String message) throws JCoException {
        if (Trace.isOn(68, true)) {
            Trace.fireTrace(68, new FastStringBuffer(150).append("[JCoAPI] JCoServer.abort(\"").append(message).append("\") on [").append(this.conn.getConnectionHandle()).append("]").toString());
        }
        try {
            if (this.isValid()) {
                this.conn.middlewareServer.abort(this, message);
            }
        }
        finally {
            this.setState((byte)(this.conn.state & 0xFFFFFFF7));
        }
    }

    void removeConnectionHandle() {
        this.conn.serverGroup.removeConnection(this.conn);
    }

    final void callStartedInternal() {
        if (this.sessionRefProvider == null) {
            this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JcoAPI] JCoServer.callStartedInternal(), SessionRefProvider is " + (this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()));
        }
        if (this.sessionRefProvider != null) {
            try {
                String sessionID = this.conn.getSessionId();
                if (sessionID == null) {
                    this.sessionRefProvider.jcoServerSessionStarted();
                } else {
                    this.sessionRefProvider.jcoServerSessionContinued(sessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation of the SessionReferenceProvider throws " + e.toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation of the SessionReferenceProvider throws " + e.toString(), e);
                }
                throw e;
            }
            this.sessionProviderNotified = true;
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JcoAPI] JCoServer.callStartedInternal() leave");
        }
    }

    final void callFinishedInternal() {
        if (this.sessionRefProvider == null) {
            this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JcoAPI] JCoServer.callFinishedInternal(), SessionRefProvider is " + (this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()));
        }
        if (this.sessionRefProvider != null) {
            try {
                String sessionID = this.conn.getSessionId();
                if (sessionID == null) {
                    this.sessionRefProvider.jcoServerSessionFinished(sessionID);
                } else {
                    this.sessionRefProvider.jcoServerSessionPassivated(sessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation of the SessionReferenceProvider throws " + e.toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation of the SessionReferenceProvider throws " + e.toString(), e);
                }
                throw e;
            }
            this.sessionProviderNotified = false;
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JcoAPI] JCoServer.callFinishedInternal() leave");
        }
    }

    protected void onSessionClose(String message, boolean error) {
        block12: {
            String sessionID;
            block11: {
                block10: {
                    if (this.sessionRefProvider == null) {
                        this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
                    }
                    sessionID = this.conn.getSessionId();
                    if (this.sessionRefProvider != null && !this.sessionProviderNotified) {
                        try {
                            this.sessionRefProvider.jcoServerSessionContinued(sessionID);
                        }
                        catch (Throwable th) {
                            if (!Trace.isOn(4)) break block10;
                            Trace.fireTrace(4, "[JCoAPI] jcoServerSessionContinued() throws:" + th.toString(), th);
                        }
                    }
                }
                if (Trace.isOn(128)) {
                    Trace.fireTrace(128, "[JcoAPI] ServerWorker.onSessionClose(): session is closed");
                }
                try {
                    this.sessionManager.sessionClosed(this.ctx, message, error);
                }
                catch (Throwable th) {
                    if (!Trace.isOn(4)) break block11;
                    Trace.fireTrace(4, "[JCoAPI] sessionClosed() throws:" + th.toString(), th);
                }
            }
            if (this.sessionRefProvider != null) {
                try {
                    this.sessionRefProvider.jcoServerSessionFinished(sessionID);
                }
                catch (Throwable th) {
                    if (!Trace.isOn(4)) break block12;
                    Trace.fireTrace(4, "[JCoAPI] jcoServerSessionFinished() throws:" + th.toString(), th);
                }
            }
        }
    }

    void setState(byte state) {
        this.conn.state = state;
    }

    byte getState() {
        return this.conn.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalWorker
    extends ThreadLocal<DefaultServerWorker> {
        private DefaultServerWorker worker = null;

        private ThreadLocalWorker() {
        }

        @Override
        public DefaultServerWorker get() {
            if (this.worker == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "Unable to execute callback. Callback is allowed within the server thread only.");
            }
            return this.worker;
        }

        @Override
        public void set(DefaultServerWorker handler) {
            this.worker = handler;
        }
    }

    public class RequestDispatcher
    extends CallDispatcher {
        private JCoServerRequestHandlerFactory aFactory;

        public RequestDispatcher(JCoServerRequestHandlerFactory factory) {
            super(factory);
            this.aFactory = factory;
        }

        protected JCoServerRequestHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException {
            JCoServerRequestHandler handler = this.aFactory.getCallHandler(serverCtx, function.getName());
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuffer("the call handler factory [").append(this.aFactory.getClass().getName()).append("] returs null for the function ").append(function.getName()).toString());
            }
            DefaultRequest request = new DefaultRequest(function);
            DefaultResponse response = request.getResponse();
            handler.handleRequest(serverCtx, request, response);
            return handler;
        }
    }

    public class FunctionDispatcher
    extends CallDispatcher {
        private JCoServerFunctionHandlerFactory aFactory;

        public FunctionDispatcher(JCoServerFunctionHandlerFactory factory) {
            super(factory);
            this.aFactory = factory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected JCoServerFunctionHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException {
            FastStringBuffer buf;
            JCoServerFunctionHandler handler;
            block13: {
                block12: {
                    FastStringBuffer buf22222;
                    String errorMsg = null;
                    handler = null;
                    try {
                        try {
                            if (Trace.isOn(64)) {
                                buf = new FastStringBuffer(120).append("[JCoAPI] JCoServer dispatches (").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" before getCallHandler()");
                                Trace.fireTrace(64, buf.toString());
                            }
                            handler = this.aFactory.getCallHandler(serverCtx, function.getName());
                        }
                        catch (RuntimeException re) {
                            errorMsg = re.toString();
                            throw re;
                        }
                        catch (Error er) {
                            errorMsg = er.toString();
                            throw er;
                        }
                        Object var7_8 = null;
                        if (errorMsg == null) break block12;
                        buf22222 = new FastStringBuffer(120).append("[JCoAPI] JCoServer dispatches (").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" getCallHandler() thrown ").append(errorMsg);
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (errorMsg != null) {
                            FastStringBuffer buf22222 = new FastStringBuffer(120).append("[JCoAPI] JCoServer dispatches (").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" getCallHandler() thrown ").append(errorMsg);
                            Trace.fireTrace(4, buf22222.toString());
                            throw throwable;
                        }
                        if (!Trace.isOn(64)) throw throwable;
                        FastStringBuffer buf3 = new FastStringBuffer(120).append("[JCoAPI] JCoServer dispatches (").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" after getCallHandler(), factory is ").append(handler == null ? "null" : handler.getClass().getName());
                        Trace.fireTrace(64, buf3.toString());
                        throw throwable;
                    }
                    Trace.fireTrace(4, buf22222.toString());
                    break block13;
                }
                if (Trace.isOn(64)) {
                    FastStringBuffer buf3 = new FastStringBuffer(120).append("[JCoAPI] JCoServer dispatches (").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" after getCallHandler(), factory is ").append(handler == null ? "null" : handler.getClass().getName());
                    Trace.fireTrace(64, buf3.toString());
                }
            }
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuffer("the call handler factory [").append(this.aFactory.getClass().getName()).append("] returs null for the function ").append(function.getName()).toString());
            }
            if (Trace.isOn(88)) {
                buf = new FastStringBuffer(120).append("[JCoAPI] JCoServer before dispatch (").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]");
                if (Trace.isOn(16)) {
                    Trace.dumpFunction(buf, true, true, false, function);
                }
                Trace.fireTrace(88, buf.toString());
            }
            handler.handleRequest(serverCtx, function);
            if (!Trace.isOn(88)) return handler;
            buf = new FastStringBuffer(120).append("[JCoAPI] JCoServer after dispatch (").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("]");
            if (Trace.isOn(16)) {
                Trace.dumpFunction(buf, false, false, true, function);
            }
            Trace.fireTrace(88, buf.toString());
            return handler;
        }
    }

    public abstract class CallDispatcher {
        private ExtendedCallHandlerFactory extFactory = null;

        protected CallDispatcher(JCoServerCallHandlerFactory factory) {
            if (factory instanceof ExtendedCallHandlerFactory) {
                this.extFactory = (ExtendedCallHandlerFactory)((Object)factory);
            }
        }

        protected abstract Object handleRequest(JCoServerContext var1, JCoFunction var2) throws AbapException;

        protected JCoFunction getFunction(JCoServerContext serverCtx, String functionName) throws JCoException {
            if (this.extFactory != null) {
                return this.extFactory.getFunction(serverCtx, functionName);
            }
            return DefaultServerWorker.this.server.getRepository().getFunction(functionName);
        }
    }

    class ServerContext
    implements JCoServerContext {
        String tid;

        ServerContext() {
        }

        public JCoAttributes getConnectionAttributes() {
            try {
                return DefaultServerWorker.this.conn.getAttributes();
            }
            catch (JCoException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] exception in JCoServer.getConnectionAttributes: " + e.toString(), e);
                }
                return null;
            }
        }

        public String getConnectionID() {
            return DefaultServerWorker.this.conn.getConnectionId();
        }

        public JCoRepository getRepository() {
            return DefaultServerWorker.this.server.getRepository();
        }

        public JCoServer getServer() {
            return DefaultServerWorker.this.server;
        }

        public String getSessionID() {
            return DefaultServerWorker.this.conn.getSessionId();
        }

        public String getTID() {
            return this.tid;
        }

        public boolean isInTransaction() {
            return this.tid != null;
        }

        public boolean isStatefulSession() {
            return this.getSessionID() != null;
        }

        public void setStateful(boolean stateful) {
            String sessionID = null;
            if (stateful) {
                sessionID = DefaultServerWorker.this.sessionRefProvider.getCurrentSessionReference(null).getID();
            }
            DefaultServerWorker.this.conn.setSessionState(stateful, sessionID);
        }
    }

    protected class CallbackHandlerImpl
    implements CallbackHandler {
        protected CallbackHandlerImpl() {
        }

        void checkState() {
            if ((DefaultServerWorker.this.conn.state & 4) == 0) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "CallbackHandler can be used while call dispatching (JCO.Server.handleRequest()) only.");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(JCoFunction function) throws JCoException {
            int i2;
            boolean isTaskMonitorOn;
            JCoRuntime runtime;
            DefaultParameterList outputTables;
            DefaultParameterList inputTables;
            DefaultParameterList output;
            DefaultParameterList changing;
            block41: {
                int i7222;
                this.checkState();
                String name = function.getName();
                DefaultParameterList input = (DefaultParameterList)function.getImportParameterList();
                changing = (DefaultParameterList)function.getChangingParameterList();
                output = (DefaultParameterList)function.getExportParameterList();
                inputTables = (DefaultParameterList)function.getTableParameterList();
                outputTables = (DefaultParameterList)function.getTableParameterList();
                runtime = JCoRuntimeFactory.getRuntime();
                isTaskMonitorOn = runtime.isTaskMonitorOn();
                if (isTaskMonitorOn) {
                    StringBuilder monitorText = new StringBuilder();
                    monitorText.append("JCo executing ").append(name).append(" [").append(DefaultServerWorker.this.conn.attributes.sysid).append("|").append(DefaultServerWorker.this.conn.attributes.getPartnerHost()).append("|").append(DefaultServerWorker.this.conn.attributes.getCPICConversationID()).append("]");
                    runtime.startTask(monitorText.toString());
                }
                if (input != null) {
                    input.checkIfInitialized();
                    for (int i2 = 0; i2 < input.getMetaData().getFieldCount(); ++i2) {
                        if (input.isActive(i2) && input.isInitialized(i2)) continue;
                        int n = i2;
                        input.flags[n] = (byte)(input.flags[n] | 8);
                    }
                }
                if (inputTables != null) {
                    for (int i3 = 0; i3 < inputTables.getMetaData().getFieldCount(); ++i3) {
                        if (inputTables.isActive(i3)) continue;
                        int n = i3;
                        inputTables.flags[n] = (byte)(inputTables.flags[n] | 8);
                    }
                }
                if (changing != null) {
                    changing.checkIfInitialized();
                    for (int i4 = 0; i4 < changing.getMetaData().getFieldCount(); ++i4) {
                        if (changing.isActive(i4) && changing.isInitialized(i4)) continue;
                        int n = i4;
                        changing.flags[n] = (byte)(changing.flags[n] | 8);
                    }
                }
                if (output != null) {
                    for (int i5 = 0; i5 < output.getMetaData().getFieldCount(); ++i5) {
                        if (output.isActive(i5)) continue;
                        int n = i5;
                        output.flags[n] = (byte)(output.flags[n] | 8);
                    }
                }
                if (outputTables != null) {
                    for (int i6 = 0; i6 < outputTables.getMetaData().getFieldCount(); ++i6) {
                        if (outputTables.isActive(i6)) continue;
                        int n = i6;
                        outputTables.flags[n] = (byte)(outputTables.flags[n] | 8);
                    }
                }
                try {
                    try {
                        FastStringBuffer buf;
                        if (Trace.isOn(80)) {
                            buf = new FastStringBuffer(120).append("[JCoAPI] ServerWorker.execute (").append(name).append(") on handle [").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("]");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, true, true, false, function);
                            }
                            Trace.fireTrace(80, buf.toString());
                        }
                        DefaultServerWorker.this.conn.middlewareServer.execute(DefaultServerWorker.this, name, input, inputTables, changing, output, function.getFunctionTemplate().supportsASXML());
                        if (Trace.isOn(80)) {
                            buf = new FastStringBuffer(200).append("[JCoAPI] ServerWorker.execute (").append(name);
                            buf.append(") on handle [").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("] returns ");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, false, false, true, function);
                            }
                            Trace.fireTrace(80, buf.toString());
                        }
                    }
                    catch (AbapException ex) {
                        if (!Trace.isOn(64)) throw ex;
                        Trace.fireTrace(64, new FastStringBuffer(120).append("[JCoAPI] ServerWorker.execute (").append(name).append(") threw an ABAP exception: ").append(ex.toString()).toString());
                        throw ex;
                    }
                    catch (JCoException ex) {
                        if (!Trace.isOn(68)) throw ex;
                        Trace.fireTrace(68, new FastStringBuffer(120).append("[JCoAPI] ServerWorker.execute (").append(name).append(") threw a NON-ABAP exception: ").append(ex.toString()).toString());
                        Trace.fireTrace(32, "[JCoAPI] ServerWorker.execute threw a NON-ABAP exception", ex);
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (!Trace.isOn(68)) throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                        Trace.fireTrace(68, new FastStringBuffer(120).append("[JCoAPI] ServerWorker.execute (").append(name).append(") threw a NON-ABAP exception: ").append(ex.toString()).toString());
                        Trace.fireTrace(32, "[JCoAPI] ServerWorker.execute threw a NON-ABAP exception", ex);
                        throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                    }
                    Object var12_19 = null;
                    if (input == null) break block41;
                    i7222 = 0;
                }
                catch (Throwable throwable) {
                    int i2;
                    Object var12_20 = null;
                    if (input != null) {
                        int i7222 = 0;
                        while (i7222 < input.getMetaData().getFieldCount()) {
                            int n = i7222++;
                            input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (inputTables != null) {
                        int i22 = 0;
                        while (i22 < inputTables.getMetaData().getFieldCount()) {
                            int n = i22++;
                            inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (changing != null) {
                        int i22 = 0;
                        while (i22 < changing.getMetaData().getFieldCount()) {
                            int n = i22++;
                            changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (output != null) {
                        i2 = 0;
                        while (i2 < output.getMetaData().getFieldCount()) {
                            int n = i2++;
                            output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (outputTables != null) {
                        i2 = 0;
                        while (i2 < outputTables.getMetaData().getFieldCount()) {
                            int n = i2++;
                            outputTables.flags[n] = (byte)(outputTables.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (!isTaskMonitorOn) throw throwable;
                    runtime.endTask();
                    throw throwable;
                }
                while (i7222 < input.getMetaData().getFieldCount()) {
                    int n = i7222++;
                    input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                }
            }
            if (inputTables != null) {
                int i22 = 0;
                while (i22 < inputTables.getMetaData().getFieldCount()) {
                    int n = i22++;
                    inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                }
            }
            if (changing != null) {
                int i22 = 0;
                while (i22 < changing.getMetaData().getFieldCount()) {
                    int n = i22++;
                    changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                }
            }
            if (output != null) {
                i2 = 0;
                while (i2 < output.getMetaData().getFieldCount()) {
                    int n = i2++;
                    output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                }
            }
            if (outputTables != null) {
                i2 = 0;
                while (i2 < outputTables.getMetaData().getFieldCount()) {
                    int n = i2++;
                    outputTables.flags[n] = (byte)(outputTables.flags[n] & 0xFFFFFFF7);
                }
            }
            if (!isTaskMonitorOn) return;
            runtime.endTask();
        }

        public JCoResponse execute(JCoRequest request) throws JCoException {
            if (request == null) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "request is null");
            }
            try {
                this.execute(((DefaultRequest)request).function);
                return ((DefaultRequest)request).getResponse();
            }
            catch (ClassCastException e) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unexpected type detected " + request.getClass().getName());
            }
        }

        public JCoFunction getFunction(String functionName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getFunction(functionName);
        }

        public JCoRecordMetaData getStructureDefinition(String structureName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getStructureDefinition(structureName);
        }
    }
}

