/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.util.FastStringBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class FileDestinationsDataProvider
implements DestinationDataProvider,
ServerDataProvider {
    private static String DESTINATION_FILES_SUFFIX = ".jcoDestination";
    private static String SERVER_CFG_FILES_SUFFIX = ".jcoServer";
    private File destinationDirectory;

    FileDestinationsDataProvider(String directory) throws FileNotFoundException {
        File destinationDirFile = null;
        FastStringBuffer error = new FastStringBuffer(128);
        destinationDirFile = new File(directory);
        if (!this.checkFile(destinationDirFile, error)) {
            throw new FileNotFoundException(error.toString());
        }
        this.destinationDirectory = destinationDirFile;
    }

    private boolean checkFile(File file, FastStringBuffer error) {
        if (file.exists()) {
            if (file.canRead()) {
                return true;
            }
            if (error != null) {
                error.append("File ");
                error.append(file.getAbsolutePath());
                error.append(" exists, but cannot be read. ");
            }
        } else if (error != null) {
            error.append("File ");
            error.append(file.getAbsolutePath());
            error.append(" does not exist. ");
        }
        return false;
    }

    public Properties getDestinationProperties(String destinationName) {
        return this.loadProperties(destinationName, DESTINATION_FILES_SUFFIX);
    }

    public Properties getServerProperties(String serverName) {
        return this.loadProperties(serverName, SERVER_CFG_FILES_SUFFIX);
    }

    private Properties loadProperties(String destinationName, String suffix) {
        FastStringBuffer buf;
        File destinationFile = new File(this.destinationDirectory, destinationName + suffix);
        if (!this.checkFile(destinationFile, buf = new FastStringBuffer(256))) {
            throw new RuntimeException(buf.toString());
        }
        FileInputStream fis = null;
        Properties properties = new Properties();
        try {
            fis = new FileInputStream(destinationFile);
            properties.load(fis);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load the destination properties", ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean supportsEvents() {
        return false;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
    }

    public void setServerDataEventListener(ServerDataEventListener eventListener) {
    }
}

