/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.BasXMLWriter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.StructureParameter;
import com.sap.conn.rfc.api.BasXMLAware;
import java.io.IOException;

public class FlatStructure
extends StructureParameter
implements BasXMLAware {
    DefaultStructure structure;
    Converter converter;

    protected FlatStructure(JCoStructure structure, String name) {
        this((DefaultStructure)structure, name, 0, new byte[1]);
    }

    protected FlatStructure(DefaultStructure structure, String name) {
        this(structure, name, 0, new byte[1]);
    }

    protected FlatStructure(DefaultStructure structure, String name, int index, byte[] flags) {
        this(structure, name, null, index, flags);
    }

    protected FlatStructure(DefaultStructure structure, String name, Converter converter, int index, byte[] flags) {
        super(name, index, flags);
        this.structure = structure;
        this.converter = converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public int getType() {
        return 17;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.structure.metaData.tabLength[this.converter.sendI]];
        block6: for (int i = 0; i < this.structure.metaData.numFields; ++i) {
            int offset = ((DefaultRecordMetaData)this.structure.metaData).offset[this.converter.sendI][i];
            switch (this.structure.metaData.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.decodeNumber(this.structure, ret, i, offset, this.structure.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
                case 23: 
                case 24: {
                    this.converter.decodeDecNumber(this.structure, ret, i, offset, this.structure.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
                case 2: 
                case 4: {
                    this.converter.decodeBinary(this.structure, ret, i, offset, this.structure.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.decodeChar(this.structure, ret, i, offset, this.structure.metaData.length[this.converter.sendI][i]);
                    continue block6;
                }
            }
        }
        return ret;
    }

    public void setBytes(byte[] rfcBytes) {
        this.structure.ensureBufferCapacity();
        int numFields = ((DefaultRecordMetaData)this.structure.metaData).computeFieldNumber(rfcBytes.length, this.converter.receiveI);
        int i = 0;
        while (i < numFields) {
            int offset = ((DefaultRecordMetaData)this.structure.metaData).offset[this.converter.receiveI][i];
            switch (this.structure.metaData.type[i]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.encodeNumber(this.structure, rfcBytes, i, offset, this.structure.metaData.length[this.converter.receiveI][i]);
                    break;
                }
                case 23: 
                case 24: {
                    this.converter.encodeDecNumber(this.structure, rfcBytes, i, offset, this.structure.metaData.length[this.converter.receiveI][i]);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.encodeBinary(this.structure, rfcBytes, i, offset, this.structure.metaData.length[this.converter.receiveI][i]);
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.encodeChar(this.structure, rfcBytes, i, offset, this.structure.metaData.length[this.converter.receiveI][i]);
                    break;
                }
            }
            int n = i++;
            this.structure.flags[n] = (byte)(this.structure.flags[n] & 0xFFFFFFFE);
        }
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
    }

    public int getNumBytes() {
        return this.structure.metaData.tabLength[this.converter.sendI];
    }

    public DefaultStructure getStructure() {
        return this.structure;
    }

    void setStructure(DefaultStructure structure) {
        this.structure = structure;
    }

    public AbstractRecord getParameterRecord() {
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        return this.structure;
    }

    public void writebASXML(BasXMLWriter writer) throws IOException {
        writer.encode(this.structure, this.name);
    }
}

