/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.monitor.JCoConnectionData;
import com.sap.conn.jco.util.Codecs;
import java.util.Calendar;

public class MonitoredConnectionData
implements JCoConnectionData {
    static final String SERVER = "SERVER (conn)";
    static final String CLIENT = "CLIENT (conn)";
    static final String ACTIVE = "ACTIVE";
    static final String INACTIVE = "IDLE";
    static final String ACTIVE_STATEFUL = "ACTIVE|STATEFUL";
    static final String INACTIVE_STATEFUL = "IDLE|STATEFUL";
    String abapClient;
    String abapHost;
    String abapUser;
    String abapLanguage;
    String application;
    String connType;
    String convId;
    byte[] dsrPassport;
    String function;
    String group;
    String sessionId;
    int state;
    long lastTimestamp;
    long threadId;
    String threadName;
    long rfcHandle;

    public String getAbapClient() {
        return this.abapClient;
    }

    public String getAbapHost() {
        return this.abapHost;
    }

    public String getAbapUser() {
        return this.abapUser;
    }

    public String getAbapLanguage() {
        return this.abapLanguage;
    }

    public String getApplicationName() {
        return this.application;
    }

    public String getConnectionType() {
        return this.connType;
    }

    public String getConvId() {
        return this.convId;
    }

    public byte[] getDSRPassport() {
        return this.dsrPassport;
    }

    public String getFunctionModuleName() {
        return this.function;
    }

    public String getGroupName() {
        return this.group;
    }

    public String getProtocol() {
        return "RFC";
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getState() {
        return this.state;
    }

    public long getLastActivityTimestamp() {
        return this.lastTimestamp;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getConnectionHandle() {
        return this.rfcHandle;
    }

    void cleanUp() {
        this.abapClient = null;
        this.abapHost = null;
        this.abapUser = null;
        this.application = null;
        this.connType = null;
        this.convId = null;
        this.dsrPassport = null;
        this.function = null;
        this.group = null;
        this.sessionId = null;
        this.state = 0;
        this.lastTimestamp = 0L;
        this.threadId = 0L;
        this.threadName = null;
        this.rfcHandle = 0L;
    }

    public String getStateAsString() {
        if ((this.state & 1) != 0) {
            if ((this.state & 2) != 0) {
                return ACTIVE_STATEFUL;
            }
            return ACTIVE;
        }
        if ((this.state & 2) != 0) {
            return INACTIVE_STATEFUL;
        }
        return INACTIVE;
    }

    public String getDSRPassportAsString() {
        if (this.dsrPassport != null) {
            return Codecs.Hex.encode(this.dsrPassport);
        }
        return "";
    }

    public String getLastActivityTimestampAsString(Calendar calendar) {
        calendar.setTimeInMillis(this.lastTimestamp);
        StringBuilder sb = new StringBuilder();
        sb.append(calendar.get(1)).append('-');
        int i = calendar.get(2) + 1;
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i).append('-');
        i = calendar.get(5);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i).append('|');
        i = calendar.get(11);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i).append(':');
        i = calendar.get(12);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i).append(':');
        i = calendar.get(13);
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i).append('.');
        i = calendar.get(14);
        if (i < 100) {
            sb.append('0');
        }
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        return sb.toString();
    }

    public String getThreadIdAsString() {
        return String.valueOf(this.threadId);
    }

    public String getConnectionHandleAsString() {
        return String.valueOf(this.rfcHandle);
    }
}

