/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.api;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.engine.RfcGetName;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import com.sap.conn.rfc.exceptions.RfcIoException;

public abstract class RfcApi {
    public static final long SERIAL_VERSION_UID = 300012082005L;
    public static final JCoRuntime jcoRuntime = JCoRuntimeFactory.getRuntime();
    public static final RfcRuntime runtime = jcoRuntime.getRfcRuntimeInstance();

    public static void RfcInstallFunction(IRfcFunction function) {
        RfcGetName.installFunction(function);
    }

    public static RfcIoOpenCntl RfcAccept(RfcAcceptInfo acceptInfo, Object connection) throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        acceptInfo.checkParameters();
        if (acceptInfo.isTraceOn() || RfcIoOpenCntl.isGeneralTraceOn()) {
            Trc.TRfcApiStart("RfcAccept\n" + acceptInfo.toString());
        }
        if ((act_cntl = RfcIoControl.ab_rfcaccept(acceptInfo, connection)) != null) {
            act_cntl.ab_rfccount(0);
            act_cntl.own_type = (char)(Environment.inJTS() ? 51 : 82);
            act_cntl.own_rel = "711";
            act_cntl.setAcceptInfo(acceptInfo);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("<* RfcAccept successful\n");
                Trc.ab_rfctrc("    handle = " + act_cntl.hrfc + "*>\n\n");
            }
        } else if (acceptInfo.isTraceOn()) {
            Trc.TRfcApiEnd("RfcAccept", false);
        }
        return act_cntl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RfcIoOpenCntl RfcOpen(RfcOptions options) throws RfcException {
        RfcIoOpenCntl handle = null;
        String name = "<unknown>";
        String key = options.getDestination();
        if (0 != options.isTrace()) {
            Trc.TRfcOpen(options);
        }
        options.checkParameters();
        switch (options.getType()) {
            case 'V': {
                handle = RfcIoControl.ab_rfcopen(name, key, 18, options);
                break;
            }
            case 'A': 
            case 'B': {
                handle = RfcIoControl.ab_rfcopen(name, key, 4, options);
                break;
            }
            default: {
                handle = RfcIoControl.ab_rfcopen(name, key, 0, options);
            }
        }
        if (handle != null) {
            handle.own_rel = "711";
            handle.kernel_rel = "711";
            handle.allocationType = options.getAllocationType();
            try {
                handle.ab_rfccon();
                handle.ab_rfccount(0);
            }
            catch (RfcIoException ioEx) {
                handle.RfcClose();
                RfcIoControl.release(handle);
                handle = null;
                if (0 != options.isTrace()) {
                    Trc.ab_rfctrc("Error> RfcOpen failed. Could not send connect data.\n  ");
                    Trc.ab_rfctrc(ioEx.getMessage());
                    Trc.ab_rfctrc("\n\n");
                }
                throw new RfcException(ioEx);
            }
            try {
                switch (options.getType()) {
                    case 'E': 
                    case 'R': {
                        break;
                    }
                    default: {
                        if (!options.executeLogonCheck()) break;
                        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
                        boolean isTaskMonitorOn = rt.isTaskMonitorOn();
                        if (isTaskMonitorOn) {
                            StringBuilder monitorText = new StringBuilder();
                            String r3name = options.getR3name();
                            monitorText.append("JCo executing logon [").append(r3name == null ? "<empty>" : r3name).append('|').append(handle.target).append('|').append(handle.getCPICConversationID()).append(']');
                            rt.startTask(monitorText.toString());
                        }
                        try {
                            handle.RfcCall("RFCPING", null, null, null, null, false);
                            handle.RfcReceive(null, null, null);
                            break;
                        }
                        finally {
                            if (isTaskMonitorOn) {
                                rt.endTask();
                            }
                        }
                    }
                }
            }
            catch (RfcException ex) {
                handle.RfcClose();
                RfcIoControl.release(handle);
                handle = null;
                if (0 != options.isTrace()) {
                    Trc.ab_rfctrc("Error> RfcOpen failed. Could not ping the partner system.\n  ");
                    Trc.ab_rfctrc(ex.getMessage());
                    Trc.ab_rfctrc("\n\n");
                }
                if (ex.getErrorGroup() == 104) {
                    StringBuilder sb = new StringBuilder(100);
                    sb.append(ex.getMessage());
                    if (options.getType() == 'A') {
                        sb.append(" on ").append(options.getAshost()).append(" sysnr ").append(options.getSysnr());
                    } else if (options.getType() == 'B') {
                        sb.append(" on ").append(options.getR3name()).append(" mshost ").append(options.getMshost());
                    }
                    throw new RfcException(ex.getRc(), sb.toString(), 103, 0L, false, ex);
                }
                throw ex;
            }
            if (0 != options.isTrace()) {
                Trc.ab_rfctrc("<* RfcOpen successful\n");
                Trc.ab_rfctrc("    handle = " + handle.hrfc + "*>\n\n");
            }
        }
        return handle;
    }

    public static int RfcWaitForCpicRequest(int timeout) {
        return runtime.waitForCpicRequest(timeout);
    }

    public static RfcIoOpenCntl RfcGetNextListener() {
        return runtime.getNextListener();
    }

    public static String RfcGetVersion() {
        return runtime.getVersion();
    }
}

