/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.data;

import com.sap.conn.rfc.api.IRfcTable;

public final class LZTable
implements IRfcTable {
    public static final int TABLE_LZ_SIZE = 250;
    private byte[][] contents;
    private int numRows;
    private int capacity;
    String name;

    public LZTable(String name) {
        this.name = name;
        this.capacity = 64;
        this.contents = new byte[this.capacity][];
        this.numRows = 0;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes(int row) {
        if (row >= this.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.numRows - 1) + ']');
        }
        if (this.contents[row] == null) {
            return new byte[0];
        }
        return this.contents[row];
    }

    public void setBytes(int row, byte[] rfcBytes) {
        if (row >= this.numRows || row < 0) {
            throw new ArrayIndexOutOfBoundsException("No such row " + row + "; possible: [0-" + (this.numRows - 1) + ']');
        }
        System.arraycopy(rfcBytes, 0, this.contents[row], 0, Math.min(rfcBytes.length, 250));
    }

    public void appendRow(byte[] rfcBytes) {
        this.ensureBufferCapacity(this.numRows + 1);
        this.contents[this.numRows] = new byte[250];
        System.arraycopy(rfcBytes, 0, this.contents[this.numRows], 0, Math.min(rfcBytes.length, 250));
        ++this.numRows;
    }

    public void appendRows(int numRows) {
        int newNumRows = this.numRows + numRows;
        this.ensureBufferCapacity(newNumRows);
        for (int i = this.numRows; i < newNumRows; ++i) {
            this.contents[i] = new byte[250];
        }
        this.numRows = newNumRows;
    }

    public void clear() {
        this.numRows = 0;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getRowLength() {
        return 250;
    }

    public void ensureBufferCapacity(int numRows) {
        if (this.capacity < numRows) {
            int newCapacity = 2 * this.capacity;
            byte[][] newContents = new byte[newCapacity][];
            System.arraycopy(this.contents, 0, newContents, 0, this.numRows);
            this.contents = newContents;
            this.capacity = newCapacity;
        }
    }

    public boolean isActive() {
        return true;
    }

    public void setActive() {
    }

    public int getIndex() {
        return 0;
    }
}

