/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.driver;

import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcOptions;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.driver.LG;
import com.sap.conn.rfc.engine.GUID;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcException;
import java.io.UnsupportedEncodingException;

public final class RfcTypeDirectCpic
extends CpicDriver {
    private static byte[] traceHead = new byte[]{84};

    public RfcTypeDirectCpic(RfcIoOpenCntl iocntl) {
        super(iocntl);
    }

    public synchronized int listen(byte[] buffer, int bufsize, int[] bytes_read, int timeout) {
        return this.coxread(buffer, bufsize, bytes_read, 1);
    }

    public synchronized int read(byte[] buffer, int bufsize, int[] bytes_read) {
        int rc = this.coxread(buffer, bufsize, bytes_read, 0);
        return rc;
    }

    public synchronized int open(RfcOptions options) throws RfcException {
        int rc = 0;
        this.act_cntl.rfc_uuid = GUID.Factory.createGUID();
        this.act_cntl.rfc_uuid_set = true;
        if (this.act_cntl.trace) {
            Trc.ab_rfctrc("UUID: ab_coxopen create uuid:");
            Trc.ab_rfctrc(GUID.toString(this.act_cntl.rfc_uuid));
            Trc.ab_rfctrc("\n");
        }
        this.deallocated = true;
        this.server_mode = false;
        this.act_cntl.signon = true;
        switch (options.getType()) {
            case 'E': 
            case 'R': {
                if (options.isTrace() <= 0) break;
                rc = this.ab_drvfill(traceHead);
                break;
            }
            default: {
                rc = this.ab_drvfill(this.get_com_head(options.isTrace()));
            }
        }
        if (rc != 0) {
            return 1;
        }
        if (this.cox_cpic_init(options) != 0) {
            return 1;
        }
        rc = this.CMALLC();
        if (rc != 0) {
            this.setMessageTRC(this.getErrorInfo("Connect from SAP gateway to RFC server failed", options));
            return 1;
        }
        this.act_cntl.updateConvID();
        this.deallocated = false;
        return 0;
    }

    public synchronized void abort() {
        if (!this.deallocated) {
            this.CMDEAL();
            this.deallocated = true;
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    public synchronized void close() {
        if (!this.deallocated) {
            this.CMDEAL();
            this.deallocated = true;
        }
        this.tOfLastIO = System.currentTimeMillis();
    }

    public int wflush() {
        if (this.deallocated || this.broken) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("wflush :: Error : (deallocated or broken)");
            }
            return 1;
        }
        return 0;
    }

    public synchronized int accept(RfcAcceptInfo acceptInfo) {
        return 1;
    }

    protected int cox_cpic_init(RfcOptions options) throws RfcException {
        String proto = " ";
        int rc = 0;
        String gwhost_buf = "";
        String gwserv_buf = "";
        String lu_buf = "";
        String tp_buf = "";
        int cpic_trace = options.getCpicTrace();
        String sncPartnerName = options.getSnc_partnername();
        String sapRouter = options.getSaprouter();
        StringBuilder gwhost = new StringBuilder(256);
        switch (options.getType()) {
            case 'A': {
                String gwhost_param;
                proto = "I";
                lu_buf = options.getAshost();
                tp_buf = "sapdp" + options.getSysnr();
                if (sapRouter != null && sapRouter.length() > 0) {
                    gwhost.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost.append("/H/");
                    }
                }
                if ((gwhost_param = options.getGwhost()) == null) {
                    gwhost.append(options.getAshost());
                } else {
                    gwhost.append(gwhost_param);
                }
                gwhost_buf = gwhost.toString();
                gwserv_buf = options.getGwserv();
                if (gwserv_buf == null) {
                    gwserv_buf = "33" + options.getSysnr();
                }
                this.act_cntl.target = new StringBuilder(30).append(options.getAshost()).append('/').append(options.getSysnr()).toString();
                this.act_cntl.sysid = "<empty>";
                break;
            }
            case 'B': {
                proto = "I";
                String msserv = options.getMsserv();
                if (msserv == null) {
                    String r3name = options.getR3name();
                    if (r3name.length() == 4) {
                        char digit;
                        int i;
                        for (i = 0; i < 4 && (digit = r3name.charAt(i)) >= '0' && digit <= '9'; ++i) {
                        }
                        msserv = i == 4 ? r3name : "sapms" + r3name;
                    } else {
                        msserv = "sapms" + r3name;
                    }
                }
                byte[] ipadr = new byte[100];
                int[] port = new int[1];
                if (0 == options.getSnc_mode()) {
                    StringBuilder mshost = new StringBuilder(256);
                    if (sapRouter != null && sapRouter.length() > 0) {
                        mshost.append(sapRouter);
                        if (!sapRouter.endsWith("/H/")) {
                            mshost.append("/H/");
                        }
                    }
                    mshost.append(options.getMshost());
                    rc = LG.get_MS(options.getGroup(), mshost.toString(), msserv, ipadr, port, this.act_cntl);
                    if (rc != 0) {
                        this.setMessageTRC(this.getErrorInfo("Connect to message server host failed", options));
                        return 1;
                    }
                    options.setSysnr(port[0] % 100);
                    gwserv_buf = new StringBuilder(10).append("33").append(options.getSysnr()).toString();
                } else {
                    byte[] sncname_app = new byte[256];
                    StringBuilder mshost = new StringBuilder(256);
                    if (sapRouter != null && sapRouter.length() > 0) {
                        mshost.append(sapRouter);
                        if (!sapRouter.endsWith("/H/")) {
                            mshost.append("/H/");
                        }
                    }
                    mshost.append(options.getMshost());
                    rc = LG.get_MS_SNC(options.getGroup(), mshost.toString(), msserv, sncPartnerName, sncname_app, ipadr, port, this.act_cntl);
                    if (rc != 0) {
                        this.setMessageTRC(this.getErrorInfo("Connect to message server host failed", options));
                        return 1;
                    }
                    options.setSysnr(port[0] % 100);
                    gwserv_buf = new StringBuilder(10).append("sapgw").append(options.getSysnr()).append('s').toString();
                    try {
                        String snc_partnername_t = new String(sncname_app, "UTF8");
                        int end = snc_partnername_t.indexOf(0);
                        sncPartnerName = snc_partnername_t.substring(0, end);
                    }
                    catch (UnsupportedEncodingException uee) {
                        // empty catch block
                    }
                }
                try {
                    gwhost_buf = new String(ipadr, "UTF8");
                    int end = gwhost_buf.indexOf(0);
                    gwhost_buf = gwhost_buf.substring(0, end);
                }
                catch (UnsupportedEncodingException uee) {
                    // empty catch block
                }
                lu_buf = gwhost_buf;
                if (sapRouter != null && sapRouter.length() > 0) {
                    gwhost.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost.append("/H/");
                    }
                }
                gwhost.append(lu_buf);
                gwhost_buf = gwhost.toString();
                tp_buf = options.getSysnr() != null ? new StringBuilder(10).append("sapdp").append(options.getSysnr()).toString() : "";
                this.act_cntl.target = new StringBuilder(30).append(lu_buf).append('/').append(options.getSysnr()).toString();
                this.act_cntl.sysid = options.getR3name();
                break;
            }
            case 'E': {
                proto = "E";
                if (sapRouter != null && sapRouter.length() > 0) {
                    gwhost.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost.append("/H/");
                    }
                }
                gwhost.append(options.getGwhost());
                gwhost_buf = gwhost.toString();
                gwserv_buf = options.getGwserv();
                if (gwserv_buf == null) {
                    gwserv_buf = "33" + options.getSysnr();
                }
                lu_buf = options.getReg_host();
                tp_buf = options.getReg_path();
                this.act_cntl.target = new StringBuilder(30).append((CharSequence)gwhost).append('/').append(gwserv_buf).toString();
                this.act_cntl.sysid = "<extern>";
                break;
            }
            case 'R': {
                proto = "R";
                if (sapRouter != null && sapRouter.length() > 0) {
                    gwhost.append(sapRouter);
                    if (!sapRouter.endsWith("/H/")) {
                        gwhost.append("/H/");
                    }
                }
                gwhost.append(options.getGwhost());
                gwhost_buf = gwhost.toString();
                gwserv_buf = options.getGwserv();
                if (gwserv_buf == null) {
                    gwserv_buf = "33" + options.getSysnr();
                }
                lu_buf = "";
                tp_buf = options.getReg_name();
                this.act_cntl.target = new StringBuilder(30).append((CharSequence)gwhost).append('/').append(gwserv_buf).toString();
                this.act_cntl.sysid = "<extern>";
                break;
            }
            default: {
                assert (false) : "ConnectionType '" + options.getType() + "' invalid";
                break;
            }
        }
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        boolean isTaskMonitorOn = rt.isTaskMonitorOn();
        if (isTaskMonitorOn) {
            StringBuilder msg = new StringBuilder(256).append("JCo executing connect [").append(this.act_cntl.sysid).append('|').append(this.act_cntl.target).append("|<empty>]");
            rt.startTask(msg.toString());
        }
        rc = this.SAP_CMINIT3(options.getDestination(), lu_buf, tp_buf, gwhost_buf, gwserv_buf, proto, cpic_trace, options.getSnc_mode(), options.getSnc_qop(), options.getSnc_myname(), sncPartnerName, options.getSnc_lib(), rc);
        if (isTaskMonitorOn) {
            rt.endTask();
        }
        if (rc != 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("cox_cpic_init :: Error : " + Integer.toString(rc));
            }
            this.setMessage(this.getErrorInfo("Connect to SAP gateway failed", options));
            return 1;
        }
        if (lu_buf.length() > 0 && (rc = this.CMSPLN(lu_buf)) != 0) {
            if (this.act_cntl.trace) {
                Trc.ab_rfctrc("cox_cpic_init :: Error : " + Integer.toString(rc));
            }
            this.setMessage("Cannot set R/3 or Ext. Hostname");
            return 1;
        }
        return 0;
    }

    private String getErrorInfo(String message, RfcOptions options) {
        StringBuilder buffer = new StringBuilder(512);
        String cpicMessage = RfcTypeDirectCpic.SAP_CMPERR();
        buffer.append(message);
        buffer.append("\nConnection parameters: ").append(options.toString(true)).append('\n');
        buffer.append(cpicMessage == null || cpicMessage.length() == 0 ? "No specific info available" : cpicMessage);
        return buffer.toString();
    }
}

