/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcRegisterInfo;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcTypeDirectCpic;
import com.sap.conn.rfc.driver.RfcTypePlayback;
import com.sap.conn.rfc.driver.RfcTypeRegisterCpic;
import com.sap.conn.rfc.engine.DefaultRfcTraceWriter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcTraceWriter;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Properties;

public class DefaultRfcRuntime
implements RfcRuntime {
    public RfcAcceptInfo createAcceptInfo(Properties properties) {
        return new RfcRegisterInfo();
    }

    public String getVersion() {
        return CpicDriver.CpicGetVersion();
    }

    public RfcDriver createChannel(RfcIoOpenCntl currentControl) {
        RfcDriver driver = null;
        switch (currentControl.type) {
            case 0: 
            case 4: {
                driver = new RfcTypeDirectCpic(currentControl);
                break;
            }
            case 12: {
                driver = new RfcTypeRegisterCpic(currentControl);
                break;
            }
            case 10: {
                driver = new RfcTypePlayback(currentControl);
            }
        }
        return driver;
    }

    public RfcTraceWriter getRfcTraceWriter() {
        return new DefaultRfcTraceWriter();
    }

    public void updateClientConnectionProperties(char connectionType, Properties properties) {
    }

    public void initializeHandle(RfcIoOpenCntl currentControl) {
    }

    public void setCpicTrace(int level, String fileName) {
        CpicDriver.setCpicTrace(level, fileName);
    }

    public void setRfcTrace(boolean traceOn) {
        RfcIoOpenCntl.setGeneralTrace(traceOn);
    }

    public RfcIoOpenCntl getNextListener() {
        return RfcTypeRegisterCpic.getNextListener();
    }

    public int waitForCpicRequest(int timeout) {
        return RfcTypeRegisterCpic.waitForRequest(timeout);
    }

    public int getNumServerConnections(RfcAcceptInfo acceptInfo) throws RfcException {
        return RfcTypeRegisterCpic.getNumServerConnections(acceptInfo);
    }

    public void setCpicMaxConv(int no_elem) throws RfcException {
        CpicDriver.setCpicMaxConv(no_elem);
    }

    public String getOwnCodepage() {
        return "4102";
    }

    public boolean isLittleEndian() {
        return false;
    }

    public void setupRegKeepAlive(boolean pingActivate, boolean pingReply, int ping_period_in_sec, int ping_write_timeout_in_ms) throws RfcException {
        CpicDriver.setupRegKeepAlive(pingActivate, pingReply, ping_period_in_sec, ping_write_timeout_in_ms);
    }
}

