/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Random;

public class GUID {
    private static final long serialVersionUID = 1L;
    private static long ltime = System.currentTimeMillis();
    private static short lcount;
    private static long nodeaddress;
    private static Random rand;
    public static final int NUMBYTES = 16;
    public static final int VERSION_NIL = 0;
    public static final int VERSION_TIME = 1;
    public static final int VERSION_NAME = 3;
    public static final int VERSION_RANDOM = 4;
    private static final char[] hexDigits;

    private GUID() {
    }

    static byte[] createGuidByTime() {
        long ts = GUID.gettimestamp();
        long rephigh = 0x1000L | (ts & 0xFFFFFFFFL) << 32 | (ts & 0xFFFF00000000L) >> 16 | (ts & 0xFFF000000000000L) >> 48;
        long replow = Long.MIN_VALUE | (long)rand.nextInt(20479) << 48 | nodeaddress;
        return GUID.toBytes(rephigh, replow);
    }

    private static byte[] toBytes(long rephigh, long replow) {
        byte[] b = new byte[16];
        int n1 = (int)replow;
        b[15] = (byte)n1;
        b[14] = (byte)(n1 >>> 8);
        b[13] = (byte)(n1 >>> 16);
        b[12] = (byte)(n1 >>> 24);
        int n2 = (int)(replow >>> 32);
        b[11] = (byte)n2;
        b[10] = (byte)(n2 >>> 8);
        b[9] = (byte)(n2 >>> 16);
        b[8] = (byte)(n2 >>> 24);
        int n3 = (int)rephigh;
        b[7] = (byte)n3;
        b[6] = (byte)(n3 >>> 8);
        b[5] = (byte)(n3 >>> 16);
        b[4] = (byte)(n3 >>> 24);
        int n4 = (int)(rephigh >>> 32);
        b[3] = (byte)n4;
        b[2] = (byte)(n4 >>> 8);
        b[1] = (byte)(n4 >>> 16);
        b[0] = (byte)(n4 >>> 24);
        return b;
    }

    private static synchronized long gettimestamp() {
        long t;
        block4: {
            while (true) {
                if ((t = System.currentTimeMillis()) != ltime) {
                    ltime = t;
                    lcount = 0;
                    break block4;
                }
                if (lcount < 9999) break;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            lcount = (short)(lcount + 1);
        }
        return (t + 12219292800000L) * 10000L + (long)lcount & 0xFFFFFFFFFFFFFFFL;
    }

    private static long getnodeaddress() {
        try {
            byte[] ipaddr = InetAddress.getLocalHost().getAddress();
            return 0xC00000000000L | (long)rand.nextInt(16383) << 32 | (long)(0xFF & ipaddr[0]) << 24 | (long)(0xFF & ipaddr[1]) << 16 | (long)(0xFF & ipaddr[2]) << 8 | (long)(0xFF & ipaddr[3]);
        }
        catch (Exception exception) {
            return 0x800000000000L | rand.nextLong() & 0x3FFFFFFFFFFFL;
        }
    }

    public static String toString(byte[] guidbytes) {
        if (guidbytes == null || guidbytes.length != 16) {
            throw new IllegalArgumentException("guid " + (guidbytes == null ? "is null" : "has wrong length"));
        }
        char[] buf = new char[36];
        int idx = 0;
        for (int i = 0; i < guidbytes.length; ++i) {
            buf[idx++] = hexDigits[guidbytes[i] >>> 4 & 0xF];
            buf[idx++] = hexDigits[guidbytes[i] & 0xF];
            if (i != 3 && i != 5 && i != 7 && i != 9) continue;
            buf[idx++] = 45;
        }
        return new String(buf);
    }

    public static boolean equals(byte[] first, byte[] second) {
        if (first == null || second == null || first.length != second.length) {
            throw new IllegalArgumentException(" ");
        }
        if (first == second) {
            return true;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    static {
        rand = new SecureRandom();
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        rand.setSeed(System.currentTimeMillis() ^ (long)new Object().hashCode());
        nodeaddress = GUID.getnodeaddress();
    }

    public static class Factory {
        public static byte[] createGUID() {
            return GUID.createGuidByTime();
        }
    }
}

