/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.sysfunc;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.data.RFCSI;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Calendar;
import java.util.Date;

public final class RfcSystemInfo
implements IRfcFunction {
    private static final String[] documentation = new String[]{"Gives some information about the environment.", "", "EXPORTING", "  RFCSI_EXPORT   LIKE RFCSI"};

    public String getName() {
        return "RFC_SYSTEM_INFO";
    }

    public void execute(RfcIoOpenCntl act_cntl) throws RfcException {
        act_cntl.RfcGetData(null, null, null, null);
        IRfcParameter[] exp = new IRfcParameter[1];
        RFCSI rfcsi = new RFCSI(act_cntl, "RFCSI_EXPORT");
        exp[0] = rfcsi;
        DefaultStructure rfcsiStructure = rfcsi.getStructure();
        rfcsiStructure.setValue(0, AbSysInfo.proto);
        rfcsiStructure.setValue(1, AbSysInfo.charset);
        rfcsiStructure.setValue(2, AbSysInfo.rfcinttype);
        rfcsiStructure.setValue(3, AbSysInfo.rfcflotyp);
        rfcsiStructure.setValue(4, AbSysInfo.host);
        rfcsiStructure.setValue(5, AbSysInfo.host);
        rfcsiStructure.setValue(17, AbSysInfo.host);
        rfcsiStructure.setValue(15, AbSysInfo.ipAddress);
        if (AbSysInfo.ipv6Address != null) {
            rfcsiStructure.setValue(19, AbSysInfo.ipv6Address);
        }
        String sys_id = "<extern>";
        if (!Environment.inStandalone()) {
            sys_id = JCoRuntime.getProfileParameter("SAPSYSTEMNAME") + (Environment.inJTS() ? " JTS" : " J2EE");
        }
        rfcsiStructure.setValue(6, sys_id);
        rfcsiStructure.setValue(10, "711");
        rfcsiStructure.setValue(16, "711");
        String operatingSystem = System.getProperty("os.name");
        if (operatingSystem != null && operatingSystem.equals("Windows 2000")) {
            operatingSystem = "Windows 2k";
        }
        rfcsiStructure.setValue(12, operatingSystem);
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        rfcsiStructure.setValue(13, calendar.get(15) / 1000);
        rfcsiStructure.setValue(14, calendar.getTimeZone().inDaylightTime(date) ? (char)'X' : ' ');
        act_cntl.RfcSendData(exp, null, null);
        act_cntl.flushServerConnection();
    }

    public DefaultStructure clientExecute(RfcIoOpenCntl act_cntl) throws RfcException {
        IRfcParameter[] exp = new IRfcParameter[1];
        RFCSI rfcsi = new RFCSI(act_cntl, "RFCSI_EXPORT");
        exp[0] = rfcsi;
        act_cntl.RfcCallReceive("RFC_SYSTEM_INFO", null, exp, null, null);
        DefaultStructure rfcsiStructure = rfcsi.getStructure();
        return rfcsiStructure;
    }

    public String[] getDocumentation() {
        return documentation;
    }
}

