/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertSimpleBase;
import com.sap.i18n.cp.ConverterException;
import com.sap.i18n.cp.ConverterJNI;
import com.sap.tc.logging.Location;

public class ConvertCToX
extends ConvertSimpleBase {
    private static final Location m_oLoc = Location.getLocation("com.sap.i18n.cp.ConvertCToX");

    public ConvertCToX(char[] sOutCp, boolean bIgnoreErr) {
        super(ConvertBase.m_acUcCp, sOutCp, bIgnoreErr, false);
    }

    public ConvertCToX(char[] sOutCp, boolean bIgnoreErr, boolean bFailOnErr) {
        super(ConvertBase.m_acUcCp, sOutCp, bIgnoreErr, bFailOnErr);
    }

    public final byte[] Convert(String sIn) {
        if (this.isShortcut()) {
            byte[] abOut = this.ConvertArr(sIn.toCharArray(), 0, sIn.length());
            if (this.m_oCnvLastErr == null || this.m_bIgnoreErr) {
                return abOut;
            }
            return null;
        }
        return this.ConvertViaJNI(sIn);
    }

    public final int ConvertArr(char[] acIn, int nInBeginIndex, int nInEndIndex, byte[] abOut, int nOutBeginIndex, int nOutEndIndex) {
        try {
            return this.ConvertArrImpl(acIn, nInBeginIndex, nInEndIndex, abOut, nOutBeginIndex, nOutEndIndex);
        }
        catch (ConvertArrException eCnvErr) {
            ConvertCCCDataErrInfo oErrInfo = eCnvErr.getInfo();
            this.m_oCnvLastErr = oErrInfo;
            return oErrInfo.m_abOutDone.length;
        }
    }

    public final int ConvertArrExc(char[] acIn, int nInBeginIndex, int nInEndIndex, byte[] abOut, int nOutBeginIndex, int nOutEndIndex) throws ConverterException {
        try {
            return this.ConvertArrImpl(acIn, nInBeginIndex, nInEndIndex, abOut, nOutBeginIndex, nOutEndIndex);
        }
        catch (ConvertArrException eCnvErr) {
            ConvertCCCDataErrInfo oErrInfo = eCnvErr.getInfo();
            this.m_oCnvLastErr = oErrInfo;
            if (this.m_bIgnoreErr) {
                return oErrInfo.m_abOutDone.length;
            }
            throw new ConverterException(oErrInfo.GetText());
        }
    }

    public final byte[] ConvertArr(char[] acIn, int nInBeginIndex, int nInEndIndex) {
        if (this.isShortcut()) {
            int nOutLength = this.outLength(acIn, nInBeginIndex, nInEndIndex);
            byte[] abOut = new byte[nOutLength];
            this.ConvertArr(acIn, nInBeginIndex, nInEndIndex, abOut, 0, nOutLength);
            return abOut;
        }
        int nInLen = nInEndIndex - nInBeginIndex;
        String sInTmp = new String(acIn, nInBeginIndex, nInLen);
        byte[] abOut = this.ConvertViaJNI(sInTmp);
        return abOut;
    }

    public int outLength(char[] acIn, int nInBeginIndex, int nInEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        String sInTmp = new String(acIn, nInBeginIndex, nInLen);
        byte[] abOut = this.ConvertViaJNI(sInTmp);
        int nOutLen = abOut != null ? abOut.length : 0;
        return nOutLen;
    }

    public final boolean isConvertIgnoreErrThreadSafe() {
        return this.isShortcut();
    }

    protected int ConvertArrImpl(char[] acIn, int nInBeginIndex, int nInEndIndex, byte[] abOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        int[] aRet = new int[]{0, 0};
        if (!this.m_bCnvObjInit) {
            ConvertCToX.throwConverterRuntimeException(m_oLoc, this.m_oCnvLastErr.GetText());
        }
        if (!m_bCnvArrAvailable) {
            return this.ConvertArrFallback(acIn, nInBeginIndex, nInEndIndex, abOut, nOutBeginIndex, nOutEndIndex);
        }
        int nDone = ConverterJNI.ConvertCToXArrR(this.m_aCnvObj, acIn, nInBeginIndex, nInEndIndex, abOut, nOutBeginIndex, nOutEndIndex, aRet);
        if (aRet[0] != 0) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertCToXArr", aRet[0], acIn, nInBeginIndex, nInEndIndex, aRet[1], abOut, nOutBeginIndex, nOutBeginIndex + nDone);
            if (aRet[0] != 32) {
                ConvertCToX.checkFatalReturn(m_oLoc, oCnvErrInfo, this.m_bIgnoreErr);
            }
            throw new ConvertArrException(oCnvErrInfo);
        }
        return nDone;
    }

    protected final ConvertCCCDataErrInfo createCnvErr(String sAction, int nErr, char[] acIn, int nInBeginIndex, int nInEndIndex, int nInPos, byte[] abOut, int nOutBeginIndex, int nOutPos) {
        int nInLen = nInEndIndex - nInBeginIndex;
        String sIn = new String(acIn, nInBeginIndex, nInLen);
        int nOutLenDone = nOutPos - nOutBeginIndex;
        byte[] abOutTmp = new byte[nOutLenDone];
        System.arraycopy(abOut, nOutBeginIndex, abOutTmp, 0, nOutLenDone);
        return new ConvertCCCDataErrInfo(sAction, this.m_sInCp, this.m_sOutCp, nErr, sIn, abOutTmp, nInPos - nInBeginIndex);
    }

    final byte[] GetUc2SbTab(int[] aRet) {
        byte[] m_abUc2SbTab = ConverterJNI.GetUc2SbTab(this.m_aCnvObj, aRet);
        this.checkShortcutLoaded(aRet[0]);
        return m_abUc2SbTab;
    }

    final char[] GetUc2DbTab(char[] m_anUc2ValueTab, int[] aRet) {
        char[] m_anUc2DbTab = ConverterJNI.GetUc2DbTab(this.m_aCnvObj, m_anUc2ValueTab, aRet);
        this.checkShortcutLoaded(aRet[0]);
        return m_anUc2DbTab;
    }

    private byte[] ConvertViaJNI(String sIn) {
        this.m_oCnvLastErr = null;
        int[] aRet = new int[]{0, 0};
        if (!this.m_bCnvObjInit) {
            ConvertCToX.throwConverterRuntimeException(m_oLoc, this.m_oCnvLastErr.GetText());
        }
        byte[] abOut = ConverterJNI.ConvertCToX(this.m_aCnvObj, sIn, aRet);
        if (aRet[0] != 0) {
            this.m_oCnvLastErr = new ConvertCCCDataErrInfo("ConvertCToX", this.m_sInCp, this.m_sOutCp, aRet[0], sIn, abOut, aRet[1]);
            abOut = null;
            ConvertCToX.checkFatalReturn(m_oLoc, this.m_oCnvLastErr, this.m_bIgnoreErr);
        }
        return abOut;
    }

    private final int ConvertArrFallback(char[] acIn, int nInBeginIndex, int nInEndIndex, byte[] abOut, int nOutBeginIndex, int nOutEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        String sIn = new String(acIn, nInBeginIndex, nInLen);
        int[] aRet = new int[]{0, 0};
        byte[] abOutRet = ConverterJNI.ConvertCToX(this.m_aCnvObj, sIn, aRet);
        if (abOutRet == null) {
            return 0;
        }
        int nOutLen = nOutEndIndex - nOutBeginIndex;
        int nDone = nOutLen >= abOutRet.length ? abOutRet.length : nOutLen;
        System.arraycopy(abOutRet, 0, abOut, nOutBeginIndex, nDone);
        return nDone;
    }
}

