/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertXToC;
import com.sap.i18n.cp.StrUtil;

public class ConvertDb2Uc
extends ConvertXToC {
    private byte[] m_abLeadByte2LengthTab;
    private char[] m_acLeadByte2ValueTab;
    private int[] m_anDb2UcTab;
    private char[] m_acBrokenDb2UcTab;

    public ConvertDb2Uc(char[] sInCp, boolean bIgnoreErr, byte[] abLeadByte2LengthTab, char[] acLeadByte2ValueTab, int[] anDb2UcTab, char[] acBrokenDb2UcTab) {
        super(sInCp, bIgnoreErr);
        this.m_abLeadByte2LengthTab = abLeadByte2LengthTab;
        this.m_acLeadByte2ValueTab = acLeadByte2ValueTab;
        this.m_anDb2UcTab = anDb2UcTab;
        this.m_acBrokenDb2UcTab = acBrokenDb2UcTab;
    }

    protected int ConvertArrImpl(byte[] abIn, int nInBeginIndex, int nInEndIndex, char[] acOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        this.m_oCnvLastErr = null;
        int nInLen = nInEndIndex - nInBeginIndex;
        int nOutLen = nOutEndIndex - nOutBeginIndex;
        int i = nInBeginIndex;
        int j = nOutBeginIndex;
        int nCurByte = 0;
        int nNextByte = 0;
        if (i + 1 < nInEndIndex) {
            nCurByte = abIn[i] & 0xFF;
            nNextByte = abIn[i + 1] & 0xFF;
        } else if (i < nInEndIndex) {
            nCurByte = abIn[i] & 0xFF;
            nNextByte = 0;
        } else {
            return 0;
        }
        while (i < nInEndIndex) {
            byte nCurLen = this.m_abLeadByte2LengthTab[nCurByte];
            if (nCurLen == 1) {
                char cOut = this.m_acLeadByte2ValueTab[nCurByte];
                if (j < nOutEndIndex) {
                    acOut[j] = cOut;
                    ++j;
                } else {
                    j = nOutEndIndex;
                    break;
                }
                nCurByte = nNextByte;
                nNextByte = ++i + 1 < nInEndIndex ? abIn[i + 1] & 0xFF : 0;
                continue;
            }
            int nOffset = this.m_acLeadByte2ValueTab[nCurByte] & 0xFFFF;
            int nOutInt = this.m_anDb2UcTab[nOffset + nNextByte];
            if (nOutInt == 65535) {
                char cOut = this.m_acBrokenDb2UcTab[nCurByte];
                if (j >= nOutEndIndex) break;
                acOut[j] = cOut;
                ++j;
                nCurByte = nNextByte;
                nNextByte = ++i + 1 < nInEndIndex ? abIn[i + 1] & 0xFF : 0;
                continue;
            }
            if ((nOutInt & 0xFFFF0000) == 0) {
                char cOut = (char)nOutInt;
                if (j >= nOutEndIndex) break;
                acOut[j] = cOut;
                ++j;
                if ((i += 2) + 1 < nInEndIndex) {
                    nCurByte = abIn[i] & 0xFF;
                    nNextByte = abIn[i + 1] & 0xFF;
                    continue;
                }
                if (i >= nInEndIndex) break;
                nCurByte = abIn[i] & 0xFF;
                nNextByte = 0;
                continue;
            }
            String s = StrUtil.buildByteString(abIn);
            char cOutLead = (char)((nOutInt & 0xFFFF0000) >> 16);
            char cOutTrail = (char)nOutInt;
            if (j + 1 >= nOutEndIndex) break;
            acOut[j] = cOutLead;
            acOut[j + 1] = cOutTrail;
            j += 2;
            if ((i += 2) + 1 < nInEndIndex) {
                nCurByte = abIn[i] & 0xFF;
                nNextByte = abIn[i + 1] & 0xFF;
                continue;
            }
            if (i >= nInEndIndex) break;
            nCurByte = abIn[i] & 0xFF;
            nNextByte = 0;
        }
        if (i < nInEndIndex) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2DbArr", 32, abIn, nInBeginIndex, nInEndIndex, i, acOut, nOutBeginIndex, j);
            throw new ConvertArrException(oCnvErrInfo);
        }
        return j - nOutBeginIndex;
    }

    public int outLength(byte[] abIn, int nInBeginIndex, int nInEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        int j = 0;
        int i = nInBeginIndex;
        int nCurByte = 0;
        int nNextByte = 0;
        if (i + 1 < nInEndIndex) {
            nCurByte = abIn[i] & 0xFF;
            nNextByte = abIn[i + 1] & 0xFF;
        } else if (i < nInEndIndex) {
            nCurByte = abIn[i] & 0xFF;
            nNextByte = 0;
        } else {
            return 0;
        }
        while (i < nInEndIndex) {
            byte nCurLen = this.m_abLeadByte2LengthTab[nCurByte];
            if (nCurLen == 1) {
                ++j;
                nCurByte = nNextByte;
                nNextByte = ++i + 1 < nInEndIndex ? abIn[i + 1] & 0xFF : 0;
                continue;
            }
            int nOffset = this.m_acLeadByte2ValueTab[nCurByte] & 0xFFFF;
            int nOutInt = this.m_anDb2UcTab[nOffset + nNextByte];
            if (nOutInt == 65535) {
                ++j;
                nCurByte = nNextByte;
                nNextByte = ++i + 1 < nInEndIndex ? abIn[i + 1] & 0xFF : 0;
                continue;
            }
            if ((nOutInt & 0xFFFF0000) == 0) {
                ++j;
                if ((i += 2) + 1 < nInEndIndex) {
                    nCurByte = abIn[i] & 0xFF;
                    nNextByte = abIn[i + 1] & 0xFF;
                    continue;
                }
                if (i >= nInEndIndex) break;
                nCurByte = abIn[i] & 0xFF;
                nNextByte = 0;
                continue;
            }
            j += 2;
            if ((i += 2) + 1 < nInEndIndex) {
                nCurByte = abIn[i] & 0xFF;
                nNextByte = abIn[i + 1] & 0xFF;
                continue;
            }
            if (i >= nInEndIndex) break;
            nCurByte = abIn[i] & 0xFF;
            nNextByte = 0;
        }
        return j;
    }

    protected boolean isShortcut() {
        return true;
    }
}

