/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertSystemCpToC7bOnly;
import com.sap.i18n.cp.ConvertTImplBase;
import com.sap.i18n.cp.ConverterJNI;
import com.sap.i18n.cp.ConverterJNITestDataCpSystemCpToC7bOnly;
import com.sap.i18n.cp.ConverterJNITestDataSingleSystemCpToC7bOnly;
import com.sap.i18n.cp.ConverterRuntimeException;
import com.sap.i18n.cp.StrUtil;
import com.sap.i18n.verify.intf.VerifyIntf;

public class ConvertSystemCpToC7bOnlyTImpl
extends ConvertTImplBase {
    public static ConverterJNITestDataCpSystemCpToC7bOnly[] m_aTestData4103ToC7bOnlyFalse = new ConverterJNITestDataCpSystemCpToC7bOnly[]{new ConverterJNITestDataCpSystemCpToC7bOnly(0, new ConverterJNITestDataSingleSystemCpToC7bOnly[]{new ConverterJNITestDataSingleSystemCpToC7bOnly(new byte[]{65, 0, 66, 0, 67, 0}, new char[]{'A', 'B', 'C'}, 0)})};
    public static ConverterJNITestDataCpSystemCpToC7bOnly[] m_aTestData1100ToC7bOnlyFalse = new ConverterJNITestDataCpSystemCpToC7bOnly[]{new ConverterJNITestDataCpSystemCpToC7bOnly(0, new ConverterJNITestDataSingleSystemCpToC7bOnly[]{new ConverterJNITestDataSingleSystemCpToC7bOnly(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}, 0), new ConverterJNITestDataSingleSystemCpToC7bOnly(new byte[]{65, 66, -60}, null, 2048)})};

    public ConvertSystemCpToC7bOnlyTImpl(VerifyIntf oVerify) {
        super(oVerify);
    }

    public void testMain() {
        this.printLogln("TEST ConvertSystemCpToC7bOnlyTImpl BEGIN");
        this.testConvertSystemCpToC7Only();
        try {
            this.testJNI();
        }
        catch (ConverterRuntimeException r) {
            this.printLogln("provoked exception ");
        }
        this.printLogln("ConvertSystemCpToC7bOnly done");
        this.printLogln("TEST ConvertSystemCpToC7bOnlyTImpl END");
    }

    public void testFast() {
        this.printLogln("TEST FAST ConvertSystemCpToC7bOnlyTImpl BEGIN");
        this.testConvertSystemCpToC7Only();
        this.printLogln("TEST FAST ConvertSystemCpToC7bOnlyTImpl END");
    }

    private void testJNI() throws ConverterRuntimeException {
        ConverterJNI.checkVersion(6, 0);
    }

    public void testConvertSystemCpToC7Only() {
        block7: {
            String sSystemCp;
            block6: {
                char[] acSystemCp = null;
                sSystemCp = null;
                String version = ConverterJNI.GetVersion();
                this.printLogln("version: " + version);
                try {
                    acSystemCp = ConvertBase.getSystemCP();
                    sSystemCp = new String(acSystemCp);
                }
                catch (Exception ex) {
                    this.printLogln("actual SystemCp could not be determined");
                    return;
                }
                if (!sSystemCp.equals("4103")) break block6;
                this.printLogln("using SystemCp: 4103");
                for (int i = 0; i < m_aTestData4103ToC7bOnlyFalse.length; ++i) {
                    ConverterJNITestDataCpSystemCpToC7bOnly oDataCp = m_aTestData4103ToC7bOnlyFalse[i];
                    boolean bCnvInitOk = true;
                    ConvertSystemCpToC7bOnly oCnvObj = new ConvertSystemCpToC7bOnly(false);
                    for (int j = 0; j < oDataCp.m_aData.length; ++j) {
                        ConverterJNITestDataSingleSystemCpToC7bOnly oData = oDataCp.m_aData[j];
                        if (!bCnvInitOk) continue;
                        String abOut = oCnvObj.Convert(oData.m_abDataIn);
                        this.verifyConvertSystemCpToC7bOnly(oData.m_abDataIn, abOut, oData.m_acDataOut, oCnvObj.GetLastRet(), oData.m_nReturn, "ConverterJNI.ConvertSystemCpToC");
                    }
                }
                break block7;
            }
            if (!sSystemCp.equals("1100")) break block7;
            this.printLogln("using SystemCp: 1100");
            for (int i = 0; i < m_aTestData1100ToC7bOnlyFalse.length; ++i) {
                ConverterJNITestDataCpSystemCpToC7bOnly oDataCp = m_aTestData1100ToC7bOnlyFalse[i];
                int[] aRet = new int[]{0, 0};
                boolean bCnvInitOk = true;
                ConvertSystemCpToC7bOnly oCnvObj = new ConvertSystemCpToC7bOnly(false);
                for (int j = 0; j < oDataCp.m_aData.length; ++j) {
                    ConverterJNITestDataSingleSystemCpToC7bOnly oData = oDataCp.m_aData[j];
                    if (!bCnvInitOk) continue;
                    String abOut = oCnvObj.Convert(oData.m_abDataIn);
                    this.verifyConvertSystemCpToC7bOnly(oData.m_abDataIn, abOut, oData.m_acDataOut, oCnvObj.GetLastRet(), oData.m_nReturn, "ConverterJNI.ConvertSystemCpToC");
                }
            }
        }
    }

    void verifyConvertSystemCpToC7bOnly(byte[] abIn, String sOut, char[] acOutExpected, int nReturn, int nReturnExpected, String sName) {
        String sOutExpected = null;
        if (nReturn != nReturnExpected) {
            this.verify(false, "SystemCp->UC7bOnly returned: " + nReturn + " (" + nReturnExpected + ")", sName);
        }
        if (acOutExpected != null) {
            sOutExpected = new String(acOutExpected);
        }
        String sInBytes = StrUtil.buildByteString(abIn);
        if (sOut == null && sOutExpected == null) {
            this.verify(true, "SystemCp -> UC7bOnly: " + sInBytes + "-> null ( null )", sName);
        } else {
            this.verify(sOut.equals(sOutExpected), "SystemCp->UC7bOnly: " + sInBytes + "->" + sOut + " (" + sOutExpected + ")", sName);
        }
    }
}

