/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertCToX;

public class ConvertUc2Db
extends ConvertCToX {
    private char[] m_anUc2ValueTab;
    private char[] m_anUc2DbTab;

    public ConvertUc2Db(char[] sInCp, boolean bIgnoreErr, char[] anUc2ValueTab, char[] anUc2DbTab) {
        super(sInCp, bIgnoreErr);
        this.m_anUc2ValueTab = anUc2ValueTab;
        this.m_anUc2DbTab = anUc2DbTab;
    }

    public int ConvertArrImpl(char[] acIn, int nInBeginIndex, int nInEndIndex, byte[] abOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        this.m_oCnvLastErr = null;
        int nInLen = nInEndIndex - nInBeginIndex;
        int nOutLen = nOutEndIndex - nOutBeginIndex;
        int i = nInBeginIndex;
        int j = nOutBeginIndex;
        int nCurChar = 0;
        int nNextChar = 0;
        if (i + 1 < nInEndIndex) {
            nCurChar = acIn[i] & 0xFFFF;
            nNextChar = acIn[i + 1] & 0xFFFF;
        } else if (i < nInEndIndex) {
            nCurChar = acIn[i] & 0xFFFF;
            nNextChar = 0;
        } else {
            return 0;
        }
        int nCurCharSave = 0;
        int nCurPosSave = 0;
        int nXORReplChar = 0;
        while (i < nInEndIndex) {
            nCurCharSave = nCurChar;
            nCurPosSave = i;
            if ((nCurChar & 0xF800) != 55296) {
                int nOutShort = this.m_anUc2ValueTab[nCurChar] & 0xFFFF;
                if (nOutShort < 256) {
                    byte bOut;
                    if (j >= nOutEndIndex) break;
                    abOut[j] = bOut = (byte)nOutShort;
                    ++j;
                    nXORReplChar = bOut ^ 0x23;
                } else {
                    byte nOutByteLead = (byte)((nOutShort & 0xFF00) >> 8);
                    byte nOutByteTrail = (byte)nOutShort;
                    if (j + 1 >= nOutEndIndex) break;
                    abOut[j] = nOutByteLead;
                    abOut[j + 1] = nOutByteTrail;
                    j += 2;
                    nXORReplChar = 1;
                }
                nCurChar = nNextChar;
                nNextChar = ++i + 1 < nInEndIndex ? acIn[i + 1] : 0;
            } else if ((nCurChar & 0xDC00) == 55296 && (nNextChar & 0xDC00) == 56320) {
                int nOffsetLead = (this.m_anUc2ValueTab[nCurChar] & 0xFFFF) * 1024;
                int nOffsetTrail = nNextChar % 1024;
                char nOutShort = this.m_anUc2DbTab[nOffsetLead + nOffsetTrail];
                if (nOutShort < '\u0100') {
                    byte bOut;
                    if (j >= nOutEndIndex) break;
                    abOut[j] = bOut = (byte)nOutShort;
                    ++j;
                    nXORReplChar = bOut ^ 0x23;
                } else {
                    byte nOutByteLead = (byte)((nOutShort & 0xFF00) >> 8);
                    byte nOutByteTrail = (byte)nOutShort;
                    if (j + 1 >= nOutEndIndex) break;
                    abOut[j] = nOutByteLead;
                    abOut[j + 1] = nOutByteTrail;
                    j += 2;
                    nXORReplChar = 1;
                }
                if ((i += 2) + 1 < nInEndIndex) {
                    nCurChar = acIn[i] & 0xFFFF;
                    nNextChar = acIn[i + 1] & 0xFFFF;
                } else if (i < nInEndIndex) {
                    nCurChar = acIn[i] & 0xFFFF;
                    nNextChar = 0;
                } else {
                    nCurChar = 0;
                    nNextChar = 0;
                }
            } else {
                if (j >= nOutEndIndex) break;
                abOut[j] = 35;
                ++j;
                nXORReplChar = 0;
                nCurChar = nNextChar;
                int n = nNextChar = ++i + 1 < nInEndIndex ? acIn[i + 1] : 0;
            }
            if (this.m_bIgnoreErr || nXORReplChar != 0 || nCurCharSave == 35) continue;
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2DbArr", 2048, acIn, nInBeginIndex, nInEndIndex, nCurPosSave, abOut, nOutBeginIndex, j);
            throw new ConvertArrException(oCnvErrInfo);
        }
        if (i < nInEndIndex) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertUc2DbArr", 32, acIn, nInBeginIndex, nInEndIndex, i, abOut, nOutBeginIndex, j);
            throw new ConvertArrException(oCnvErrInfo);
        }
        return j - nOutBeginIndex;
    }

    public int outLength(char[] acIn, int nInBeginIndex, int nInEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        int i = nInBeginIndex;
        int j = 0;
        int nCurChar = 0;
        int nNextChar = 0;
        if (i + 1 < nInEndIndex) {
            nCurChar = acIn[i] & 0xFFFF;
            nNextChar = acIn[i + 1] & 0xFFFF;
        } else if (i < nInEndIndex) {
            nCurChar = acIn[i] & 0xFFFF;
            nNextChar = 0;
        } else {
            return 0;
        }
        while (i < nInEndIndex) {
            if ((nCurChar & 0xF800) != 55296) {
                int nOutShort = this.m_anUc2ValueTab[nCurChar] & 0xFFFF;
                j = nOutShort < 256 ? ++j : (j += 2);
                nCurChar = nNextChar;
                nNextChar = ++i + 1 < nInEndIndex ? acIn[i + 1] : 0;
                continue;
            }
            if ((nCurChar & 0xDC00) == 55296 && (nNextChar & 0xDC00) == 56320) {
                int nOffsetLead = (this.m_anUc2ValueTab[nCurChar] & 0xFFFF) * 1024;
                int nOffsetTrail = nNextChar % 1024;
                char nOutShort = this.m_anUc2DbTab[nOffsetLead + nOffsetTrail];
                j = nOutShort < '\u0100' ? ++j : (j += 2);
                if ((i += 2) + 1 < nInEndIndex) {
                    nCurChar = acIn[i] & 0xFFFF;
                    nNextChar = acIn[i + 1] & 0xFFFF;
                    continue;
                }
                if (i < nInEndIndex) {
                    nCurChar = acIn[i] & 0xFFFF;
                    nNextChar = 0;
                    continue;
                }
                return j;
            }
            ++j;
            nCurChar = nNextChar;
            nNextChar = ++i + 1 < nInEndIndex ? acIn[i + 1] : 0;
        }
        return j;
    }

    protected boolean isShortcut() {
        return true;
    }
}

