/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

class StrUtil {
    private static final Location m_oLoc = Location.getLocation("com.sap.i18n.cp.StrUtil");
    private static final Category m_oLog = Category.SYS_SERVER;

    StrUtil() {
    }

    public static String toLength(String str, int nLen) {
        if (str == null) {
            str = "UNDEFINED";
        }
        int nLenOrg = str.length();
        StringBuffer strBuf = new StringBuffer(str);
        for (int i = nLenOrg; i < nLen; ++i) {
            strBuf.append(' ');
        }
        strBuf.setLength(nLen);
        return strBuf.toString();
    }

    public static String buildHexString(int nVal, int nDigits) {
        String strVal = Integer.toHexString(nVal);
        int nValDigits = strVal.length();
        StringBuffer strBuf = new StringBuffer(strVal);
        for (int i = nValDigits; i < nDigits; ++i) {
            strBuf.insert(0, '0');
        }
        return strBuf.toString();
    }

    public static String buildHexString(byte nVal) {
        int nValUnsigned = nVal >= 0 ? nVal : nVal + 256;
        return StrUtil.buildHexString(nValUnsigned, 2);
    }

    public static String buildHexString(char nVal) {
        int nValUnsigned = nVal >= 0 ? nVal : nVal + 65536;
        return StrUtil.buildHexString(nValUnsigned, 4);
    }

    public static String buildByteString(byte[] abData) {
        if (abData == null) {
            return "<null>";
        }
        StringBuffer sBuf = new StringBuffer();
        for (int i = 0; i < abData.length; ++i) {
            sBuf.append(StrUtil.buildHexString(abData[i]));
            if (i == abData.length - 1) continue;
            sBuf.append(' ');
        }
        return new String(sBuf);
    }

    public static String buildByteString(String sText) {
        if (sText == null) {
            return "<null>";
        }
        StringBuffer sBuf = new StringBuffer();
        for (int i = 0; i < sText.length(); ++i) {
            sBuf.append(StrUtil.buildHexString(sText.charAt(i)));
            if (i == sText.length() - 1) continue;
            sBuf.append(' ');
        }
        return new String(sBuf);
    }

    public static String getExceptionStackTrace(Throwable ex) {
        ByteArrayOutputStream bops = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bops);
        ex.printStackTrace(ps);
        String protocol = null;
        try {
            protocol = new String(bops.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            m_oLog.error(m_oLoc, e.getMessage());
        }
        ps.close();
        return protocol;
    }
}

