/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.MsgObject;
import java.util.HashMap;

public class Category
extends LogController {
    private static Location classLoc = Location.getLocation(Category.class);
    public static final String ROOT_NAME = "/";
    public static final char SEPARATOR = '/';
    public static final Category SYSTEM = Category.getCategoryInt("/System");
    public static Category APPLICATION = Category.getCategoryInt("/Applications");
    public static Category APPLICATIONS = Category.getCategoryInt("/Applications");
    public static Category APPS_COMMON = Category.getCategory(APPLICATIONS, "Common");
    public static Category APPS_COMMON_SECURITY = Category.getCategory(APPS_COMMON, "Security");
    public static Category APPS_COMMON_BACKUP = Category.getCategory(APPS_COMMON, "Backup");
    public static Category APPS_COMMON_ARCHIVING = Category.getCategory(APPS_COMMON, "Archiving");
    public static Category APPS_COMMON_RESOURCES = Category.getCategory(APPS_COMMON, "Resources");
    public static Category APPS_COMMON_CONFIGURATION = Category.getCategory(APPS_COMMON, "Configuration");
    public static Category APPS_COMMON_FAILOVER = Category.getCategory(APPS_COMMON, "Failover");
    public static Category APPS_COMMON_INFRASTRUCTURE = Category.getCategory(APPS_COMMON, "Infrastructure");
    public static Category PERFORMANCE = Category.getCategoryInt("/Performance");
    public static Category SYS_DATABASE = Category.getCategory(SYSTEM, "Database");
    public static Category SYS_NETWORK = Category.getCategory(SYSTEM, "Network");
    public static Category SYS_SERVER = Category.getCategory(SYSTEM, "Server");
    public static Category SYS_SECURITY = Category.getCategory(SYSTEM, "Security");
    public static Category SYS_USER_INTERFACE = Category.getCategory(SYSTEM, "UserInterface");
    public static Category SYS_CONFIGURATION = Category.getCategory(SYSTEM, "Configuration");
    public static Category SYS_LOGGING = Category.getCategory(SYSTEM, "Logging");
    public static Category SYS_ENTERPRISE_SERVICES = Category.getCategory(SYSTEM, "EnterpriseServices");
    protected static Category SYS_CONFIGURATION_LOGGING = Category.getCategory(SYS_CONFIGURATION, "Logging");
    public static HashMap PREDEF_CATEGORIES = new HashMap();
    static final String NO_LOCATION_EMSG = "no location";

    Category(String name) {
        super(name);
    }

    Category(String name, Category parent) {
        super(name, parent);
    }

    public static Category getRoot() {
        return Category.getCategoryInt(ROOT_NAME);
    }

    public Category getParent() {
        return (Category)this.getParentInt();
    }

    public static Category getCategory(Category category, String name) {
        if (category != Category.getRoot()) {
            return Category.getCategoryInt(category.getName() + '/' + name);
        }
        return Category.getCategoryInt(category.getName() + name);
    }

    public LogRecord logT(int severity, Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, subloc, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityTInt(severity, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, loc)) {
            writtenRec = this.logSeverityInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beLogged(severity, this)) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, subloc, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, subloc, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityTInt(300, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logTInt(300, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(loc)) {
            writtenRec = this.logSeverityInt(300, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beInfo(this)) {
            loc.logInt(300, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, subloc, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, subloc, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityTInt(400, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logTInt(400, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(loc)) {
            writtenRec = this.logSeverityInt(400, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beWarning(this)) {
            loc.logInt(400, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, subloc, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, subloc, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityTInt(500, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logTInt(500, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(loc)) {
            writtenRec = this.logSeverityInt(500, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beError(this)) {
            loc.logInt(500, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityTInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logTInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityTInt(600, loc, new LogController[]{loc}, subloc, msg, 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logTInt(600, loc, new LogController[]{this}, subloc, msg, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityTInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msg, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logTInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Location loc, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityTInt(600, loc, new LogController[]{loc}, subloc, msg, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logTInt(600, loc, new LogController[]{this}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subLoc, MsgObject msgObject) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subLoc, MsgObject msgObject, Object[] args) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgObject.getMsgText(), 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, null, 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, null, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, null, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, null, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, MSG_ARGS);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Location loc, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(loc)) {
            writtenRec = this.logSeverityInt(600, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args);
        } else if (loc != null && loc.beFatal(this)) {
            loc.logInt(600, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 0, MSG_ARGS, exc);
        }
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, MSG_ARGS, exc);
        } else {
            this.handleLCNull("logThrowableT()", msg, MSG_ARGS, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String subloc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 0, MSG_ARGS, exc);
        }
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, MSG_ARGS, exc);
        } else {
            this.handleLCNull("logThrowableT()", msg, MSG_ARGS, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, args, exc);
        }
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msg, 1, args, exc);
        } else {
            this.handleLCNull("logThrowableT()", msg, args, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowableT(int severity, Location loc, String subloc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, args, exc);
        }
        if (loc != null) {
            loc.logTInt(severity, loc, new LogController[]{this}, subloc, msg, 1, args, exc);
        } else {
            this.handleLCNull("logThrowableT()", msg, args, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, MsgObject msgObject, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        String msgClear = msgObject.getMsgText();
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgClear, 0, MSG_ARGS, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgClear, 1, MSG_ARGS, exc);
        } else {
            this.handleLCNull("logThrowable(...)", msgClear, MSG_ARGS, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, MsgObject msgObject, Object[] args, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        String msgClear = msgObject.getMsgText();
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgClear, 1, args, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgObject.getMsgKeyAndID(), msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable(...)", msgClear, args, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, String subLoc, MsgObject msgObject, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        String msgClear = msgObject.getMsgText();
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgClear, 0, MSG_ARGS, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgClear, 1, MSG_ARGS, exc);
        } else {
            this.handleLCNull("logThrowable(...)", msgClear, MSG_ARGS, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, String subLoc, MsgObject msgObject, Object[] args, Throwable exc) {
        if (msgObject == null) {
            return null;
        }
        LogRecord writtenRec = null;
        String msgClear = msgObject.getMsgText();
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, subLoc, msgObject.getMsgKeyAndID(), msgClear, 1, args, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, subLoc, msgObject.getMsgKeyAndID(), msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable(...)", msgClear, args, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, Object msgCode, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 0, MSG_ARGS, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 1, MSG_ARGS, exc);
        } else {
            this.handleLCNull("logThrowable()", msgClear, MSG_ARGS, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, String subloc, Object msgCode, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 0, MSG_ARGS, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, MSG_ARGS, exc);
        } else {
            this.handleLCNull("logThrowable()", msgClear, MSG_ARGS, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, Object msgCode, Object[] args, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, MSG_SUB_LOC, msgCode, msgClear, 1, args, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, MSG_SUB_LOC, msgCode, msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable()", msgClear, args, exc);
        }
        return writtenRec;
    }

    public LogRecord logThrowable(int severity, Location loc, String subloc, Object msgCode, Object[] args, String msgClear, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logInt(severity, loc, new LogController[]{loc}, subloc, msgCode, msgClear, 1, args, exc);
        }
        if (loc != null) {
            loc.logInt(severity, loc, new LogController[]{this}, subloc, msgCode, msgClear, 1, args, exc);
        } else {
            this.handleLCNull("logThrowable()", msgClear, args, exc);
        }
        return writtenRec;
    }

    public void openGroup(int severity, Location loc) {
        this.openGroupInt(MSG_GRP_NAME, MSG_GRP_DESC, severity, MSG_SUB_LOC, loc);
    }

    public void openGroup(int severity, Location loc, String subloc) {
        this.openGroupInt(MSG_GRP_NAME, MSG_GRP_DESC, severity, subloc, loc);
    }

    public void setMinimumSeverity(Location relative, int severity) {
        super.setMinimumSeverity(relative, severity);
    }

    public void setMinimumSeverity(Location relative) {
        super.setMinimumSeverity(relative);
    }

    public void setEffectiveSeverity(Location relative, int severity) {
        super.setEffectiveSeverity(relative, severity);
    }

    public void setEffectiveSeverity(Location relative) {
        super.setEffectiveSeverity(relative);
    }

    public void setMaximumSeverity(Location relative, int severity) {
        super.setMaximumSeverity(relative, severity);
    }

    public void setMaximumSeverity(Location relative) {
        super.setMaximumSeverity(relative);
    }

    static Category getCategoryInt(String name) {
        return LoggingManager.getLoggingManager().getCategory(name);
    }

    private void handleLCNull(String methodName, String msgClear, Object[] args, Throwable exc) {
        SYS_LOGGING.logIntByAPI(400, classLoc, methodName, MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL, new String[]{"Location", "Category", this.getName()});
        SYS_LOGGING.logIntByAPI(400, classLoc, methodName, MSGCollection.LOGGING_MSG_ID_UNHANDLED, MSGCollection.LOGGING_MSG_STR_UNHANDLED + msgClear, args, exc);
        this.handleException(new NullPointerException("No filter"), 4);
    }

    public static Category getCategory(String name) {
        return Category.getCategoryInt(name);
    }

    static {
        PREDEF_CATEGORIES.put(ROOT_NAME, Category.getRoot());
        PREDEF_CATEGORIES.put("/Performance", PERFORMANCE);
        PREDEF_CATEGORIES.put("/Applications", APPLICATIONS);
        PREDEF_CATEGORIES.put("/Applications/Common", APPS_COMMON);
        PREDEF_CATEGORIES.put("/Applications/Common/Security", APPS_COMMON_SECURITY);
        PREDEF_CATEGORIES.put("/Applications/Common/Backup", APPS_COMMON_BACKUP);
        PREDEF_CATEGORIES.put("/Applications/Common/Archiving", APPS_COMMON_ARCHIVING);
        PREDEF_CATEGORIES.put("/Applications/Common/Resources", APPS_COMMON_RESOURCES);
        PREDEF_CATEGORIES.put("/Applications/Common/Configuration", APPS_COMMON_CONFIGURATION);
        PREDEF_CATEGORIES.put("/Applications/Common/Failover", APPS_COMMON_FAILOVER);
        PREDEF_CATEGORIES.put("/Applications/Common/Infrastructure", APPS_COMMON_INFRASTRUCTURE);
        PREDEF_CATEGORIES.put("/System", SYSTEM);
        PREDEF_CATEGORIES.put("/System/Database", SYS_DATABASE);
        PREDEF_CATEGORIES.put("/System/Network", SYS_NETWORK);
        PREDEF_CATEGORIES.put("/System/Server", SYS_SERVER);
        PREDEF_CATEGORIES.put("/System/Security", SYS_SECURITY);
        PREDEF_CATEGORIES.put("/System/UserInterface", SYS_USER_INTERFACE);
        PREDEF_CATEGORIES.put("/System/Configuration", SYS_CONFIGURATION);
        PREDEF_CATEGORIES.put("/System/Configuration/Logging", SYS_CONFIGURATION_LOGGING);
        PREDEF_CATEGORIES.put("/System/Logging", SYS_LOGGING);
        PREDEF_CATEGORIES.put("/System/EnterpriseServices", SYS_ENTERPRISE_SERVICES);
    }
}

