/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;

class GroupFactory {
    private static String strLoc = "GroupFactory";

    GroupFactory() {
    }

    public static Group openGroup(int size, LogController src, LogController[] relatives, String name, String description, int severity, String subLoc) {
        Group newGroup = null;
        Group lmParentGroup = LoggingManager.getThreadLocalInfo().getGroup();
        int parentGroupLevel = 0;
        if (lmParentGroup != null) {
            parentGroupLevel = lmParentGroup.getLevel();
        }
        if (parentGroupLevel <= size) {
            newGroup = new Group(src, subLoc, relatives, name, description, lmParentGroup, ++parentGroupLevel, severity);
            LoggingManager.getThreadLocalInfo().setGroup(newGroup);
            newGroup.open(src);
        } else {
            APILogger.logIntByAPI(400, APILogger.APILocation, strLoc + "[openGroup(...)]", MSGCollection.LOGGING_MSG_ID_GROUP_OPEN_LIMIT, MSGCollection.LOGGING_MSG_STR_GROUP_OPEN_LIMIT, new String[]{"LogController", src.getName(), Integer.toString(size)});
        }
        return newGroup;
    }

    public static boolean closeGroup(LogController src) {
        return GroupFactory.closeGroup(src, LoggingManager.getThreadLocalInfo().getGroup());
    }

    public static boolean closeGroup(LogController src, Group group) {
        try {
            group.close(src);
            LoggingManager.getThreadLocalInfo().setGroup(group.getParent());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

