/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Configurator;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.CreateLogfileEvent;
import com.sap.tc.logging.CreateLogfileListener;
import com.sap.tc.logging.EventDispatcher;
import com.sap.tc.logging.EventListener;
import com.sap.tc.logging.ExceptionHandling;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.GUId;
import com.sap.tc.logging.Group;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.MessageEvent;
import com.sap.tc.logging.MessageEventListener;
import com.sap.tc.logging.MsgType;
import com.sap.tc.logging.NewLogEvent;
import com.sap.tc.logging.NewLogListener;
import com.sap.tc.logging.OverwriteLogfileEvent;
import com.sap.tc.logging.OverwriteLogfileListener;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.ReleaseLogEvent;
import com.sap.tc.logging.ReleaseLogListener;
import com.sap.tc.logging.RemoveLogEvent;
import com.sap.tc.logging.RemoveLogListener;
import com.sap.tc.logging.ResetLogControllerListener;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.StreamLog;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.XMLFormatter;
import com.sap.tc.logging.interfaces.IRPPublisher;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class LoggingManager
extends ExceptionHandling
implements EventDispatcher {
    private static final String INVALID_LISTENER_TYPE = "Invalid listener type";
    private ThreadLocalInfo thrLocals = new ThreadLocalInfo();
    private static LoggingManager manager = null;
    private static IRPPublisher runPropPub = null;
    private static MessageEventListener msgListener = null;
    private static Location classLoc = null;
    private List<EventListener> newLogListeners = new Vector<EventListener>();
    private List<EventListener> removeLogListeners = new Vector<EventListener>();
    private List<EventListener> overwriteLogfileListeners = new Vector<EventListener>();
    private List<EventListener> createLogfileListeners = new Vector<EventListener>();
    private List<EventListener> resetLogControllerListener = new Vector<EventListener>();
    private List<EventListener> releaseLogListener = new Vector<EventListener>();
    private HashMap<String, Location> locations = new HashMap();
    private HashMap<String, Category> categories = new HashMap();
    public static final Formatter DEFAULT_FORMATTER = new TraceFormatter();

    private LoggingManager() {
    }

    public static synchronized LoggingManager getLoggingManager() {
        if (manager == null) {
            manager = new LoggingManager();
            LoggingManager.init();
        }
        return manager;
    }

    public static void registerRuntimePropertiesPublisher(IRPPublisher runPropPublisher) {
        runPropPub = runPropPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EventListener listener) throws IllegalArgumentException {
        Object object;
        boolean isFounded = false;
        if (listener instanceof NewLogListener) {
            object = this.newLogListeners;
            synchronized (object) {
                this.newLogListeners.add(listener);
            }
            isFounded = true;
            Collection existingLogs = this.getAllLogs();
            if (existingLogs != null) {
                Iterator logIter = existingLogs.iterator();
                while (logIter.hasNext()) {
                    try {
                        Log _log = (Log)logIter.next();
                        if (_log instanceof ConsoleLog) continue;
                        ((NewLogListener)listener).handleEvent(new NewLogEvent(_log));
                    }
                    catch (Exception ex) {
                        Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[addListener(EventListener listener)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the NewLogListener"});
                        Category.SYS_LOGGING.catchingIntByAPI(ex);
                        this.handleException(ex, 0);
                    }
                }
            }
        }
        if (listener instanceof RemoveLogListener) {
            object = this.removeLogListeners;
            synchronized (object) {
                this.removeLogListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof OverwriteLogfileListener) {
            object = this.overwriteLogfileListeners;
            synchronized (object) {
                this.overwriteLogfileListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof CreateLogfileListener) {
            object = this.createLogfileListeners;
            synchronized (object) {
                this.createLogfileListeners.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ResetLogControllerListener) {
            object = this.resetLogControllerListener;
            synchronized (object) {
                this.resetLogControllerListener.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ReleaseLogListener) {
            object = this.releaseLogListener;
            synchronized (object) {
                this.releaseLogListener.add(listener);
            }
            isFounded = true;
        }
        if (listener instanceof MessageEventListener) {
            object = this;
            synchronized (object) {
                msgListener = (MessageEventListener)listener;
            }
            isFounded = true;
        }
        if (!isFounded) {
            throw new IllegalArgumentException("Invalid listener type : " + listener.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EventListener listener) throws IllegalArgumentException {
        Object object;
        boolean isFounded = false;
        if (listener instanceof NewLogListener) {
            object = this.newLogListeners;
            synchronized (object) {
                this.newLogListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof RemoveLogListener) {
            object = this.removeLogListeners;
            synchronized (object) {
                this.removeLogListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof OverwriteLogfileListener) {
            object = this.overwriteLogfileListeners;
            synchronized (object) {
                this.overwriteLogfileListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof CreateLogfileListener) {
            object = this.createLogfileListeners;
            synchronized (object) {
                this.createLogfileListeners.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ResetLogControllerListener) {
            object = this.resetLogControllerListener;
            synchronized (object) {
                this.resetLogControllerListener.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof ReleaseLogListener) {
            object = this.releaseLogListener;
            synchronized (object) {
                this.releaseLogListener.remove(listener);
            }
            isFounded = true;
        }
        if (listener instanceof MessageEventListener) {
            object = this;
            synchronized (object) {
                msgListener = null;
            }
            isFounded = true;
        }
        if (!isFounded) {
            throw new IllegalArgumentException("Invalid listener type : " + listener.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllLogs() {
        Object[] lcs;
        HashSet<Log> existingLogs = new HashSet<Log>();
        if (this.locations != null) {
            lcs = null;
            HashMap<String, Location> hashMap = this.locations;
            synchronized (hashMap) {
                lcs = this.locations.values().toArray();
            }
            for (int i = 0; i < lcs.length; ++i) {
                existingLogs.addAll(((LogController)lcs[i]).getAllLogs());
            }
        }
        if (this.locations != null) {
            lcs = null;
            HashMap<String, Category> i = this.categories;
            synchronized (i) {
                lcs = this.categories.values().toArray();
            }
            for (int i2 = 0; i2 < lcs.length; ++i2) {
                existingLogs.addAll(((LogController)lcs[i2]).getAllLogs());
            }
        }
        return existingLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        HashMap<String, Location> hashMap = this.locations;
        synchronized (hashMap) {
            this.locations.clear();
        }
        Object[] tmpLC = this.categories.values().toArray();
        for (int i = 0; i < tmpLC.length; ++i) {
            this.release((LogController)tmpLC[i]);
        }
        LoggingManager.init();
    }

    protected void notifyWriteMessage(LogRecord record) {
        if (msgListener == null) {
            return;
        }
        try {
            if (msgListener.beRead(record)) {
                msgListener.handleEvent(new MessageEvent(record));
            }
        }
        catch (Exception ex) {
            APILogger.logIntByAPI(400, classLoc, "[notifyWriteMessage(LogRecord record)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the MessageEventListener"});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAddLog(Log newLog) {
        if (this.newLogListeners.isEmpty()) {
            return;
        }
        if (newLog instanceof ConsoleLog) {
            return;
        }
        Object[] lsnArray = null;
        NewLogEvent evt = new NewLogEvent(newLog);
        List<EventListener> list = this.newLogListeners;
        synchronized (list) {
            lsnArray = this.newLogListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((NewLogListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyAddLog(Log newLog)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the NewLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRemoveLog(Log removeLog) {
        if (this.removeLogListeners.isEmpty()) {
            return;
        }
        if (removeLog instanceof ConsoleLog) {
            return;
        }
        if (this.isBeingAttached(removeLog)) {
            return;
        }
        Object[] lsnArray = null;
        RemoveLogEvent evt = new RemoveLogEvent(removeLog);
        List<EventListener> list = this.removeLogListeners;
        synchronized (list) {
            lsnArray = this.removeLogListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((RemoveLogListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyRemoveLog(Log removeLog)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the RemoveLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOverwriteLogfile(FileLog fileLog) {
        if (this.overwriteLogfileListeners.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        OverwriteLogfileEvent evt = new OverwriteLogfileEvent(fileLog);
        List<EventListener> list = this.overwriteLogfileListeners;
        synchronized (list) {
            lsnArray = this.overwriteLogfileListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((OverwriteLogfileListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyOverwriteLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the OverwriteLogfileListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReleaseLogfile(FileLog fileLog) {
        if (this.releaseLogListener.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        ReleaseLogEvent evt = new ReleaseLogEvent(fileLog);
        List<EventListener> list = this.releaseLogListener;
        synchronized (list) {
            lsnArray = this.releaseLogListener.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((ReleaseLogListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyReleaseLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the ReleaseLogListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCreateLogfile(String filename, int limit, int cnt) {
        if (this.createLogfileListeners.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        CreateLogfileEvent evt = new CreateLogfileEvent(filename, limit, cnt);
        List<EventListener> list = this.createLogfileListeners;
        synchronized (list) {
            lsnArray = this.createLogfileListeners.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((CreateLogfileListener)lsnArray[i]).handleEvent(evt);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyCreateLogfile(String filename, int limit, int cnt)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the CreateLogfileListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLogControllerReset(LogController logController, boolean isResetTree) {
        if (this.resetLogControllerListener.isEmpty()) {
            return;
        }
        Object[] lsnArray = null;
        List<EventListener> list = this.resetLogControllerListener;
        synchronized (list) {
            lsnArray = this.resetLogControllerListener.toArray();
        }
        for (int i = 0; i < lsnArray.length; ++i) {
            try {
                ((ResetLogControllerListener)lsnArray[i]).handleEvent(logController, isResetTree);
                continue;
            }
            catch (Exception ex) {
                Category.SYS_LOGGING.logIntByAPI(400, classLoc, "[notifyLogControllerReset(LogController logController, boolean isResetTree)]", MSGCollection.LOGGING_MSG_ID_UNEXPECTED, MSGCollection.LOGGING_MSG_STR_UNEXPECTED, new String[]{"Implementation of the ResetLogControllerListener"});
                Category.SYS_LOGGING.catchingIntByAPI(ex);
                this.handleException(ex, 0);
            }
        }
    }

    protected static ThreadLocalInfo getThreadLocalInfo() {
        return LoggingManager.getLoggingManager().getThreadLocal();
    }

    protected ThreadLocalInfo getThreadLocal() {
        return this.thrLocals;
    }

    static IRPPublisher getRuntimePropertiesPublisher() {
        return runPropPub;
    }

    static MessageEventListener getMessageEventListener() {
        return msgListener;
    }

    Location getLocation(String name) {
        LinkedList parts = this.calculateNames('.', name);
        return this.getLocation(name, parts);
    }

    Category getCategory(String name) {
        LinkedList parts = this.calculateNames('/', name);
        return this.getCategory(name, parts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(LogController controller) {
        if (controller instanceof Location) {
            HashMap<String, Location> hashMap = this.locations;
            synchronized (hashMap) {
                this.locations.remove(controller.getName());
            }
        }
        if (!this.isPredefCategory(controller.getName())) {
            HashMap<String, Category> hashMap = this.categories;
            synchronized (hashMap) {
                this.categories.remove(controller.getName());
            }
        }
    }

    LogRecord getRecord() {
        return this.thrLocals.getRecord();
    }

    void setRecord(LogRecord rec) {
        this.thrLocals.setRecord(rec);
    }

    private boolean isPredefCategory(String name) {
        return Category.PREDEF_CATEGORIES.containsKey(name);
    }

    private static void init() {
        classLoc = Location.getLocation(LoggingManager.class);
        Location.getLocation("com.sap.tc.logging.Category");
        Location.getLocation(Configurator.class);
        Location.getLocation(ConsoleLog.class);
        Location.getLocation(FileLog.class);
        Location.getLocation(Formatter.class);
        Location.getLocation(GUId.class);
        Location.getLocation(ListFormatter.class);
        Location.getLocation(Location.class);
        Location.getLocation(Log.class);
        Location.getLocation(LogController.class);
        Location.getLocation(LogRecord.class);
        Location.getLocation(MsgType.class);
        Location.getLocation(PropertiesConfigurator.class);
        Location.getLocation(Severity.class);
        Location.getLocation(StreamLog.class);
        Location.getLocation(TraceFormatter.class);
        Location.getLocation(XMLFormatter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location getLocation(String locName, LinkedList components) {
        try {
            String name = ((String)components.getLast()).trim();
            Location loc = this.locations.get(name);
            if (loc == null) {
                if (components.size() == 1) {
                    loc = new Location(name);
                } else {
                    components.removeLast();
                    Location parent = this.getLocation(name, components);
                    loc = new Location(name, parent);
                }
                HashMap<String, Location> hashMap = this.locations;
                synchronized (hashMap) {
                    this.locations.put(name, loc);
                }
            }
            return loc;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Location : " + locName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Category getCategory(String catName, LinkedList components) {
        try {
            String name = (String)components.getLast();
            Category category = this.categories.get(name);
            if (category == null) {
                if (components.size() == 1) {
                    category = new Category(name);
                } else {
                    components.removeLast();
                    category = new Category(name, this.getCategory(name, components));
                }
                HashMap<String, Category> hashMap = this.categories;
                synchronized (hashMap) {
                    this.categories.put(name, category);
                }
            }
            return category;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Category : " + catName);
        }
    }

    private LinkedList calculateNames(char delimChar, String name) {
        LinkedList<String> res = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        if (delimChar == '.') {
            current.append("");
        } else {
            current.append("/");
        }
        res.add(current.toString());
        String delim = String.valueOf(delimChar);
        StringTokenizer toks = new StringTokenizer(name, delim);
        while (toks.hasMoreTokens()) {
            String nextTok = this.parseToken(toks.nextToken());
            if (nextTok.length() <= 0) continue;
            current.append(nextTok);
            res.add(current.toString());
            if (!toks.hasMoreTokens()) continue;
            current.append(delimChar);
        }
        return res;
    }

    private String parseToken(String token) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < token.length(); ++i) {
            char nextChar = token.charAt(i);
            if (nextChar == '\'' || nextChar == '/' || nextChar == '.') continue;
            if (i == 0 && Character.isJavaIdentifierStart(nextChar)) {
                res.append(nextChar);
                continue;
            }
            if (i > 0 && Character.isJavaIdentifierPart(nextChar)) {
                res.append(nextChar);
                continue;
            }
            res.append('x');
        }
        return res.toString();
    }

    protected boolean isBeingAttached(Log aLog) {
        return this.getAllLogs().contains(aLog);
    }

    static Category getLog() {
        return Category.SYS_LOGGING;
    }

    class ThreadLocalInfo
    extends ThreadLocal {
        ThreadLocalInfo() {
        }

        protected Object initialValue() {
            return new Locals();
        }

        public LogRecord getRecord() {
            return ((Locals)super.get()).getRecord();
        }

        public void setRecord(LogRecord rec) {
            ((Locals)super.get()).setRecord(rec);
        }

        public Group getGroup() {
            return ((Locals)super.get()).getGroup();
        }

        public void setGroup(Group group) {
            ((Locals)super.get()).setGroup(group);
        }

        public synchronized boolean isGroupInUse() {
            return ((Locals)super.get()).isGroupInUse();
        }
    }

    private static class Locals {
        private LogRecord rec = null;
        private Group group;

        private Locals() {
        }

        public synchronized LogRecord getRecord() {
            return this.rec;
        }

        public synchronized void setRecord(LogRecord rec) {
            this.rec = rec;
        }

        public synchronized Group getGroup() {
            return this.group;
        }

        public synchronized void setGroup(Group group) {
            this.group = group;
        }

        public synchronized boolean isGroupInUse() {
            return this.group != null;
        }
    }
}

