/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.reader;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.LogEvents;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.exceptions.DataException;
import com.sap.tc.logging.exceptions.FileDataException;
import com.sap.tc.logging.exceptions.UnsupportedFormatException;
import com.sap.tc.logging.interfaces.IBaseLog;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadLog;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sap.tc.logging.messagedepot.MessageAccessor;
import com.sap.tc.logging.reader.FileReadFilter;
import com.sap.tc.logging.reader.FileReadLog;
import com.sap.tc.logging.reader.LogRecordResultSet;
import com.sap.tc.logging.reader.ReaderLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ReadableLog
extends FileLog
implements IReadableLog {
    private static String subLoc = "ReadableLog";
    FileReadLog source = null;
    LogEventsListener localListener = new LogEventsListener();
    int grabCounter = 0;
    private String latestMSG;
    private String currentMSG;

    public ReadableLog(String pattern) {
        super(pattern);
        this.source = (FileReadLog)ReadableLog.createFileReadLog(new FileLog(pattern));
        this.setStatus(1);
        this.source.registerForLogEvents(this.localListener);
    }

    private ReadableLog(FileLog fileLog) {
        this.source = (FileReadLog)ReadableLog.createFileReadLog(fileLog);
        this.setStatus(1);
        this.source.registerForLogEvents(this.localListener);
    }

    private ReadableLog(FileLog fileLog, MessageAccessor accessor) {
        this.source = (FileReadLog)ReadableLog.createFileReadLog(fileLog, accessor);
        this.setStatus(1);
        this.source.registerForLogEvents(this.localListener);
    }

    public static IReadLog createFileReadLog(FileLog fileLog) {
        return new FileReadLog(fileLog);
    }

    public static IReadLog createFileReadLog(FileLog fileLog, MessageAccessor accessor) {
        return new FileReadLog(fileLog, accessor);
    }

    public static IReadLog createFileReadLog(String fileName) throws FileDataException {
        return new FileReadLog(fileName);
    }

    public static IReadLog createFileReadLog(String fileName, MessageAccessor accessor) throws FileDataException {
        return new FileReadLog(fileName, accessor);
    }

    public static IReadableLog createReadableLog(FileLog fileLog) {
        return ReadableLog.createReadableLog(fileLog, null);
    }

    public static IReadableLog createReadableLog(FileLog fileLog, MessageAccessor accessor) {
        ReadableLog rLogcopy = new ReadableLog(fileLog, accessor);
        rLogcopy.setName(fileLog.getName());
        rLogcopy.source.setName(fileLog.getName());
        rLogcopy.setDescription(fileLog.getDescription());
        rLogcopy.source.setDescription(fileLog.getDescription());
        rLogcopy.setPattern(fileLog.getPattern());
        rLogcopy.source.setPattern(fileLog.getPattern());
        rLogcopy.setFormatter(fileLog.getFormatter());
        rLogcopy.source.setFormatter(fileLog.getFormatter());
        rLogcopy.setCnt(fileLog.getCnt());
        rLogcopy.source.setSize(fileLog.getCnt());
        rLogcopy.setLimit(fileLog.getLimit());
        rLogcopy.source.setLimit(fileLog.getLimit());
        rLogcopy.setIndex(fileLog.getIndex());
        rLogcopy.source.setIndex(fileLog.getIndex());
        rLogcopy.setEncoding(fileLog.getEncoding());
        rLogcopy.source.setEncoding(fileLog.getEncoding());
        rLogcopy.setMode(fileLog.getMode());
        rLogcopy.source.setMode(fileLog.getMode());
        try {
            rLogcopy.source.open();
            rLogcopy.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rLogcopy;
    }

    public IReadableLog createReadableLog() {
        return ReadableLog.createReadableLog(this, null);
    }

    public IReadableLog createReadableLog(MessageAccessor accessor) {
        return ReadableLog.createReadableLog(this, accessor);
    }

    public ILoggingResultSet readLatestMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            this.source.open();
            this.source.moveToEOF();
            resultSet = (LogRecordResultSet)this.source.readPrevious(numberOfRecords);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public ILoggingResultSet readOldestMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            this.source.open();
            this.source.moveToBOF();
            resultSet = (LogRecordResultSet)this.source.readNext(numberOfRecords);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public ILoggingResultSet readPrevMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        if (!this.source.isOpened()) {
            resultSet = (LogRecordResultSet)this.readLatestMsgRecords(numberOfRecords);
        } else {
            try {
                resultSet = (LogRecordResultSet)this.source.readPrevious(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet readNextMsgRecords(int numberOfRecords) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        if (!this.source.isOpened()) {
            resultSet = (LogRecordResultSet)this.readOldestMsgRecords(numberOfRecords);
        } else {
            try {
                resultSet = (LogRecordResultSet)this.source.readNext(numberOfRecords);
            }
            catch (Exception ex) {
                resultSet = new LogRecordResultSet();
                resultSet.setStatus(-1);
                resultSet.setException(ex);
            }
        }
        return resultSet;
    }

    public ILoggingResultSet getNextMatch(String[] searchTokens) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        return this.getNextMatch(searchTokens, false);
    }

    public ILoggingResultSet getNextMatch(String[] searchTokens, boolean ignoreCase) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            if (searchTokens == null || searchTokens.length == 0) {
                throw new IllegalArgumentException("Conditional string is null or it is empty!");
            }
            if (!this.source.isOpened()) {
                this.source.open();
                this.source.moveToBOF();
            }
            FileReadFilter filter = new FileReadFilter(searchTokens, FileReadFilter.LOG_OPERATER_OR, !ignoreCase);
            this.source.addFilter(filter);
            resultSet = (LogRecordResultSet)this.source.readNext();
            this.source.removeFilter(filter);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public ILoggingResultSet getPreviousMatch(String[] searchTokens) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        return this.getPreviousMatch(searchTokens, false);
    }

    public ILoggingResultSet getPreviousMatch(String[] searchTokens, boolean ignoreCase) throws IllegalArgumentException, UnsupportedFormatException, FileNotFoundException, SecurityException, IOException {
        LogRecordResultSet resultSet;
        try {
            if (searchTokens == null || searchTokens.length == 0) {
                throw new IllegalArgumentException("Conditional string is null or it is empty!");
            }
            if (!this.source.isOpened()) {
                this.source.open();
                this.source.moveToEOF();
            }
            FileReadFilter filter = new FileReadFilter(searchTokens, FileReadFilter.LOG_OPERATER_OR, !ignoreCase);
            this.source.addFilter(filter);
            resultSet = (LogRecordResultSet)this.source.readPrevious();
            this.source.removeFilter(filter);
        }
        catch (Exception ex) {
            resultSet = new LogRecordResultSet();
            resultSet.setStatus(-1);
            resultSet.setException(ex);
        }
        return resultSet;
    }

    public boolean areLoggingAttributesEditable() {
        Collection existingLogs = LoggingManager.getLoggingManager().getAllLogs();
        return existingLogs.contains(this);
    }

    public String getFileBeingCurrentlyRead() {
        return this.source.getSource();
    }

    public long getFilePointer() throws IOException {
        try {
            return this.source.getBookMark();
        }
        catch (DataException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void seek(long filePointer) throws IOException {
        try {
            this.source.seek(filePointer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getLastModified() throws IOException {
        long result = 0L;
        try {
            result = this.source.getFileLatest().lastModified();
        }
        catch (Exception ex) {
            result = -1L;
        }
        return result;
    }

    public int status() {
        return this.source.status();
    }

    public synchronized void open() {
        try {
            this.source.open();
        }
        catch (Exception ex) {
            ReaderLogger.logIntByAPI(500, ReaderLogger.ReaderLocation, subLoc + "[open()]", MSGCollection.LOGGING_MSG_ID_OPEN_EXCEPTION, MSGCollection.LOGGING_MSG_STR_OPEN_EXCEPTION, new String[]{this.getName()});
            ReaderLogger.catchingIntByAPI(ex);
            this.handleException(ex);
        }
    }

    public synchronized void close() {
        try {
            if (this.source != null) {
                this.source.close();
            }
        }
        catch (Exception ex) {
            ReaderLogger.logIntByAPI(500, ReaderLogger.ReaderLocation, subLoc + "[close()]", MSGCollection.LOGGING_MSG_ID_CLOSE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_CLOSE_EXCEPTION, new String[]{this.getName()});
            ReaderLogger.catchingIntByAPI(ex);
            this.handleException(ex);
        }
    }

    public synchronized void setFormatter(Formatter formatter) {
        if (this.source != null) {
            try {
                this.source.setFormatter(formatter);
            }
            catch (Exception ex) {
                ReaderLogger.instrumentIntByAPI(subLoc + "[setFormatter(Formatter formatter)]", MSGCollection.FORMATTER_CHANGED_ON_OPEN_LOG(), new Object[]{this.getName()});
                this.close();
            }
        }
        this.setFormatterInt(formatter);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ArrayList readLatestRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readLatestMsgRecords(numMsg).getResults();
    }

    public ArrayList readOldestRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readOldestMsgRecords(numMsg).getResults();
    }

    public ArrayList readPrevRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readPrevMsgRecords(numMsg).getResults();
    }

    public ArrayList readNextRecords(int numMsg) throws IllegalArgumentException, UnsupportedFormatException, IOException {
        return (ArrayList)this.readNextMsgRecords(numMsg).getResults();
    }

    public long length() {
        return this.getFileLength();
    }

    class LogEventsListener
    implements LogEvents {
        LogEventsListener() {
        }

        public void eventLogIsClosed(IBaseLog log) {
        }

        public void eventLogIsOpen(IBaseLog log) {
            FileReadLog readLog = (FileReadLog)log;
            ReadableLog.this.setName(readLog.getSource());
            ReadableLog.this.setDescription(readLog.getDescription());
            ReadableLog.this.setPattern(readLog.getPattern());
            ReadableLog.this.setFormatter(readLog.getFormatter());
            ReadableLog.this.setCnt(readLog.getSize());
            ReadableLog.this.setLimit(readLog.getLimit());
            ReadableLog.this.setIndex(readLog.getIndex());
            ReadableLog.this.setEncoding(readLog.getEncoding());
            ReadableLog.this.setMode(readLog.getMode());
            ReadableLog.this.setStatus(readLog.status());
            ReadableLog.this.setFooter(readLog.getFooter());
            ReadableLog.this.setHeader(readLog.getHeader());
        }
    }
}

