/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConsoleLogTest
extends LoggingTestCase {
    private boolean wasLoggedInLog;
    private Log log;
    private Location loc;
    private Filter nonVetoingFilter;
    private Filter vetoingFilter;

    public ConsoleLogTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.log = new ConsoleLog();
        this.log.setSuppressing(true);
        this.log.resetLoggedCount();
        this.loc = Location.getLocation((Object)this);
        this.loc.addLog(this.log);
        this.loc.setEffectiveSeverity(300);
        this.vetoingFilter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return false;
            }
        };
        this.nonVetoingFilter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        };
    }

    public void testSeverityControlLocationHigher() {
        this.log.resetLoggedCount();
        this.log.setEffectiveSeverity(100);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.log.getLoggedCount() > 0;
        ConsoleLogTest.assertTrue((String)"message not written to log", (boolean)this.wasLoggedInLog);
    }

    public void testSeverityControlLocationLower() {
        this.log.resetLoggedCount();
        this.log.setEffectiveSeverity(400);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.log.getLoggedCount() > 0;
        ConsoleLogTest.assertTrue((String)"message written to log", (!this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public void testFilterControlNonVeto() {
        this.log.resetLoggedCount();
        this.log.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.log.getLoggedCount() > 0;
        ConsoleLogTest.assertTrue((String)"message not written to log", (boolean)this.wasLoggedInLog);
    }

    public void testFilterControlVeto() {
        this.log.resetLoggedCount();
        this.log.addFilter(this.vetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.log.getLoggedCount() > 0;
        ConsoleLogTest.assertTrue((String)"message written to log", (!this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(ConsoleLogTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ConsoleLogTest.suite());
    }
}

