/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.NewLogEvent;
import com.sap.tc.logging.NewLogListener;
import com.sap.tc.logging.RemoveLogEvent;
import com.sap.tc.logging.RemoveLogListener;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.io.File;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EventNotifTest
extends LoggingTestCase {
    static String outFileDir = System.getProperty("cfg.path");
    private static final int NUM_INSTANCES_PER_TEST = 1;
    Location masterLoc;
    Location anotherLoc;
    static ConsoleLog conLog;
    static FileLog fLog;
    static TestNewLogListener nLogListener;
    static TestRemoveLogListener rLogListener;

    public EventNotifTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.masterLoc = Location.getLocation("com.sap.master");
        this.anotherLoc = Location.getLocation("com.sap.anotherOne");
        nLogListener.reset();
        rLogListener.reset();
    }

    protected void tearDown() {
        super.tearDown();
        this.anotherLoc.removeLogs();
        this.masterLoc.removeLogs();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        TestSetup wrapper = new TestSetup((Test)suite){

            public void setUp() throws Exception {
                super.setUp();
                conLog = new ConsoleLog();
                fLog = outFileDir != null ? new FileLog(outFileDir + File.separator + "sampleTestingFileLogOutput.txt", (Formatter)new ListFormatter()) : new FileLog("sampleTestingFileLogOutput.txt", (Formatter)new ListFormatter());
                nLogListener = new TestNewLogListener();
                rLogListener = new TestRemoveLogListener();
                LoggingManager.getLoggingManager().addListener(nLogListener);
                LoggingManager.getLoggingManager().addListener(rLogListener);
            }

            public void tearDown() throws Exception {
                super.tearDown();
            }
        };
        for (int i = 0; i < 1; ++i) {
            suite.addTest((Test)new EventNotifTest("testFireNewLog"));
            suite.addTest((Test)new EventNotifTest("testFireSameNewLog"));
            suite.addTest((Test)new EventNotifTest("testFireRemoveAllLog"));
            suite.addTest((Test)new EventNotifTest("testFireRemovePartialLog"));
            suite.addTest((Test)new EventNotifTest("testFireSwitchLog"));
        }
        return wrapper;
    }

    public void testFireNewLog() {
        this.masterLoc.addLog(conLog);
        EventNotifTest.assertTrue((String)"console Log does not result in NewLogEvent firing", (nLogListener.numEvent() == 0 ? 1 : 0) != 0);
        this.masterLoc.addLog(fLog);
        EventNotifTest.assertTrue((String)"fileLog assignment should fire a NewLogEvent", (nLogListener.numEvent() == 1 ? 1 : 0) != 0);
    }

    public void testFireSameNewLog() {
        this.masterLoc.addLocalLog(fLog);
        this.anotherLoc.addLog(fLog);
        EventNotifTest.assertTrue((String)"Assigning same fileLog twice fire 2 NewLogEvents", (nLogListener.numEvent() == 2 ? 1 : 0) != 0);
    }

    public void testFireRemoveAllLog() {
        this.anotherLoc.addLog(conLog);
        this.anotherLoc.addLog(fLog);
        this.anotherLoc.removeLog(conLog);
        this.anotherLoc.removeLog(fLog);
        EventNotifTest.assertTrue((String)("All logs should be removed, but now: " + rLogListener.numEvent()), (rLogListener.numEvent() == 1 ? 1 : 0) != 0);
    }

    public void testFireRemovePartialLog() {
        this.anotherLoc.addLog(conLog);
        this.anotherLoc.addLog(fLog);
        this.masterLoc.addLog(fLog);
        EventNotifTest.assertTrue((String)"2 NewLogEvents for adding log procedure", (nLogListener.numEvent() == 2 ? 1 : 0) != 0);
        this.anotherLoc.removeLog(conLog);
        this.anotherLoc.removeLog(fLog);
        EventNotifTest.assertTrue((String)("Removing same fileLog once only has 0 removeLogEvent::" + rLogListener.numEvent()), (rLogListener.numEvent() == 0 ? 1 : 0) != 0);
    }

    public void testFireSwitchLog() {
        this.anotherLoc.addLog(fLog);
        this.anotherLoc.addPrivateLog(fLog);
        EventNotifTest.assertTrue((String)"adding same fileLog as different types of the same source fire more then 1 newEvent", (nLogListener.numEvent() == 1 ? 1 : 0) != 0);
        this.masterLoc.addLog(fLog);
        this.anotherLoc.addLocalLog(fLog);
        EventNotifTest.assertTrue((String)"same fileLog attached to more than 1 source", (nLogListener.numEvent() == 2 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)EventNotifTest.suite());
    }

    static class TestRemoveLogListener
    implements RemoveLogListener {
        int eventCnt;

        TestRemoveLogListener() {
        }

        public void handleEvent(RemoveLogEvent evt) {
            ++this.eventCnt;
        }

        void reset() {
            this.eventCnt = 0;
        }

        int numEvent() {
            return this.eventCnt;
        }
    }

    static class TestNewLogListener
    implements NewLogListener {
        int eventCnt;

        TestNewLogListener() {
        }

        public void handleEvent(NewLogEvent evt) {
            ++this.eventCnt;
        }

        void reset() {
            this.eventCnt = 0;
        }

        int numEvent() {
            return this.eventCnt;
        }
    }
}

