/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.FileLogInfoData;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FileHeaderLogTest
extends LoggingTestCase {
    private FileLog log;
    private Location loc;

    public FileHeaderLogTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(FileHeaderLogTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FileHeaderLogTest.suite());
    }

    protected void setUp() {
        String fileName = "test.%g.log";
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        this.log = new FileLog(fileName, 100000, 5);
        this.log.setFormatter(new TraceFormatter("TestPattern"));
        this.log.resetLoggedCount();
        this.loc = Location.getLocation(FileHeaderLogTest.class);
        this.loc.addLog(this.log);
        this.loc.setEffectiveSeverity(0);
    }

    public void testOldFormat() {
        this.loc.infoT("Test message");
        FileLogInfoData fileHeader = new FileLogInfoData(this.log);
        FileHeaderLogTest.assertTrue((String)"Headers are not equal!", (boolean)fileHeader.getHeader().equalsIgnoreCase(this.log.getHeader()));
        FileHeaderLogTest.assertTrue((String)"Version data are missing!", (fileHeader.getVerInUse().length() > 0 ? 1 : 0) != 0);
        FileHeaderLogTest.assertTrue((String)"File name is empty!", (fileHeader.getName().length() > 0 ? 1 : 0) != 0);
        FileHeaderLogTest.assertTrue((String)"File pattern is empty!", (fileHeader.getPattern().length() > 0 ? 1 : 0) != 0);
        FileHeaderLogTest.assertTrue((String)"File FileSet is wrong!", (boolean)fileHeader.getFileSet().equals("0, 5, 100000"));
        FileHeaderLogTest.assertTrue((String)"File FileSet index is wrong!", (fileHeader.getFileSetIndex() == 0 ? 1 : 0) != 0);
        FileHeaderLogTest.assertTrue((String)"File FileSet size is wrong!", (fileHeader.getFileSetSize() == 5 ? 1 : 0) != 0);
        FileHeaderLogTest.assertTrue((String)"File FileSet limit is wrong!", (fileHeader.getFileSetLimit() == 100000 ? 1 : 0) != 0);
        TraceFormatter formatter = (TraceFormatter)fileHeader.getFormatter();
        FileHeaderLogTest.assertTrue((String)"File formatter is null!", (fileHeader.getFormatter() != null ? 1 : 0) != 0);
        FileHeaderLogTest.assertTrue((String)"Formatter pattern is wrong!", (boolean)formatter.getPattern().equals("TestPattern"));
    }
}

