/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GetCategoryTest
extends LoggingTestCase {
    public GetCategoryTest(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testTopCategoryBottomUp() {
        Category category = Category.SYSTEM;
        Category rootCategory = Category.getRoot();
        if (!category.getParent().getName().equals(rootCategory.getName())) {
            GetCategoryTest.fail((String)"root category not recognized as parent of category \"/System\"");
        }
    }

    public void testTopCategoryTopDown() {
        Category rootCategory = Category.getRoot();
        Category category = Category.SYSTEM;
        if (!category.getParent().getName().equals(rootCategory.getName())) {
            GetCategoryTest.fail((String)"root category not recognized as parent of category \"/System\"");
        }
    }

    public void testMiddleCategoryBottomUp() {
        Category childCategory = Category.SYS_DATABASE;
        Category parentCategory = Category.SYSTEM;
        GetCategoryTest.assertSame((String)"category \"/System\" not recognized as parent of category \"/System/Database\"", (Object)childCategory.getParent(), (Object)parentCategory);
    }

    public void testMiddleCategoryTopDown() {
        Category parentCategory = Category.SYSTEM;
        Category childCategory = Category.SYS_DATABASE;
        GetCategoryTest.assertSame((String)"category \"/System\" not recognized as parent of category \"/System/Database\"", (Object)childCategory.getParent(), (Object)parentCategory);
    }

    public void testNameSyntaxError() {
        try {
            Category category = Category.getCategory(Category.SYSTEM, "Test/Test_1/Test_2");
            GetCategoryTest.assertTrue((String)"category \"/System/Test/Test_1/Test_2\" was not paresed properly", (boolean)category.getName().equals("/System/Test/Test_1/Test_2"));
        }
        catch (IllegalArgumentException exc) {
            GetCategoryTest.fail((String)"category name parsing error");
        }
    }

    public void testEmptyNameSyntaxError() {
        try {
            Category category = Category.getCategory(Category.SYSTEM, "");
            GetCategoryTest.assertTrue((String)"category \"/System/\" not recognized as a \"/System\"", (boolean)category.getName().equals("/System"));
        }
        catch (IllegalArgumentException exc) {
            GetCategoryTest.fail((String)"category name parsing error");
        }
    }

    public void testLeadingDoubleSlashSyntaxError() {
        try {
            Category category = Category.getCategory(Category.SYSTEM, "//Test");
            GetCategoryTest.assertTrue((String)"category \"/System//Test\" not recognized as a \"/System/Test\"", (boolean)category.getName().equals("/System/Test"));
        }
        catch (IllegalArgumentException exc) {
            GetCategoryTest.fail((String)"category name parsing error");
        }
    }

    public void testMultipleSyntaxError() {
        try {
            Category category = Category.getCategory(Category.SYSTEM, "/../Test../.");
            GetCategoryTest.assertTrue((String)"category \"/System//../Test../.\" was not recognized as a \"/System/Test\"", (boolean)category.getName().equals("/System/Test"));
        }
        catch (IllegalArgumentException exc) {
            GetCategoryTest.fail((String)"category name parsing error");
        }
    }

    public void testRelease() {
    }

    public void testReleasePredefinedCategory() {
        Category.SYS_DATABASE.release();
        Category newCategory = Category.getCategory(Category.SYSTEM, "Database");
        GetCategoryTest.assertTrue((String)"Request does not yield the same category after release", (Category.SYS_DATABASE == newCategory ? 1 : 0) != 0);
    }

    public void testReleaseWithRelationSeverity() {
        Category category = Category.getCategory(Category.SYSTEM, "Test");
        Location loc = Location.getLocation("com");
        loc.setEffectiveSeverity(category, 300);
        category.release();
        GetCategoryTest.assertTrue((String)"Relative severity not discarded after release", (!loc.beInfo(category) ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(GetCategoryTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GetCategoryTest.suite());
    }
}

