/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GetLocationTest
extends LoggingTestCase {
    public GetLocationTest(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testTopLocationBottomUp() {
        Location loc = Location.getLocation("com");
        Location rootLoc = Location.getRoot();
        GetLocationTest.assertSame((String)"root location not recognized as parent of location \"com\"", (Object)loc.getParent(), (Object)rootLoc);
    }

    public void testTopLocationTopDown() {
        Location rootLoc = Location.getRoot();
        Location loc = Location.getLocation("com");
        GetLocationTest.assertSame((String)"root location not recognized as parent of location \"com\"", (Object)loc.getParent(), (Object)rootLoc);
    }

    public void testMiddleLocationBottomUp() {
        Location loc = Location.getLocation("com.sap");
        Location parentLoc = Location.getLocation("com");
        GetLocationTest.assertSame((String)"location \"com\" not recognized as parent of location \"com.sap\"", (Object)loc.getParent(), (Object)parentLoc);
    }

    public void testMiddleLocationTopDown() {
        Location parentLoc = Location.getLocation("com");
        Location loc = Location.getLocation("com.sap");
        GetLocationTest.assertSame((String)"location \"com\" not recognized as parent of location \"com.sap\"", (Object)loc.getParent(), (Object)parentLoc);
    }

    public void testLeadingDotSyntaxError() {
        try {
            Location loc = Location.getLocation(".com.sap");
            GetLocationTest.assertTrue((String)"location \".com.sap\" not recognized as \"com.sap\"", (boolean)loc.getName().equals("com.sap"));
        }
        catch (IllegalArgumentException exc) {
            GetLocationTest.fail((String)"location name parsing error");
        }
    }

    public void testTrailingDotSyntaxError() {
        try {
            Location loc = Location.getLocation("com.sap.");
            GetLocationTest.assertTrue((String)"location \"com.sap.\" not recognized as \"com.sap\"", (boolean)loc.getName().equals("com.sap"));
        }
        catch (IllegalArgumentException exc) {
            GetLocationTest.fail((String)"location name parsing error");
        }
    }

    public void testDoubleDotSyntaxError() {
        try {
            Location loc = Location.getLocation("com..sap");
            GetLocationTest.assertTrue((String)"location \"com..sap\" not recognized as \"com.sap\"", (boolean)loc.getName().equals("com.sap"));
        }
        catch (IllegalArgumentException exc) {
            GetLocationTest.fail((String)"location name parsing error");
        }
    }

    public void testMultipleSyntaxError() {
        try {
            Location loc = Location.getLocation("..com./.sap.//.");
            GetLocationTest.assertTrue((String)"location \"..com./.sap.//.\" not recognized as \"com.sap\"", (boolean)loc.getName().equals("com.sap"));
        }
        catch (IllegalArgumentException exc) {
            GetLocationTest.fail((String)"location name parsing error");
        }
    }

    public void testRelease() {
        Location loc = Location.getLocation("com");
        loc.release();
        Location newLoc = Location.getLocation("com");
        GetLocationTest.assertTrue((String)"Request does not yield different location after release", (loc != newLoc ? 1 : 0) != 0);
    }

    public void testReleaseWithRelationSeverity() {
        Location loc = Location.getLocation("com");
        Category category = Category.SYSTEM;
        category.setEffectiveSeverity(loc, 300);
        loc.release();
        GetLocationTest.assertTrue((String)"Relative severity not discarded after release", (!category.beInfo(loc) ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(GetLocationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GetLocationTest.suite());
    }
}

