/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCBundleConfigurationTest
extends LoggingTestCase {
    private Category category;
    private Category childCategory;

    public LCBundleConfigurationTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.category = Category.SYSTEM;
        this.childCategory = Category.SYS_DATABASE;
    }

    public void testSetBundle() {
        String bundle = "Messages";
        this.category.setResourceBundleName("Messages");
        LCBundleConfigurationTest.assertSame((String)"bundle not set for category", (Object)this.category.getResourceBundleName(), (Object)"Messages");
    }

    public void testInheritance() {
        String bundle = "Messages";
        this.category.setResourceBundleName("Messages");
        LCBundleConfigurationTest.assertSame((String)"bundle not passed on to child category", (Object)this.childCategory.getResourceBundleName(), (Object)"Messages");
    }

    public void testParentChildBundle() {
        String bundle = "Messages";
        String childBundle = "ChildMessages";
        this.category.setResourceBundleName("Messages");
        this.childCategory.setResourceBundleName("ChildMessages");
        LCBundleConfigurationTest.assertSame((String)"bundle overridden for child category", (Object)this.childCategory.getResourceBundleName(), (Object)"ChildMessages");
    }

    public void testChildParentBundle() {
        String bundle = "Messages";
        String childBundle = "ChildMessages";
        this.childCategory.setResourceBundleName("ChildMessages");
        this.category.setResourceBundleName("Messages");
        LCBundleConfigurationTest.assertSame((String)"bundle overridden for child category", (Object)this.childCategory.getResourceBundleName(), (Object)"ChildMessages");
    }

    public void testParentResetInheritance() {
        String bundle = "Messages";
        this.category.setResourceBundleName("Messages");
        this.childCategory.setResourceBundleName("Messages");
        this.category.setResourceBundleName();
        LCBundleConfigurationTest.assertSame((String)"bundle overridden for child category", (Object)this.childCategory.getResourceBundleName(), (Object)"Messages");
    }

    public void testChildResetInheritance() {
        String bundle = "Messages";
        String childBundle = "ChildMessages";
        this.category.setResourceBundleName("Messages");
        this.childCategory.setResourceBundleName("ChildMessages");
        this.childCategory.setResourceBundleName();
        LCBundleConfigurationTest.assertSame((String)"bundle overridden for child category", (Object)this.childCategory.getResourceBundleName(), (Object)"Messages");
    }

    public static Test suite() {
        return new TestSuite(LCBundleConfigurationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCBundleConfigurationTest.suite());
    }
}

