/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCDeadlockTest
extends LoggingTestCase {
    private static final int LOOP = 32768;
    private static final int WAIT = 5;
    private Location rootLoc;
    private Location loc;

    public LCDeadlockTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.rootLoc = Location.getRoot();
        this.loc = Location.getLocation((Object)this);
    }

    public void testImplicitGroupClose() {
        class Actor
        extends Thread {
            private Location outerLoc;
            private Location innerLoc;

            Actor(String name, Location outerLoc, Location innerLoc) {
                super(name);
                this.outerLoc = outerLoc;
                this.innerLoc = innerLoc;
            }

            public void run() {
                for (int i = 0; i < 32768; ++i) {
                    this.outerLoc.entering();
                    this.innerLoc.entering();
                    this.outerLoc.exiting();
                }
            }
        }
        Actor actor1 = new Actor("Actor-1", this.rootLoc, this.loc);
        Actor actor2 = new Actor("Actor-2", this.loc, this.rootLoc);
        actor1.start();
        actor2.start();
        try {
            actor1.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LCDeadlockTest.assertTrue((String)"alive threads cause probable deadlock", (!actor1.isAlive() ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(LCDeadlockTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCDeadlockTest.suite());
    }
}

