/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCFilterConfigurationTest
extends LoggingTestCase {
    private Category category;
    private Filter filter;

    public LCFilterConfigurationTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.category = Category.getRoot();
        this.filter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        };
        this.category.removeFilters();
    }

    public void testAddFilter() {
        this.category.addFilter(this.filter);
        LCFilterConfigurationTest.assertTrue((String)"filter not attached to category", (boolean)this.category.getFilters().iterator().hasNext());
    }

    public void testAddFilterMultiple() {
        this.category.addFilter(this.filter);
        this.category.addFilter(this.filter);
        Iterator iter = this.category.getFilters().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!found) {
                found = true;
                iter.next();
                continue;
            }
            LCFilterConfigurationTest.fail((String)"filter attached twice to category");
        }
        LCFilterConfigurationTest.assertTrue((String)"filter not attached to category", (boolean)found);
    }

    public void testRemoveFilter() {
        Filter anotherFilter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        };
        this.category.addFilter(this.filter);
        this.category.addFilter(anotherFilter);
        this.category.removeFilter(anotherFilter);
        Iterator iter = this.category.getFilters().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!found) {
                if (iter.next() == this.filter) {
                    found = true;
                    continue;
                }
                LCFilterConfigurationTest.fail((String)"filter not removed from category");
                continue;
            }
            LCFilterConfigurationTest.fail((String)"filter not removed from category");
        }
        LCFilterConfigurationTest.assertTrue((String)"both filters removed from category", (boolean)found);
    }

    public void testRemoveFilters() {
        this.category.addFilter(this.filter);
        this.category.addFilter(new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        });
        this.category.removeFilters();
        if (this.category.getFilters().iterator().hasNext()) {
            LCFilterConfigurationTest.fail((String)"filters not removed from category");
        }
    }

    public static Test suite() {
        return new TestSuite(LCFilterConfigurationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCFilterConfigurationTest.suite());
    }
}

