/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCFilterControlTest
extends LoggingTestCase {
    private boolean wasLoggedInLog;
    private boolean wasLoggedInLC;
    private Location rootLoc;
    private Location loc;
    private Log console;
    private Filter nonVetoingFilter;
    private Filter vetoingFilter;

    public LCFilterControlTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.rootLoc = Location.getRoot();
        this.rootLoc.setEffectiveSeverity(300);
        this.rootLoc.resetLoggedCount();
        this.loc = Location.getLocation((Object)this);
        this.loc.setEffectiveSeverity(300);
        this.loc.resetLoggedCount();
        this.console = new ConsoleLog();
        this.console.setSuppressing(true);
        this.nonVetoingFilter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        };
        this.vetoingFilter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return false;
            }
        };
    }

    public void testImmediateLogNonVeto() {
        this.console.resetLoggedCount();
        this.loc.addLog(this.console);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testImmediateLogVeto() {
        this.console.resetLoggedCount();
        this.loc.addLog(this.console);
        this.loc.addFilter(this.vetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message written", (!this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public void testImmediateLogNonVetoVeto() {
        this.console.resetLoggedCount();
        this.loc.addLog(this.console);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.addFilter(this.vetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message written", (!this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public void testImmediateLogVetoNonVeto() {
        this.console.resetLoggedCount();
        this.loc.addLog(this.console);
        this.loc.addFilter(this.vetoingFilter);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message written", (!this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public void testParentLogVeto() {
        this.console.resetLoggedCount();
        this.rootLoc.addLog(this.console);
        this.rootLoc.addFilter(this.vetoingFilter);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testParentLogNonVeto() {
        this.console.resetLoggedCount();
        this.rootLoc.addLog(this.console);
        this.rootLoc.addFilter(this.nonVetoingFilter);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testParentLocalLogVeto() {
        this.console.resetLoggedCount();
        this.loc.resetLoggedCount();
        this.rootLoc.addLocalLog(this.console);
        this.rootLoc.addFilter(this.vetoingFilter);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        this.wasLoggedInLC = this.loc.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message written", (!this.wasLoggedInLC && !this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public void testParentLocalLogNonVeto() {
        this.console.resetLoggedCount();
        this.rootLoc.addLocalLog(this.console);
        this.rootLoc.addFilter(this.nonVetoingFilter);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testImmediatePrivateLogNonVeto() {
        this.console.resetLoggedCount();
        this.loc.addPrivateLog(this.console);
        this.rootLoc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testParentPrivateLogNonVeto() {
        this.console.resetLoggedCount();
        this.loc.resetLoggedCount();
        this.rootLoc.addPrivateLog(this.console);
        this.rootLoc.addFilter(this.nonVetoingFilter);
        this.loc.addFilter(this.nonVetoingFilter);
        this.loc.logT(300, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        this.wasLoggedInLC = this.loc.getLoggedCount() > 0;
        LCFilterControlTest.assertTrue((String)"message written", (!this.wasLoggedInLog && !this.wasLoggedInLC ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(LCFilterControlTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCFilterControlTest.suite());
    }
}

