/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCGroupTest
extends LoggingTestCase {
    private boolean wasLogged;
    private Log console;
    private Location loc;
    private Category category;
    private Category childCategory;

    public LCGroupTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.console = new ConsoleLog();
        this.console.setSuppressing(true);
        this.loc = Location.getRoot();
        this.category = Category.getRoot();
        this.category.setEffectiveSeverity(400);
        this.category.resetLoggedCount();
        this.category.removeLogs();
        this.category.addLog(this.console);
        this.childCategory = Category.SYSTEM;
        this.childCategory.resetLoggedCount();
    }

    public void testActiveGroup() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.groupT("Opening group");
        this.wasLogged = this.category.getLoggedCount() > 0;
        LCGroupTest.assertTrue((String)"message not written", (boolean)this.wasLogged);
        this.category.closeGroup();
    }

    public void testPassiveGroup() {
        this.category.resetLoggedCount();
        this.category.openGroup(300, this.loc);
        this.category.groupT("Opening group");
        this.wasLogged = this.category.getLoggedCount() > 0;
        LCGroupTest.assertTrue((String)"message written", (!this.wasLogged ? 1 : 0) != 0);
        this.category.closeGroup();
    }

    public void testActiveGroupImplicitOutputBeforeOpen() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.openGroup(400, this.loc);
        LCGroupTest.assertTrue((String)"implicit opening message not written before another group opening", (this.category.getLoggedCount() == 2 ? 1 : 0) != 0);
        this.category.closeGroup();
        this.category.closeGroup();
    }

    public void testActiveGroupImplicitOutputBeforeClose() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.closeGroup();
        this.wasLogged = this.category.getLoggedCount() > 0;
        LCGroupTest.assertTrue((String)"implicit opening message not written before group closing", (boolean)this.wasLogged);
    }

    public void testActiveGroupNoImplicitOpenMessageBeforeGroupMessage() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.groupT("Opening message");
        LCGroupTest.assertEquals((String)"implicit opening message written before group message", (int)this.category.getLoggedCount(), (int)2);
        this.category.closeGroup();
    }

    public void testActiveGroupImplicitOpenMessageBeforeNormalMessage() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.warningT(this.loc, "Normal message");
        LCGroupTest.assertEquals((String)"implicit opening message not written before normal message", (int)this.category.getLoggedCount(), (int)2);
        this.category.closeGroup();
    }

    public void testActiveGroupImplicitCloseMessageBeforeOpen() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.closeGroup();
        this.category.openGroup(400, this.loc);
        LCGroupTest.assertEquals((String)"implicit closing message not written before another group opening", (int)this.category.getLoggedCount(), (int)3);
        this.category.closeGroup();
    }

    public void testActiveGroupImplicitCloseMessageBeforeClose() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.openGroup(400, this.loc);
        this.category.closeGroup();
        this.category.closeGroup();
        LCGroupTest.assertEquals((String)"implicit closing message not written before another group closing", (int)this.category.getLoggedCount(), (int)4);
    }

    public void testActiveGroupNoImplicitCloseMessageBeforeGroupMessage() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.closeGroup();
        this.category.groupT("Closing message");
        LCGroupTest.assertEquals((String)"implicit closing message written before group message", (int)this.category.getLoggedCount(), (int)2);
    }

    public void testActiveGroupImplicitCloseMessageBeforeNormalMessage() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.category.closeGroup();
        this.category.warningT(this.loc, "Normal message");
        LCGroupTest.assertEquals((String)"implicit closing message not written before normal message", (int)this.category.getLoggedCount(), (int)3);
    }

    public void testActiveGroupImplicitCloseBeforeSkippingClose() {
        this.category.resetLoggedCount();
        this.childCategory.setEffectiveSeverity(400);
        this.category.openGroup(400, this.loc);
        this.childCategory.openGroup(400, this.loc);
        this.category.closeGroup();
        LCGroupTest.assertEquals((String)"no implicit group closing before a skipping group closing", (int)this.category.getLoggedCount(), (int)3);
    }

    public void testActiveGroupTwoImplicitClosesBeforeSkippingClose() {
        this.category.resetLoggedCount();
        this.category.openGroup(400, this.loc);
        this.childCategory.openGroup(400, this.loc);
        this.childCategory.openGroup(400, this.loc);
        this.category.closeGroup();
        LCGroupTest.assertEquals((String)"no implicit group closings before a skipping group closing", (int)this.category.getLoggedCount(), (int)4);
    }

    public void testLocalLogActiveGroupImplicitCloseBeforeSkippingClose() {
        this.category.resetLoggedCount();
        this.category.addLocalLog(this.console);
        this.category.openGroup(400, this.loc);
        this.childCategory.openGroup(400, this.loc);
        this.category.closeGroup();
        LCGroupTest.assertEquals((String)"no implicit group closing before a skipping group closing", (int)this.category.getLoggedCount(), (int)3);
    }

    public void testLocalLogActiveGroupTwoImplicitClosesBeforeSkippingClose() {
        this.category.resetLoggedCount();
        this.category.addLocalLog(this.console);
        this.category.openGroup(400, this.loc);
        this.childCategory.openGroup(400, this.loc);
        this.childCategory.openGroup(400, this.loc);
        this.category.closeGroup();
        LCGroupTest.assertEquals((String)"no implicit group closings before a skipping group closing", (int)this.category.getLoggedCount(), (int)4);
    }

    public static Test suite() {
        return new TestSuite(LCGroupTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCGroupTest.suite());
    }
}

