/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCLogConfigurationTest
extends LoggingTestCase {
    private Category category;
    private Log log;

    public LCLogConfigurationTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.category = Category.getRoot();
        this.log = new ConsoleLog();
        this.category.removeLogs();
    }

    public void testAddLog() {
        this.category.addLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log not attached to category", (boolean)this.category.getLogs().iterator().hasNext());
    }

    public void testAddLocalLog() {
        this.category.addLocalLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log not attached to category", (boolean)this.category.getLocalLogs().iterator().hasNext());
    }

    public void testAddPrivateLog() {
        this.category.addPrivateLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log not attached to category", (boolean)this.category.getPrivateLogs().iterator().hasNext());
    }

    public void testAddNormalLocalLog() {
        this.category.addLog(this.log);
        this.category.addLocalLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log attached twice or not attached to location", (this.category.getLogs().iterator().hasNext() && !this.category.getLocalLogs().iterator().hasNext() ? 1 : 0) != 0);
    }

    public void testAddNormalPrivateLog() {
        this.category.addPrivateLog(this.log);
        this.category.addLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log attached twice or not attached to location", (!this.category.getLogs().iterator().hasNext() && this.category.getPrivateLogs().iterator().hasNext() ? 1 : 0) != 0);
    }

    public void testAddLocalNormalLog() {
        this.category.addLocalLog(this.log);
        this.category.addLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log attached twice or not attached to location", (this.category.getLocalLogs().iterator().hasNext() && !this.category.getLogs().iterator().hasNext() ? 1 : 0) != 0);
    }

    public void testAddLocalPrivateLog() {
        this.category.addLocalLog(this.log);
        this.category.addPrivateLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log attached twice or not attached to location", (this.category.getLocalLogs().iterator().hasNext() && !this.category.getPrivateLogs().iterator().hasNext() ? 1 : 0) != 0);
    }

    public void testAddPrivateNormalLog() {
        this.category.addLog(this.log);
        this.category.addPrivateLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log attached twice or not attached to location", (!this.category.getPrivateLogs().iterator().hasNext() && this.category.getLogs().iterator().hasNext() ? 1 : 0) != 0);
    }

    public void testAddPrivateLocalLog() {
        this.category.addPrivateLog(this.log);
        this.category.addLocalLog(this.log);
        LCLogConfigurationTest.assertTrue((String)"log attached twice or not attached to location", (this.category.getPrivateLogs().iterator().hasNext() && !this.category.getLocalLogs().iterator().hasNext() ? 1 : 0) != 0);
    }

    public void testRemoveLog() {
        ConsoleLog anotherLog = new ConsoleLog();
        this.category.addLog(this.log);
        this.category.addLog(anotherLog);
        this.category.removeLog(anotherLog);
        Iterator<Log> iter = this.category.getLogs().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!found) {
                if (iter.next() == this.log) {
                    found = true;
                    continue;
                }
                LCLogConfigurationTest.fail((String)"log not removed from category");
                continue;
            }
            LCLogConfigurationTest.fail((String)"log not removed from category");
        }
        LCLogConfigurationTest.assertTrue((String)"both logs removed from category", (boolean)found);
    }

    public void testRemoveLocalLog() {
        ConsoleLog anotherLog = new ConsoleLog();
        this.category.addLocalLog(this.log);
        this.category.addLocalLog(anotherLog);
        this.category.removeLog(anotherLog);
        Iterator<Log> iter = this.category.getLocalLogs().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!found) {
                if (iter.next() == this.log) {
                    found = true;
                    continue;
                }
                LCLogConfigurationTest.fail((String)"log not removed from category");
                continue;
            }
            LCLogConfigurationTest.fail((String)"log not removed from category");
        }
        LCLogConfigurationTest.assertTrue((String)"both logs removed from category", (boolean)found);
    }

    public void testRemovePrivateLog() {
        ConsoleLog anotherLog = new ConsoleLog();
        this.category.addPrivateLog(this.log);
        this.category.addPrivateLog(anotherLog);
        this.category.removeLog(anotherLog);
        Iterator<Log> iter = this.category.getPrivateLogs().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!found) {
                if (iter.next() == this.log) {
                    found = true;
                    continue;
                }
                LCLogConfigurationTest.fail((String)"log not removed from category");
                continue;
            }
            LCLogConfigurationTest.fail((String)"log not removed from category");
        }
        LCLogConfigurationTest.assertTrue((String)"both logs removed from category", (boolean)found);
    }

    public void testRemoveLogs() {
        this.category.addLog(this.log);
        this.category.addLocalLog(new ConsoleLog());
        this.category.addPrivateLog(new ConsoleLog());
        this.category.removeLogs();
        if (this.category.getLogs().iterator().hasNext() || this.category.getLocalLogs().iterator().hasNext() || this.category.getPrivateLogs().iterator().hasNext()) {
            LCLogConfigurationTest.fail((String)"logs not removed from category");
        }
    }

    public static Test suite() {
        return new TestSuite(LCLogConfigurationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCLogConfigurationTest.suite());
    }
}

