/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCLogRecordReturnTest
extends LoggingTestCase {
    private Location loc;
    private Category rootCategory;
    private Category category;
    private Log console;

    public LCLogRecordReturnTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.rootCategory = Category.getRoot();
        this.category = Category.getCategory(Category.SYSTEM, "Category");
        this.loc = Location.getLocation((Object)this);
        this.console = new ConsoleLog();
        this.console.setSuppressing(true);
        this.category.removeLogs();
    }

    public void testImmediateLog() {
        LogRecord returnedRec = null;
        this.category.addLog(this.console);
        this.category.setEffectiveSeverity(300);
        returnedRec = this.category.logT(300, this.loc, "Message");
        LCLogRecordReturnTest.assertNotNull((String)"message not written", (Object)returnedRec);
    }

    public void testImmediateLogHigher() {
        LogRecord returnedRec = null;
        this.category.addLog(this.console);
        this.category.setEffectiveSeverity(400);
        returnedRec = this.category.logT(300, this.loc, "Message");
        LCLogRecordReturnTest.assertNull((String)"message written", (Object)returnedRec);
    }

    public void testHigherImmediateLog() {
        LogRecord returnedRec = null;
        this.console.setEffectiveSeverity(400);
        this.category.addLog(this.console);
        this.category.setEffectiveSeverity(300);
        returnedRec = this.category.logT(300, this.loc, "Message");
        LCLogRecordReturnTest.assertNull((String)"message written", (Object)returnedRec);
    }

    public void testHigherParentLog() {
        LogRecord returnedRec = null;
        this.rootCategory.addLog(this.console);
        this.rootCategory.setEffectiveSeverity(400);
        this.category.setEffectiveSeverity(300);
        returnedRec = this.category.logT(300, this.loc, "Message");
        LCLogRecordReturnTest.assertNotNull((String)"message not written", (Object)returnedRec);
    }

    public void testHigherParentLocalLog() {
        LogRecord returnedRec = null;
        this.rootCategory.addLocalLog(this.console);
        this.rootCategory.setEffectiveSeverity(400);
        this.category.setEffectiveSeverity(300);
        returnedRec = this.category.logT(300, this.loc, "Message");
        LCLogRecordReturnTest.assertNull((String)"message written", (Object)returnedRec);
    }

    public void testHigherParentPrivateLog() {
        LogRecord returnedRec = null;
        this.rootCategory.addPrivateLog(this.console);
        this.rootCategory.setEffectiveSeverity(300);
        this.category.setEffectiveSeverity(300);
        returnedRec = this.category.logT(300, this.loc, "Message");
        LCLogRecordReturnTest.assertNull((String)"message not written", (Object)returnedRec);
    }

    public static Test suite() {
        return new TestSuite(LCLogRecordReturnTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCLogRecordReturnTest.suite());
    }
}

