/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LCSeverityControlTest
extends LoggingTestCase {
    private boolean wasLoggedInLog;
    private boolean wasLoggedInLC;
    private Location loc;
    private Category rootCategory;
    private Category category;
    private Log console;

    public LCSeverityControlTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.loc = Location.getLocation((Object)this);
        this.rootCategory = Category.getRoot();
        this.rootCategory.removeLogs();
        this.category = Category.getCategory(Category.SYSTEM, "Category");
        this.rootCategory.resetLoggedCount();
        this.console = new ConsoleLog();
        this.console.setSuppressing(true);
    }

    public void testImmediateLog() {
        this.console.resetLoggedCount();
        this.category.addLog(this.console);
        this.category.setEffectiveSeverity(300);
        this.category.logT(300, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testParentLogHigher() {
        this.console.resetLoggedCount();
        Category parent = Category.getCategory(Category.APPLICATIONS, "test");
        parent.setEffectiveSeverity(400);
        parent.addLog(this.console);
        Category child = Category.getCategory(parent, "child");
        child.setEffectiveSeverity(300);
        child.logT(300, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
        this.console.resetLoggedCount();
        this.rootCategory.addLog(this.console);
        this.rootCategory.setEffectiveSeverity(400);
        this.category.setEffectiveSeverity(300);
        this.category.logT(300, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testParentLogLower() {
        this.console.resetLoggedCount();
        this.rootCategory.addLog(this.console);
        this.rootCategory.setEffectiveSeverity(300);
        this.category.setEffectiveSeverity(400);
        this.category.logT(400, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testParentLocalLogHigher() {
        this.console.resetLoggedCount();
        this.category.resetLoggedCount();
        this.rootCategory.addLocalLog(this.console);
        this.rootCategory.setEffectiveSeverity(400);
        this.category.setEffectiveSeverity(300);
        this.category.logT(300, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        this.wasLoggedInLC = this.category.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message written", (!this.wasLoggedInLC || !this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public void testParentLocalLogLower() {
        this.console.resetLoggedCount();
        this.rootCategory.addLocalLog(this.console);
        this.rootCategory.setEffectiveSeverity(100);
        this.category.setEffectiveSeverity(300);
        this.category.logT(300, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testImmediatePrivateLog() {
        this.console.resetLoggedCount();
        this.category.addPrivateLog(this.console);
        this.category.setEffectiveSeverity(300);
        this.category.logT(300, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message not written", (boolean)this.wasLoggedInLog);
    }

    public void testParentPrivateLogLower() {
        this.console.resetLoggedCount();
        this.category.resetLoggedCount();
        this.rootCategory.addPrivateLog(this.console);
        this.rootCategory.setEffectiveSeverity(300);
        this.category.setEffectiveSeverity(400);
        this.category.logT(400, this.loc, "Message");
        this.wasLoggedInLog = this.console.getLoggedCount() > 0;
        this.wasLoggedInLC = this.category.getLoggedCount() > 0;
        LCSeverityControlTest.assertTrue((String)"message written", (!this.wasLoggedInLC || !this.wasLoggedInLog ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(LCSeverityControlTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LCSeverityControlTest.suite());
    }
}

