/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.ResetLogControllerListener;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LogControllerResetTest
extends LoggingTestCase
implements ResetLogControllerListener {
    private Location loc_1;
    private Location loc_2;
    private Log console;
    private Filter testFilter;

    public LogControllerResetTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.loc_1 = Location.getLocation("com.sap.test");
        this.loc_2 = Location.getLocation("com.sap.test.logging");
        this.loc_1.setEffectiveSeverity(300);
        this.loc_2.setEffectiveSeverity(400);
        this.console = new ConsoleLog();
        this.console.setSuppressing(true);
        this.loc_1.addLog(this.console);
        this.loc_1.addPrivateLog(this.console);
        this.loc_1.addLocalLog(this.console);
        this.loc_2.addLog(this.console);
        this.loc_2.addPrivateLog(this.console);
        this.loc_2.addLocalLog(this.console);
        this.testFilter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        };
        this.loc_1.addFilter(this.testFilter);
        this.loc_2.addFilter(this.testFilter);
        LoggingManager.getLoggingManager().addListener(this);
    }

    protected void tearDown() {
        LoggingManager.getLoggingManager().removeListener(this);
    }

    public void handleEvent(LogController evt, boolean isResetTree) {
        LogControllerResetTest.assertTrue((String)"LogController's notify event mehanism not work!", (this.loc_1 == evt ? 1 : 0) != 0);
    }

    public void testReset() {
        this.loc_1.reset();
        LogControllerResetTest.assertTrue((String)"(1) LogController's Logs was not reset", (boolean)this.loc_1.getAllLogs().isEmpty());
        LogControllerResetTest.assertTrue((String)"(1) LogController's Severity was not reset", (this.loc_1.getEffectiveSeverity() == 701 ? 1 : 0) != 0);
        LogControllerResetTest.assertTrue((String)"(1) LogController's Filters was not reset", (boolean)this.loc_1.getFilters().isEmpty());
        LogControllerResetTest.assertTrue((String)"(2) LogController's Logs was not reset", (boolean)this.loc_2.getAllLogs().isEmpty());
        LogControllerResetTest.assertTrue((String)"(2) LogController's Severity was reset", (this.loc_2.getEffectiveSeverity() != 701 ? 1 : 0) != 0);
        LogControllerResetTest.assertTrue((String)"(2) LogController's Filters was reset", (!this.loc_2.getFilters().isEmpty() ? 1 : 0) != 0);
    }

    public void testResetAll() {
        this.loc_1.resetAll();
        LogControllerResetTest.assertTrue((String)"(1) LogController's Logs was not reset", (boolean)this.loc_1.getAllLogs().isEmpty());
        LogControllerResetTest.assertTrue((String)"(1) LogController's Severity was not reset", (this.loc_1.getEffectiveSeverity() == 701 ? 1 : 0) != 0);
        LogControllerResetTest.assertTrue((String)"(1) LogController's Filters was not reset", (boolean)this.loc_1.getFilters().isEmpty());
        LogControllerResetTest.assertTrue((String)"(2) LogController's Logs was not reset", (boolean)this.loc_2.getAllLogs().isEmpty());
        LogControllerResetTest.assertTrue((String)"(2) LogController's Severity was not reset", (this.loc_2.getEffectiveSeverity() == 701 ? 1 : 0) != 0);
        LogControllerResetTest.assertTrue((String)"(2) LogController's Filters was not reset", (boolean)this.loc_2.getFilters().isEmpty());
    }

    public static Test suite() {
        return new TestSuite(LogControllerResetTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LogControllerResetTest.suite());
    }
}

