/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LogFilterConfigurationTest
extends LoggingTestCase {
    private Log log;
    private Filter filter;

    public LogFilterConfigurationTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.log = new ConsoleLog();
        this.filter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        };
    }

    public void testAddFilter() {
        this.log.addFilter(this.filter);
        LogFilterConfigurationTest.assertTrue((String)"filter not attached to log", (boolean)this.log.getFilters().iterator().hasNext());
    }

    public void testAddFilterMultiple() {
        this.log.addFilter(this.filter);
        this.log.addFilter(this.filter);
        Iterator iter = this.log.getFilters().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!found) {
                found = true;
                iter.next();
                continue;
            }
            LogFilterConfigurationTest.fail((String)"filter attached twice to log");
        }
        LogFilterConfigurationTest.assertTrue((String)"filter not attached to log", (boolean)found);
    }

    public void testRemoveFilter() {
        Filter anotherFilter = new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        };
        this.log.addFilter(this.filter);
        this.log.addFilter(anotherFilter);
        this.log.removeFilter(anotherFilter);
        Iterator iter = this.log.getFilters().iterator();
        boolean found = false;
        while (iter.hasNext()) {
            if (!found) {
                if (iter.next() == this.filter) {
                    found = true;
                    continue;
                }
                LogFilterConfigurationTest.fail((String)"filter not removed from log");
                continue;
            }
            LogFilterConfigurationTest.fail((String)"filter not removed from log");
        }
        LogFilterConfigurationTest.assertTrue((String)"both filters removed from log", (boolean)found);
    }

    public void testRemoveFilters() {
        this.log.addFilter(this.filter);
        this.log.addFilter(new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        });
        this.log.removeFilters();
        if (this.log.getFilters().iterator().hasNext()) {
            LogFilterConfigurationTest.fail((String)"filters not removed from log");
        }
    }

    protected void tearDown() {
        LoggingManager.getLoggingManager().reset();
    }

    public static Test suite() {
        return new TestSuite(LogFilterConfigurationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LogFilterConfigurationTest.suite());
    }
}

