/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadableLog;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.io.File;
import java.text.MessageFormat;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LogReadingRotateTest
extends LoggingTestCase {
    String outFileDir = System.getProperty("cfg.path");
    IReadableLog _fileReader;

    public LogReadingRotateTest(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testListFormatterCurr() {
        String outWriteFile = this.outFileDir != null ? this.outFileDir + File.separator + "sampleOutListCurrFileLog.txt" : "sampleOutListCurrFileLog.txt";
        Location loc = Location.getLocation("com.loggingTest");
        loc.setEffectiveSeverity(100);
        FileLog fileWLog = new FileLog(outWriteFile, new ListFormatter(), false);
        loc.addLog(fileWLog);
        loc.warningT("A warning message");
        loc.debugT("A stupid debug message");
        loc.errorT("An error message with multiple Lines.\nLine2\nLine3");
        loc.fatalT("End pound message with placeholders: {0} and {1} went up the hill \\#\\\\#", new Object[]{"Jack", "Jill"});
        loc.fatalT("Fatal msg with special XML chars <I like {0}>", new Object[]{"<SAP>"});
        fileWLog.flush();
        fileWLog.close();
        loc.removeLogs();
        try {
            this._fileReader = this.outFileDir != null ? (IReadableLog)((Object)new FileLog(this.outFileDir + File.separator + "sampleOutListCurrFileLog.txt", (Formatter)new ListFormatter())) : (IReadableLog)((Object)new FileLog("sampleOutListCurrFileLog.txt", (Formatter)new ListFormatter()));
            IReadableLog _fileListReadable = this._fileReader.createReadableLog();
            ILoggingResultSet _msgRecordList = _fileListReadable.readLatestMsgRecords(10);
            LogReadingRotateTest.assertEquals((String)"total # msg from latest screwed up", (int)_msgRecordList.getSize(), (int)5);
            _msgRecordList = _fileListReadable.readOldestMsgRecords(10);
            LogReadingRotateTest.assertEquals((String)"total # msg from oldest screwed up", (int)_msgRecordList.getSize(), (int)5);
            _msgRecordList = this._fileReader.readLatestMsgRecords(2);
            LogReadingRotateTest.assertEquals((String)"Bad endPound msg with special chars with 2 args", (String)MessageFormat.format(((LogRecord)_msgRecordList.getResults().get(0)).getMsgClear(), ((LogRecord)_msgRecordList.getResults().get(0)).getArgs().toArray()), (String)"End pound message with placeholders: Jack and Jill went up the hill \\#\\\\#");
        }
        catch (Exception e) {
            System.out.println("testListFormatterCurr::: " + e);
        }
    }

    public void testListFormatter15Msg() {
        try {
            this._fileReader = this.outFileDir != null ? (IReadableLog)((Object)new FileLog(this.outFileDir + File.separator + "sampleTestingList15FileLog.txt", (Formatter)new ListFormatter())) : (IReadableLog)((Object)new FileLog("sampleTestingList15FileLog.txt", (Formatter)new ListFormatter()));
            IReadableLog _fileListReadable = this._fileReader.createReadableLog();
            ILoggingResultSet _msgRecordList = _fileListReadable.readLatestMsgRecords(10);
            LogReadingRotateTest.assertEquals((String)"total # msg from latest screwed up", (int)_msgRecordList.getSize(), (int)5);
            _msgRecordList = _fileListReadable.readOldestMsgRecords(10);
            LogReadingRotateTest.assertEquals((String)"total # msg from oldest screwed up", (int)_msgRecordList.getSize(), (int)5);
            _msgRecordList = _fileListReadable.readLatestMsgRecords(2);
            LogReadingRotateTest.assertEquals((String)"Bad endPound msg with special chars with 2 args", (String)MessageFormat.format(((LogRecord)_msgRecordList.getResults().get(0)).getMsgClear(), ((LogRecord)_msgRecordList.getResults().get(0)).getArgs().toArray()), (String)"End pound message with placeholders: Jack and Jill went up the hill \\#\\\\#");
        }
        catch (Exception e) {
            System.out.println("testListFormatter14Msg::: " + e);
        }
    }

    public void testListFormatter14Msg() {
        try {
            this._fileReader = this.outFileDir != null ? (IReadableLog)((Object)new FileLog(this.outFileDir + File.separator + "sampleTestingList14FileLog.txt", (Formatter)new ListFormatter())) : (IReadableLog)((Object)new FileLog("sampleTestingList14FileLog.txt", (Formatter)new ListFormatter()));
            IReadableLog _fileListReadable = this._fileReader.createReadableLog();
            ILoggingResultSet _msgRecordList = _fileListReadable.readLatestMsgRecords(10);
            LogReadingRotateTest.assertEquals((String)"total # msg from latest screwed up", (int)_msgRecordList.getSize(), (int)3);
            _msgRecordList = _fileListReadable.readOldestMsgRecords(10);
            LogReadingRotateTest.assertEquals((String)"total # msg from oldest screwed up", (int)_msgRecordList.getSize(), (int)3);
            _msgRecordList = _fileListReadable.readLatestMsgRecords(2);
            LogReadingRotateTest.assertEquals((String)"Bad endPound msg with special chars with 2 args", (String)MessageFormat.format(((LogRecord)_msgRecordList.getResults().get(1)).getMsgClear(), ((LogRecord)_msgRecordList.getResults().get(1)).getArgs().toArray()), (String)"End pound message with placeholders: Jack and Jill went up the hill \\#\\\\#");
        }
        catch (Exception e) {
            System.out.println("testListFormatter14Msg::: " + e);
        }
    }

    public void testGenericFormatterAPI() {
        String outWriteFile = this.outFileDir != null ? this.outFileDir + File.separator + "sampleOutListCurrFileLog.txt" : "sampleOutListCurrFileLog.txt";
        Location loc = Location.getLocation("com.loggingTest");
        loc.setEffectiveSeverity(100);
        FileLog fileWLog = new FileLog(outWriteFile, new ListFormatter(), false);
        loc.addLog(fileWLog);
        loc.infoT("A testing message");
        LogRecord record = loc.getRecord();
        String msg = fileWLog.getFormatter().format(record);
        loc.removeLogs();
        String eol = System.getProperty("line.separator");
        LogReadingRotateTest.assertEquals((String)"Fail to verify generated string with ending EOL", (boolean)fileWLog.getFormatter().isCompleteMessage(msg), (boolean)true);
        try {
            record = fileWLog.getFormatter().parseMsg(msg);
            LogReadingRotateTest.assertEquals((String)"Fail to parse string with ending EOL", (String)record.getMsgClear(), (String)"A testing message");
        }
        catch (Exception e) {
            System.out.println("testGenericFormatterAPI::: " + e);
        }
        LogReadingRotateTest.assertEquals((String)"Fail to verify generated string withOUT ending EOL", (boolean)fileWLog.getFormatter().isCompleteMessage(msg.substring(0, msg.length() - eol.length())), (boolean)true);
    }

    public void testReadingBigRotateList() {
        try {
            this._fileReader = this.outFileDir != null ? (IReadableLog)((Object)new FileLog(this.outFileDir + File.separator + "rotateLongListFileLog%g.txt", 2000000, 4, new ListFormatter())) : (IReadableLog)((Object)new FileLog("rotateLongListFileLog%g.txt", 2000000, 4, new ListFormatter()));
            IReadableLog _fileListReadable = this._fileReader.createReadableLog();
            ILoggingResultSet _msgRecordList = _fileListReadable.readPrevMsgRecords(1);
            LogReadingRotateTest.assertEquals((String)"latest record messed up", (String)((LogRecord)_msgRecordList.getResults().get(0)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:1C3F");
            _msgRecordList = _fileListReadable.readOldestMsgRecords(10);
            LogReadingRotateTest.assertEquals((String)"oldest record messed up", (String)((LogRecord)_msgRecordList.getResults().get(0)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-8000");
            _msgRecordList = _fileListReadable.readOldestMsgRecords(623);
            _msgRecordList = _fileListReadable.readNextMsgRecords(5);
            LogReadingRotateTest.assertEquals((String)"before crossing internal buffer", (String)((LogRecord)_msgRecordList.getResults().get(0)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-7D91");
            LogReadingRotateTest.assertEquals((String)"about crossing internal buffer", (String)((LogRecord)_msgRecordList.getResults().get(1)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-7D90");
            LogReadingRotateTest.assertEquals((String)"before crossing internal buffer again", (String)((LogRecord)_msgRecordList.getResults().get(2)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-7D8F");
            LogReadingRotateTest.assertEquals((String)"after crossing internal buffer", (String)((LogRecord)_msgRecordList.getResults().get(3)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-7D8E");
            LogReadingRotateTest.assertEquals((String)"definitely crossing internal buffer", (String)((LogRecord)_msgRecordList.getResults().get(4)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-7D8D");
            _msgRecordList = _fileListReadable.readNextMsgRecords(5);
            LogReadingRotateTest.assertEquals((String)"further after internal buffer", (String)((LogRecord)_msgRecordList.getResults().get(4)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-7D88");
            _msgRecordList = _fileListReadable.readPrevMsgRecords(12);
            LogReadingRotateTest.assertEquals((String)"back crossing internal buffer", (String)((LogRecord)_msgRecordList.getResults().get(0)).getId().toString(), (String)"10.48.86.221:7FFE01:F198981428:-7D93");
        }
        catch (Exception e) {
            System.out.println("testReadingBigRotateList::: " + e);
        }
    }

    protected void tearDown() {
        this._fileReader = null;
    }

    public static Test suite() {
        return new TestSuite(LogReadingRotateTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LogReadingRotateTest.suite());
    }
}

