/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.XMLFormatter;

public class OldLoggingTest {
    protected Formatter traceFormatter = new TraceFormatter();
    protected Formatter listFormatter = new ListFormatter();
    protected Formatter xmlFormatter = new XMLFormatter();
    protected ConsoleLog console = new ConsoleLog();
    protected FileLog file = new FileLog("tmp.log");

    public void testAll() {
        this.testOutput();
        this.testFormatters();
        this.testLogs();
    }

    public void testOutput() {
        Location loc = Location.getLocation("com.sap.tc.logging.LoggingTest");
        Location loc2 = Location.getLocation("com.sap.tc.logging.LoggingTest.inner()");
        Category cat = Category.getCategory(Category.APPLICATIONS, "ControlWord/Management");
        ConsoleLog console2 = new ConsoleLog();
        ConsoleLog console3 = new ConsoleLog();
        console2.setFormatter(new ListFormatter());
        console3.setFormatter(new XMLFormatter());
        loc.addLog(this.console);
        loc2.addLog(this.console);
        cat.addLog(console2);
        loc.setEffectiveSeverity(200);
        loc2.setEffectiveSeverity(200);
        System.err.print("Test output...");
        System.err.println("OK");
        loc.entering();
        loc.entering(new Object[]{"arg 1", "arg 2"});
        loc.entering();
        loc.setEffectiveSeverity(300);
        loc.entering();
        loc.setEffectiveSeverity(200);
        loc.entering();
        loc.setEffectiveSeverity(300);
        loc.entering();
        loc.setEffectiveSeverity(200);
        loc.entering();
        loc.assertion(false, "3 < 1");
        loc.exiting();
        loc.assertion(false, "3 < 1");
        loc.exiting();
        loc.assertion(false, "3 < 1");
        loc.exiting();
        loc.assertion(false, "3 < 1");
        loc.exiting();
        loc.assertion(false, "3 < 1");
        loc.exiting();
        loc.assertion(false, "3 < 1");
        loc.exiting();
        loc.assertion(false, "3 < 1");
        loc.exiting();
        loc.assertion(false, "3 < 1");
        loc.resetException();
        loc.exiting();
        System.err.println(loc.getException() != null ? loc.getException().toString() : "<null>");
        loc.assertion(false, "3 < 1");
        loc.throwing(new IllegalArgumentException("Argument wrong"));
        loc.catching(new IllegalArgumentException("Argument wrong"));
        loc.catching("testOutput", (Throwable)new IllegalArgumentException("Argument wrong"));
        loc.assertion(false, "3 < 1");
        loc.openGroup(200);
        loc.groupT("Entering double group");
        loc.closeGroup();
        loc.groupT("Exiting double group");
        loc.openGroup(100);
        loc.groupT("Entering custom group");
        loc.groupT("Bla rhabarber!");
        loc.entering();
        loc2.entering();
        loc2.groupT("Bla blubb!");
        loc.groupT("Bla blubb 2!");
        loc.openGroup(100);
        loc.groupT("Entering inner custom group");
        loc.closeGroup();
        loc.exiting();
        loc.groupT("Exiting inner custom group");
        loc2.resetException();
        loc2.exiting();
        System.err.println(loc2.getException() != null ? loc2.getException().toString() : "<null>");
        loc2.groupT("Bla blubb 3!");
        loc.groupT("Bla blubb 4!");
        loc.resetException();
        loc.exiting();
        System.err.println(loc.getException() != null ? loc.getException().toString() : "<null>");
        loc.groupT("Bla blubb 5!");
        loc.resetException();
        loc.closeGroup();
        System.err.println(loc.getException() != null ? loc.getException().toString() : "<null>");
        loc.groupT("Exiting custom group");
        loc.resetException();
        loc.closeGroup();
        System.err.println(loc.getException() != null ? loc.getException().toString() : "<null>");
        System.err.println("");
    }

    public void testFormatters() {
        Location loc = Location.getLocation("com.sap.tc.logging.LoggingTest.testFormatters()");
        Category formatters = Category.getCategory(Category.APPLICATIONS, "/Formatters");
        formatters.addLog(this.console);
        formatters.setEffectiveSeverity(300);
        System.err.print("Test formatters...");
        System.err.println("OK");
        System.err.println("Format with trace formatter:");
        formatters.infoT(loc, "Message without arguments");
        formatters.infoT(loc, "Message with arguments: {0}, {1}", new Object[]{"arg 1", "arg 2"});
        System.err.println("Format with list formatter:");
        this.console.setFormatter(this.listFormatter);
        formatters.infoT(loc, "Message without arguments");
        formatters.infoT(loc, "Message with arguments: {0}, {1}", new Object[]{"arg 1", "arg 2"});
        System.err.println("Format with XML formatter:");
        this.console.setFormatter(this.xmlFormatter);
        formatters.infoT(loc, "Message without arguments");
        formatters.infoT(loc, "Message with arguments: {0}, {1}", new Object[]{"arg 1", "arg 2"});
        this.console.setFormatter(this.traceFormatter);
        System.err.println("");
    }

    public void testLogs() {
        Location loc = Location.getLocation("com.sap.tc.logging.LoggingTest.testLogs()");
        Category logs = Category.SYS_LOGGING;
        Category child = Category.getCategory(Category.SYS_LOGGING, "Child");
        int LIMIT = 50;
        int MAX_CNT = 10;
        System.err.print("Test logs...");
        System.err.println("OK");
        logs.setEffectiveSeverity(400);
        child.setEffectiveSeverity(300);
        FileLog file = new FileLog("tmp_%u.log");
        logs.addLog(file);
        logs.warningT(loc, "Check file \"tmp_%u.log\"");
        logs.removeLogs();
        file = new FileLog("tmp_local_%u.log");
        logs.addLocalLog(file);
        child.infoT(loc, "Check file \"tmp_local_%u.log\"");
        child.warningT(loc, "Check file \"tmp_local_%u.log\"");
        logs.removeLogs();
        file = new FileLog("tmp_private_%u.log");
        logs.addPrivateLog(file);
        logs.warningT(loc, "Check file \"tmp_private_%u.log\"");
        child.warningT(loc, "Check file \"tmp_private_%u.log\"");
        logs.removeLogs();
        FileLog fileSet = new FileLog("tmp_%g.log", 50, 10);
        logs.addLog(fileSet);
        for (int i = 0; i < 11; ++i) {
            logs.warningT(loc, "Check file \"tmp_" + i % 10 + ".log\": no. " + i);
        }
        System.err.println("");
    }

    public static void main(String[] args) {
        new OldLoggingTest().testAll();
    }
}

