/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.TraceFormatter;
import java.util.Date;
import java.util.LinkedList;

public class PerformanceTest {
    private static final int CNT = 100000000;
    private static final int WRITE_FRACTION = 100;
    private static final int WRITE_COST = 5000;
    private static PerformanceTest o = new PerformanceTest();
    private static Location loc = Location.getLocation("com.sap.tc.logging");
    private static Location root = Location.getRoot();
    private static Category key = Category.SYS_NETWORK;
    private static Category keyC = Category.SYS_DATABASE;
    private static Category cat = key;

    public void testAll() {
        this.testSimpleMsg();
    }

    public void f(Object o) {
    }

    public void testSimpleMsg() {
        int i;
        String msg = "Message text";
        Date start = new Date();
        for (i = 0; i < 100000000; ++i) {
        }
        double duration = new Date().getTime() - start.getTime();
        start = new Date();
        for (i = 0; i < 100000000; ++i) {
            o.f(o);
        }
        double duration2 = new Date().getTime() - start.getTime();
        double timePerCall2 = (duration2 - duration) / 1.0E8 / 1000.0;
        double callsPerSec2 = 1.0 / timePerCall2;
        start = new Date();
        for (i = 0; i < 100000000; ++i) {
            loc.infoT("Message text");
        }
        double duration3 = new Date().getTime() - start.getTime();
        double timePerCall3 = (duration3 - duration) / 1.0E8 / 1000.0;
        double callsPerSec3 = 1.0 / timePerCall3;
        System.out.println("Straight call:");
        System.out.println("One call takes " + timePerCall3 + " seconds.");
        System.out.println("This corresponds to " + callsPerSec3 + " calls per second.");
        System.out.println("A call takes " + timePerCall3 / timePerCall2 + " times that of an average call");
        System.out.println();
        start = new Date();
        for (i = 0; i < 100000000; ++i) {
            loc.infoT(key, "Message text");
        }
        double duration4 = new Date().getTime() - start.getTime();
        double timePerCall4 = (duration4 - duration) / 1.0E8 / 1000.0;
        double callsPerSec4 = 1.0 / timePerCall4;
        System.out.println("Keyword-controlled call:");
        System.out.println("One call takes " + timePerCall4 + " seconds.");
        System.out.println("This corresponds to " + callsPerSec4 + " calls per second.");
        System.out.println("A call takes " + timePerCall4 / timePerCall2 + " times that of an average call");
        System.out.println();
        loc.setEffectiveSeverity(keyC, 100);
        start = new Date();
        for (i = 0; i < 100000000; ++i) {
            loc.infoT(key, "Message text");
        }
        double duration5 = new Date().getTime() - start.getTime();
        double timePerCall5 = (duration5 - duration) / 1.0E8 / 1000.0;
        double callsPerSec5 = 1.0 / timePerCall5;
        System.out.println("Keyword-controlled call with other keyword set:");
        System.out.println("One call takes " + timePerCall5 + " seconds.");
        System.out.println("This corresponds to " + callsPerSec5 + " calls per second.");
        System.out.println("A call takes " + timePerCall5 / timePerCall2 + " times that of an average call");
        System.out.println();
        loc.setEffectiveSeverity(keyC, 701);
        start = new Date();
        for (i = 0; i < 100000000; ++i) {
            loc.infoT(key, "Message text");
        }
        double duration6 = new Date().getTime() - start.getTime();
        double timePerCall6 = (duration6 - duration) / 1.0E8 / 1000.0;
        double callsPerSec6 = 1.0 / timePerCall6;
        System.out.println("Keyword-controlled call with other keyword reset:");
        System.out.println("One call takes " + timePerCall6 + " seconds.");
        System.out.println("This corresponds to " + callsPerSec6 + " calls per second.");
        System.out.println("A call takes " + timePerCall6 / timePerCall2 + " times that of an average call");
        System.out.println();
        FileLog file = new FileLog("c:/temp/test.log");
        ((Log)file).setFormatter(new TraceFormatter("%d %s: %m"));
        loc.addLog(file);
        loc.setEffectiveSeverity(300);
        start = new Date();
        for (i = 0; i < 1000000; ++i) {
            loc.infoT("Message text");
        }
        double duration7 = new Date().getTime() - start.getTime();
        double timePerCall7 = (duration7 * 100.0 - duration) / 1.0E8 / 1000.0;
        double callsPerSec7 = 1.0 / timePerCall7;
        System.out.println("Call to location that actually writes to a file:");
        System.out.println("One call takes " + timePerCall7 + " seconds.");
        System.out.println("This corresponds to " + callsPerSec7 + " calls per second.");
        System.out.println("A call takes " + timePerCall7 / timePerCall2 + " times that of an average call");
        System.out.println();
        int ACTORS_NO = 50;
        class Actor
        extends Thread {
            Actor(int no) {
                super("Actor-" + no);
            }

            public void run() {
                for (int i = 0; i < 20000; ++i) {
                    loc.infoT("Message text");
                }
            }
        }
        LinkedList<Actor> actors = new LinkedList<Actor>();
        start = new Date();
        for (i = 0; i < 50; ++i) {
            Actor actor = new Actor(i);
            actors.add(actor);
            actor.start();
        }
        for (Actor actor : actors) {
            try {
                actor.join();
            }
            catch (InterruptedException exc) {}
        }
        double duration10 = new Date().getTime() - start.getTime();
        double timePerCall10 = (duration10 * 100.0 - duration) / 1.0E8 / 1000.0;
        double callsPerSec10 = 1.0 / timePerCall10;
        System.out.println("Threaded call to location that actually writes to a file:");
        System.out.println("One call takes " + timePerCall10 + " seconds.");
        System.out.println("This corresponds to " + callsPerSec10 + " calls per second.");
        System.out.println("A call takes " + timePerCall10 / timePerCall2 + " times that of an average call");
        System.out.println();
    }

    public static void main(String[] args) {
        new PerformanceTest().testAll();
    }
}

