/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Filter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PropertiesConfiguratorTest
extends LoggingTestCase {
    private Properties properties;
    private Location sap;
    private Location technology;
    private Category system;
    private Category database;
    private Category network;

    public PropertiesConfiguratorTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.properties = new Properties();
        this.sap = Location.getLocation("com.sap");
        this.technology = Location.getLocation("com.sap.tc");
        this.system = Category.SYSTEM;
        this.database = Category.SYS_DATABASE;
        this.network = Category.SYS_NETWORK;
    }

    public void testSetSeverityLocation() {
        this.properties.setProperty("com.sap.severity", "Severity.ERROR");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"effective severity not set for location", (int)this.sap.getEffectiveSeverity(), (int)500);
    }

    public void testSetSeverityChildLocation() {
        this.properties.setProperty("com.sap.severity", "Severity.ERROR");
        this.properties.setProperty("com.sap.tc.severity", "WARNING");
        this.properties.setProperty("com.sap.tc2.severity", "WARNING");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"effective severity not set for child location", (this.technology.getEffectiveSeverity() == 400 && Location.getLocation("com.sap.tc2.severity").getEffectiveSeverity() == 400 ? 1 : 0) != 0);
    }

    public void testSetRelationSeverityLocation() {
        this.properties.setProperty("com.sap.tc.severity", "WARNING");
        this.properties.setProperty("com.sap.tc.severity[/System/Network]", "INFO");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"effective severity related to category not set for location", (int)this.technology.getEffectiveSeverity(this.network), (int)300);
    }

    public void testSetSeverityCategory() {
        this.properties.setProperty("/System.effSeverity", "FATAL");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"effective severity not set for category", (int)this.system.getEffectiveSeverity(), (int)600);
    }

    public void testSetSeverityChildCategory() {
        this.properties.setProperty("/System.effSeverity", "FATAL");
        this.properties.setProperty("/System/Database.severity", "Severity.WARNING");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"effective severity not set for child category", (int)this.database.getEffectiveSeverity(), (int)400);
    }

    public void testSetRelationSeverityCategory() {
        this.properties.setProperty("/System/Database.severity", "Severity.WARNING");
        this.properties.setProperty("/System/Database.severity[com.sap.tc]", "Severity.PATH");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"effective severity related to location not set for category", (int)this.database.getEffectiveSeverity(this.technology), (int)200);
    }

    public void testAssignUnknownLog() {
        this.sap.addLog(new ConsoleLog());
        this.properties.setProperty("log[Console]", "ConsoleLog");
        this.properties.setProperty("com.sap.logs", "log[console]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"unknown log found", (!this.sap.getLogs().iterator().hasNext() ? 1 : 0) != 0);
    }

    public void testDefineConsoleLog() {
        this.properties.setProperty("log[Console]", "ConsoleLog");
        this.properties.setProperty("com.sap.logs", "log[Console]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"console log not added to location", (this.sap.getLogs().iterator().hasNext() && this.sap.getLogs().iterator().next() instanceof ConsoleLog ? 1 : 0) != 0);
    }

    public void testDefineFileLog() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std.trc");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"file log not added to location", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next() instanceof FileLog ? 1 : 0) != 0);
    }

    public void testAssignUnknownTrace() {
        this.properties.setProperty("formatter[Trace]", "ListFormatter");
        this.properties.setProperty("log[Trace]", "ConsoleLog");
        this.properties.setProperty("log[Trace].formatter", "formatter[trace]");
        this.properties.setProperty("com.sap.logs", "log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"unknown formatter found", (this.sap.getLogs().iterator().hasNext() && this.sap.getLogs().iterator().next().getFormatter() instanceof TraceFormatter ? 1 : 0) != 0);
    }

    public void testDefineTraceFormatter() {
        this.properties.setProperty("formatter[Trace]", "TraceFormatter");
        this.properties.setProperty("formatter[Trace].pattern", "%24d %-40l %s: %m");
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std.trc");
        this.properties.setProperty("log[Trace].formatter", "formatter[Trace]");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"trace formatter not set for file log", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next().getFormatter() instanceof TraceFormatter ? 1 : 0) != 0);
    }

    public void testSetPatternTraceFormatter() {
        this.properties.setProperty("formatter[Trace]", "TraceFormatter");
        this.properties.setProperty("formatter[Trace].pattern", "%24d %-40l %s: %m");
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std.trc");
        this.properties.setProperty("log[Trace].formatter", "formatter[Trace]");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"pattern not set for trace formatter", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next().getFormatter() instanceof TraceFormatter && ((TraceFormatter)this.technology.getLogs().iterator().next().getFormatter()).getPattern().equals("%24d %-40l %s: %m") ? 1 : 0) != 0);
    }

    public void testSetAutoFlushFileLog() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std.trc");
        this.properties.setProperty("log[Trace].autoFlush", "true");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"Automatic flushing not enabled for this file log", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next() instanceof FileLog && ((FileLog)this.technology.getLogs().iterator().next()).isAutoFlush() ? 1 : 0) != 0);
    }

    public void testSetPatternFileLog() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t\\std.trc");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"pattern not set for file log", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next() instanceof FileLog && ((FileLog)this.technology.getLogs().iterator().next()).getPattern().equals("%t\\std.trc") ? 1 : 0) != 0);
    }

    public void testSetAppendFileLog() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std.trc");
        this.properties.setProperty("log[Trace].append", "false");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"Appending not disabled for this file log", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next() instanceof FileLog && !((FileLog)this.technology.getLogs().iterator().next()).isAppend() ? 1 : 0) != 0);
    }

    public void testSetLimitFileLog() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std%g.trc");
        this.properties.setProperty("log[Trace].limit", "65535");
        this.properties.setProperty("log[Trace].cnt", "10");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"limit not set for file log", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next() instanceof FileLog && ((FileLog)this.technology.getLogs().iterator().next()).getLimit() == 65535 ? 1 : 0) != 0);
    }

    public void testSetCntFileLog() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std%g.trc");
        this.properties.setProperty("log[Trace].limit", "65535");
        this.properties.setProperty("log[Trace].cnt", "10");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertTrue((String)"count not set for file log", (this.technology.getLogs().iterator().hasNext() && this.technology.getLogs().iterator().next() instanceof FileLog && ((FileLog)this.technology.getLogs().iterator().next()).getCnt() == 10 ? 1 : 0) != 0);
    }

    public void testAddLog() {
        this.technology.addLog(new FileLog("%t/std.trc"));
        this.properties.setProperty("com.sap.tc.logs", "+ ConsoleLog");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"file log removed from controller", (int)this.technology.getLogs().size(), (int)2);
    }

    public void testDuplicateConsoleLog() {
        this.properties.setProperty("com.sap.tc.logs", "+ ConsoleLog");
        new PropertiesConfigurator(this.properties).configure();
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"identical console log attached twice", (int)this.technology.getLogs().size(), (int)1);
    }

    public void testDuplicateFileLog() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std%g.trc");
        this.properties.setProperty("com.sap.tc.logs", "+ log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"identical file log attached twice", (int)this.technology.getLogs().size(), (int)1);
    }

    public void testAlterFileLogProperties() {
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std%g.trc");
        this.properties.setProperty("log[Trace].limit", "65535");
        this.properties.setProperty("log[Trace].cnt", "10");
        this.properties.setProperty("com.sap.tc.logs", "log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        FileLog oldLog = (FileLog)this.technology.getLogs().iterator().next();
        this.properties.clear();
        this.properties.setProperty("log[Trace]", "FileLog");
        this.properties.setProperty("log[Trace].pattern", "%t/std%g.trc");
        this.properties.setProperty("log[Trace].limit", "131071");
        this.properties.setProperty("log[Trace].cnt", "5");
        this.properties.setProperty("com.sap.tc.logs", "log[Trace]");
        new PropertiesConfigurator(this.properties).configure();
        FileLog newLog = (FileLog)this.technology.getLogs().iterator().next();
        PropertiesConfiguratorTest.assertTrue((String)"properties of file log not altered", (this.technology.getLogs().size() == 1 && oldLog == newLog && newLog.getLimit() == 131071 && newLog.getCnt() == 5 ? 1 : 0) != 0);
    }

    public void testRemoveLogs() {
        this.technology.addLog(new ConsoleLog());
        this.properties.setProperty("com.sap.tc.logs", "");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"logs not removed", (int)this.technology.getLogs().size(), (int)0);
    }

    public void testRemoveFilters() {
        this.technology.addFilter(new Filter(){

            public boolean beLogged(LogRecord rec) {
                return true;
            }
        });
        this.properties.setProperty("com.sap.tc.filters", "");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"filters not removed", (int)this.technology.getFilters().size(), (int)0);
    }

    public void testEscapedReservedWords() {
        Location loc = Location.getLocation("com.sap.tc.logging.logs");
        this.properties.setProperty("com.sap.tc.logging.'logs'.severity", "DEBUG");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"reserved word not escaped", (int)loc.getEffectiveSeverity(), (int)100);
    }

    public void testEscapedIllegalIdentifier() {
        Location loc = Location.getLocation("com.sap.tc.logging.'my logs'");
        this.properties.setProperty("com.sap.tc.logging.'my logs'.severity", "DEBUG");
        new PropertiesConfigurator(this.properties).configure();
        PropertiesConfiguratorTest.assertEquals((String)"illegal identifier not escaped", (int)loc.getEffectiveSeverity(), (int)100);
    }

    public static Test suite() {
        return new TestSuite(PropertiesConfiguratorTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)PropertiesConfiguratorTest.suite());
    }
}

