/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.exceptions.DataException;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadLog;
import com.sap.tc.logging.reader.ReadableLog;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class ReadTestLib
extends TestCase {
    private Location testLoc;
    private Category testCat;
    private int sizeRecords;
    private String messageStart = " Test ";
    private File testFile;
    private IReadLog readLog;
    private FileLog writeLog;
    private Formatter testFormatter;

    public ReadTestLib(String testClassName, String testFileName, String testLocName, Formatter testFormatter, int noRecords) throws IOException {
        this.setName(testClassName);
        this.testFile = new File(testFileName);
        this.testLoc = Location.getLocation(testLocName);
        this.testCat = Category.getCategory(Category.SYS_LOGGING, testLocName);
        this.testFormatter = testFormatter;
        this.sizeRecords = noRecords;
        this.testLoc.release();
        this.testCat.release();
        this.delete();
        this.buildTestLogFile(testFormatter);
        this.createReadLog();
    }

    public void performTestLatestThenPrevious_01() {
        try {
            this.readLog.moveToEOF();
            ILoggingResultSet latestRecordSet = this.readLog.readPrevious(4);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)4);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 1), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 4), ((LogRecord)latestRecordSet.getResults().get(3)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readPrevious(4);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)4);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 5), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 8), ((LogRecord)latestRecordSet.getResults().get(3)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(3);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)3);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 7), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 5), ((LogRecord)latestRecordSet.getResults().get(2)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(4);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)4);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 4), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 1), ((LogRecord)latestRecordSet.getResults().get(3)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readPrevious(3);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)3);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 2), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 4), ((LogRecord)latestRecordSet.getResults().get(2)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readPrevious(4);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)4);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 5), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 8), ((LogRecord)latestRecordSet.getResults().get(3)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(10);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)7);
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)0);
        }
        catch (DataException ex) {
            ReadTestLib.fail((String)"DataException");
        }
        catch (Exception ex) {
            ReadTestLib.fail((String)"Exception");
        }
    }

    public void performTestLatestThenPrevious_02() {
        try {
            this.readLog.moveToEOF();
            ILoggingResultSet latestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)1);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 1), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)1);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 2), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)1);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 1), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)0);
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)0);
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)0);
            latestRecordSet = null;
            latestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((int)latestRecordSet.getSize(), (int)0);
            latestRecordSet = null;
            for (int i = 0; i < 3; ++i) {
                this.writeRecords(this.getMessageStart() + "x" + i);
                latestRecordSet = this.readLog.readNext(1);
                ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
                ReadTestLib.assertEquals((String)"Record appended to log was not read!", (int)1, (int)latestRecordSet.getSize());
                ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + "x" + i, ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            }
        }
        catch (DataException ex) {
            ReadTestLib.fail((String)("DataException " + ex.getMessage()));
        }
    }

    public void performTestOldestThenNext() {
        try {
            this.readLog.moveToBOF();
            ILoggingResultSet oldestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"readOldestMsgRecords fails!", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertTrue((String)("oldest message in " + this.readLog.getSource() + " wrong!"), (boolean)this.testStrings(this.getMessageStart() + 0, ((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear()));
            oldestRecordSet = null;
            oldestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"2nd oldest message count bad", (int)oldestRecordSet.getSize(), (int)1);
            ReadTestLib.assertTrue((String)("2nd oldest message in " + this.readLog.getSource() + " wrong!"), (boolean)this.testStrings(this.getMessageStart() + 1, ((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear()));
        }
        catch (DataException ex) {
            ex.printStackTrace();
            ReadTestLib.fail((String)"DataException");
        }
    }

    public void performTestForwardToEnd() {
        try {
            int i;
            this.readLog.moveToEOF();
            ILoggingResultSet latestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
            ReadTestLib.assertEquals((String)"ReadLatest must find 1 record", (int)1, (int)latestRecordSet.getSize());
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 1), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            latestRecordSet = null;
            for (i = 1; i < this.sizeRecords; ++i) {
                latestRecordSet = this.readLog.readPrevious(1);
                ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
                ReadTestLib.assertEquals((String)("after reading " + i + " records in file " + this.readLog.getSource() + " readPrev returns wrong number of records: "), (int)1, (int)latestRecordSet.getSize());
                ReadTestLib.assertTrue((String)("Message not expected (" + i + ") !"), (boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - i - 1), ((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear()));
            }
            latestRecordSet = null;
            for (i = 0; i < 20; ++i) {
                latestRecordSet = this.readLog.readPrevious(1);
                ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)latestRecordSet.getException());
                ReadTestLib.assertEquals((String)(i + " readPrev after the oldest record returns wrong number of records: "), (int)0, (int)latestRecordSet.getSize());
            }
        }
        catch (DataException ex) {
            ex.printStackTrace();
            ReadTestLib.fail((String)"DataException");
        }
    }

    public void performTestForwardAndBack() {
        try {
            int i;
            this.readLog.moveToEOF();
            ILoggingResultSet oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"ReadLatest must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 1), ((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear()));
            oldestRecordSet = null;
            for (i = 1; i < this.sizeRecords / 2; ++i) {
                oldestRecordSet = this.readLog.readPrevious(1);
                ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
                ReadTestLib.assertEquals((String)"readPrev returns wrong number of records: ", (int)1, (int)oldestRecordSet.getSize());
                ReadTestLib.assertTrue((String)"Message not expected!", (boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - i - 1), ((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear()));
            }
            oldestRecordSet = null;
            for (i = this.sizeRecords / 2 - 1; i >= 1; --i) {
                oldestRecordSet = this.readLog.readNext(1);
                ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
                ReadTestLib.assertEquals((int)oldestRecordSet.getSize(), (int)1);
                ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - i), ((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear()));
            }
            oldestRecordSet = null;
            oldestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((int)oldestRecordSet.getSize(), (int)0);
            oldestRecordSet = null;
            oldestRecordSet = this.readLog.readNext(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((int)oldestRecordSet.getSize(), (int)0);
            oldestRecordSet = null;
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((int)oldestRecordSet.getSize(), (int)1);
            ReadTestLib.assertTrue((boolean)this.testStrings(this.getMessageStart() + (this.sizeRecords - 1), ((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear()));
        }
        catch (DataException ex) {
            ex.printStackTrace();
            ReadTestLib.fail((String)"DataException");
        }
    }

    public void testObtainFormatAutomatically() {
        if (this.readLog.getHeader().length() > 0) {
            FormatterType ftype = this.readLog.getFormatter().getFormatterType();
            if (ftype.equals(this.testFormatter.getFormatterType())) {
                ReadTestLib.assertEquals((String)"The format type is not correct", (Object)ftype, (Object)this.testFormatter.getFormatterType());
            }
        } else {
            ReadTestLib.fail((String)"Could not get header!");
        }
    }

    public void testException() {
        try {
            this.writeException();
            this.readLog.moveToEOF();
            ILoggingResultSet oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 2 arguments", (int)2, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 2 arguments", (int)2, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 2 arguments", (int)2, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 2 arguments", (int)2, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 2 arguments", (int)2, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 2 arguments", (int)2, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 0 arguments", (int)0, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 0 arguments", (int)0, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 0 arguments", (int)0, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 1 arguments", (int)1, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
            oldestRecordSet = this.readLog.readPrevious(1);
            ReadTestLib.assertNull((String)("Errors during read! File=" + this.readLog.getSource()), (Object)oldestRecordSet.getException());
            ReadTestLib.assertEquals((String)"Read must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReadTestLib.assertEquals((String)"Read must find 0 arguments", (int)0, (int)((LogRecord)oldestRecordSet.getResults().get(0)).getArgObjs().size());
        }
        catch (DataException ex) {
            ex.printStackTrace();
            ReadTestLib.fail((String)"DataException");
        }
    }

    public void close() {
        try {
            if (this.testLoc != null) {
                this.testLoc.release();
            }
            this.testLoc = null;
            if (this.testCat != null) {
                this.testCat.release();
            }
            this.testCat = null;
            if (this.readLog != null) {
                this.readLog.close();
            }
            this.readLog = null;
            if (this.writeLog != null) {
                this.writeLog.close();
            }
            this.writeLog = null;
            if (!this.delete()) {
                System.err.println("Could not delete " + this.testFile + " in test " + this.getName());
            }
            this.testFile = null;
        }
        catch (Exception ex) {
            ReadTestLib.fail((String)("Exception : " + ex.getMessage()));
        }
    }

    private boolean delete() {
        if (this.testFile != null && this.testFile.exists()) {
            return this.testFile.delete();
        }
        return true;
    }

    private boolean testStrings(String testString, String resultString) {
        if (testString.length() < resultString.length()) {
            return testString.equalsIgnoreCase(resultString.substring(resultString.length() - testString.length()));
        }
        return testString.equalsIgnoreCase(resultString);
    }

    private String getMessageStart() {
        return this.messageStart;
    }

    private void writeRecords(String testMsg) {
        this.testLoc.logT(600, testMsg);
    }

    private void writeException() {
        String testMsg = "My Test Message!";
        Object[] args = null;
        this.testCat.logThrowableT(600, this.testLoc, testMsg, new Exception("TEST"));
        this.testCat.logThrowableT(600, this.testLoc, "SRC", testMsg, (Throwable)new Exception("TEST"));
        this.testLoc.traceThrowableT(600, testMsg, new Exception("TEST"));
        this.testLoc.traceThrowableT(600, "SRC", testMsg, (Throwable)new Exception("TEST"));
        this.testCat.logThrowable(600, this.testLoc, (Object)"MSG_ID", testMsg, (Throwable)new Exception("TEST"));
        this.testCat.logThrowable(600, this.testLoc, "SRC", "MSG_ID", testMsg, (Throwable)new Exception("TEST"));
        testMsg = "My Test Message with arg {0}!";
        args = new Object[]{"Arg01"};
        this.testCat.logThrowableT(600, this.testLoc, testMsg, args, (Throwable)new Exception("TEST"));
        this.testCat.logThrowableT(600, this.testLoc, "SRC", testMsg, args, new Exception("TEST"));
        this.testLoc.traceThrowableT(600, testMsg, args, (Throwable)new Exception("TEST"));
        this.testLoc.traceThrowableT(600, "SRC", testMsg, args, (Throwable)new Exception("TEST"));
        this.testCat.logThrowable(600, this.testLoc, (Object)"MSG_ID", args, testMsg, (Throwable)new Exception("TEST"));
        this.testCat.logThrowable(600, this.testLoc, "SRC", "MSG_ID", args, testMsg, new Exception("TEST"));
    }

    private void writeRecords(String testMsg, int nr_recs) {
        for (int i = 0; i < nr_recs; ++i) {
            this.testLoc.logT(600, testMsg + i);
        }
    }

    public void buildTestLogFile(Formatter formatter) {
        this.testLoc.setEffectiveSeverity(0);
        this.testLoc.addLog(this.openLog(formatter));
        this.testCat.setEffectiveSeverity(0);
        this.testCat.addLog(this.openLog(formatter));
        if (!this.testFile.exists()) {
            this.writeRecords(this.messageStart, this.sizeRecords);
        } else {
            System.err.println("Test file " + this.testFile + " exists already in test case <" + this.getName() + ">");
        }
    }

    private FileLog openLog(Formatter formatter) {
        try {
            if (this.writeLog == null) {
                this.writeLog = new FileLog(this.testFile.getCanonicalPath());
                this.writeLog.setFormatter(formatter);
            }
            return this.writeLog;
        }
        catch (IOException e) {
            System.exit(222);
            return null;
        }
    }

    private void createReadLog() throws IOException {
        try {
            this.readLog = ReadableLog.createFileReadLog(this.testFile.getCanonicalPath());
            this.readLog.open();
        }
        catch (Exception ex) {
            ReadTestLib.fail((String)ex.getMessage());
        }
    }
}

