/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.FormatterType;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.exceptions.UnsupportedFormatException;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.perf.PerfFormatter;
import com.sap.tc.logging.reader.ReadableLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ReaderTest_Old
extends TestCase {
    static final String goodLocation = "com.sap.good";
    TestLog logFile;
    static final String badLocation = "com.sap.bad";
    TestLog logFileBAD;
    TestLog logFileSAT;
    static final int NR_RECORDS = 2000;

    public static Test suite() {
        FileLog apiLog = new FileLog("C:/Temp/Logs/API.log");
        Category.SYS_LOGGING.setEffectiveSeverity(0);
        Category.SYS_LOGGING.addLog(apiLog);
        TestSuite suite = new TestSuite(ReaderTest_Old.class);
        return suite;
    }

    public ReaderTest_Old(String testMethodName) {
        super(testMethodName);
    }

    public void setUp() {
        try {
            this.logFile = new TestLog(new File("LoggingTest.log"), goodLocation, " test ");
            this.logFileBAD = new TestLog(new File("LoggingTestBAD.log"), badLocation, "test be bad ");
            this.logFileSAT = new TestLog(new File("LoggingTestSAT.trc"), "com.sap.good.SAT", "SATTest ");
            this.logFile.delete();
            this.logFileBAD.delete();
            this.logFileSAT.delete();
            this.logFile.buildTestLogFile(new ListFormatter());
            this.logFileSAT.buildTestLogFile(new PerfFormatter());
            this.logFileBAD.buildTestLogFile(new ListFormatter());
            this.logFile.createReadableLog();
            this.logFileBAD.createReadableLog();
            this.logFileSAT.createReadableLog();
        }
        catch (IOException e) {
            ReaderTest_Old.fail((String)("IOException when opening readable log: " + e.getMessage()));
        }
    }

    public void tearDown() {
        this.logFile.closeReadableLog();
        this.logFileBAD.closeReadableLog();
        this.logFileSAT.closeReadableLog();
        this.logFile.closeLog();
        this.logFileBAD.closeLog();
        this.logFileSAT.closeLog();
        if (!this.logFile.delete()) {
            System.err.println("Could not delete " + this.logFile + " in test " + this.getName());
        }
        if (!this.logFileBAD.delete()) {
            System.err.println("Could not delete " + this.logFileBAD + " in test " + this.getName());
        }
        if (!this.logFileSAT.delete()) {
            System.err.println("Could not delete " + this.logFileSAT + " in test " + this.getName());
        }
        this.logFileBAD = null;
        this.logFile = null;
        this.logFileSAT = null;
    }

    public void testJustClose() {
        this.logFileBAD.closeLog();
        this.logFile.closeLog();
        this.logFile.closeReadableLog();
        this.logFileBAD.closeReadableLog();
        ReaderTest_Old.assertTrue((boolean)this.logFileBAD.delete());
        ReaderTest_Old.assertTrue((boolean)this.logFile.delete());
    }

    public void testFileSize() {
        ReaderTest_Old.assertEquals((String)("File length for " + this.logFile.toString() + " is bad"), (long)this.logFile.length(), (long)this.logFile.readableLog.getFileLength());
        ReaderTest_Old.assertEquals((String)("File length for  " + this.logFileBAD.toString() + " is bad"), (long)this.logFileBAD.length(), (long)this.logFileBAD.readableLog.getFileLength());
    }

    public void testForwardToEnd() {
        this.performTestForwardToEnd(this.logFile);
        this.performTestForwardToEnd(this.logFileBAD);
    }

    public void testLatestThenPrevious() {
        this.performTestLatestThenPrevious(this.logFile);
        this.performTestLatestThenPrevious(this.logFileBAD);
    }

    public void testLatestThenPreviousGoodFile() {
        this.performTestLatestThenPreviousNew(this.logFile);
    }

    public void testLatestThenPreviousBadFile() {
        this.performTestLatestThenPreviousNew(this.logFileBAD);
    }

    public void testOldestThenNext() {
        this.performTestOldestThenNext(this.logFile);
        this.performTestOldestThenNext(this.logFileBAD);
    }

    public void testForwardAndBack() {
        this.performTestForwardAndBack(this.logFile);
        this.performTestForwardAndBack(this.logFileBAD);
    }

    public void testObtainFormatAutomatically() {
        int counter = 0;
        ArrayList<TestLog> listOfLog = new ArrayList<TestLog>(3);
        listOfLog.add(this.logFile);
        listOfLog.add(this.logFileBAD);
        listOfLog.add(this.logFileSAT);
        ReadableLog log = null;
        Iterator i = listOfLog.iterator();
        while (i.hasNext()) {
            log = ((TestLog)i.next()).readableLog;
            if (log.getHeader().length() > 0) {
                FormatterType ftype = log.getFormatter().getFormatterType();
                if (++counter <= 2) {
                    ReaderTest_Old.assertEquals((String)"The format type is not correct", (Object)FormatterType.LISTFORMAT, (Object)ftype);
                    continue;
                }
                ReaderTest_Old.assertEquals((String)"The format type is not correct", (Object)FormatterType.PERFFORMAT, (Object)ftype);
                continue;
            }
            ReaderTest_Old.fail((String)"Could not get header!");
        }
    }

    public void performTestLatestThenPreviousNew(TestLog log) {
        try {
            ILoggingResultSet latestRecordSet = log.readableLog.readLatestMsgRecords(4);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)latestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)latestRecordSet.getSize(), (int)4);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1999), (String)((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1996), (String)((LogRecord)latestRecordSet.getResults().get(3)).getMsgClear());
            ILoggingResultSet secondLatestRecordSet = log.readableLog.readPrevMsgRecords(4);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)secondLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)secondLatestRecordSet.getSize(), (int)4);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1995), (String)((LogRecord)secondLatestRecordSet.getResults().get(0)).getMsgClear());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1992), (String)((LogRecord)secondLatestRecordSet.getResults().get(3)).getMsgClear());
            ILoggingResultSet thirdLatestRecordSet = log.readableLog.readNextMsgRecords(3);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)3);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1993), (String)((LogRecord)thirdLatestRecordSet.getResults().get(0)).getMsgClear());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1995), (String)((LogRecord)thirdLatestRecordSet.getResults().get(2)).getMsgClear());
            thirdLatestRecordSet = log.readableLog.readNextMsgRecords(4);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)4);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1996), (String)((LogRecord)thirdLatestRecordSet.getResults().get(0)).getMsgClear());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1999), (String)((LogRecord)thirdLatestRecordSet.getResults().get(3)).getMsgClear());
            thirdLatestRecordSet = log.readableLog.readPrevMsgRecords(3);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)3);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1998), (String)((LogRecord)thirdLatestRecordSet.getResults().get(0)).getMsgClear());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1996), (String)((LogRecord)thirdLatestRecordSet.getResults().get(2)).getMsgClear());
            thirdLatestRecordSet = log.readableLog.readPrevMsgRecords(4);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)4);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1995), (String)((LogRecord)thirdLatestRecordSet.getResults().get(0)).getMsgClear());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1992), (String)((LogRecord)thirdLatestRecordSet.getResults().get(3)).getMsgClear());
            thirdLatestRecordSet = log.readableLog.readNextMsgRecords(10);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)7);
            thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)0);
            for (int i = 0; i < 3; ++i) {
                log.writeRecords(log.getMessageStart() + "x" + i);
                thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
                ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
                ReaderTest_Old.assertEquals((String)"Record appended to log was not read!", (int)1, (int)thirdLatestRecordSet.getSize());
                ReaderTest_Old.assertEquals((String)(log.getMessageStart() + "x" + i), (String)((LogRecord)thirdLatestRecordSet.getResults().get(0)).getMsgClear());
            }
        }
        catch (Exception ex) {
            ReaderTest_Old.fail((String)"Exception");
        }
    }

    public void performTestLatestThenPrevious(TestLog log) {
        try {
            ILoggingResultSet latestRecordSet = log.readableLog.readLatestMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)latestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)latestRecordSet.getSize(), (int)1);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1999), (String)((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear());
            ILoggingResultSet secondLatestRecordSet = log.readableLog.readPrevMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)secondLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)secondLatestRecordSet.getSize(), (int)1);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1998), (String)((LogRecord)secondLatestRecordSet.getResults().get(0)).getMsgClear());
            ILoggingResultSet thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)1);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1999), (String)((LogRecord)thirdLatestRecordSet.getResults().get(0)).getMsgClear());
            thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)0);
            thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)0);
            thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)0);
            thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
            ReaderTest_Old.assertEquals((int)thirdLatestRecordSet.getSize(), (int)0);
            for (int i = 0; i < 3; ++i) {
                log.writeRecords(log.getMessageStart() + "x" + i);
                thirdLatestRecordSet = log.readableLog.readNextMsgRecords(1);
                ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)thirdLatestRecordSet.getException());
                ReaderTest_Old.assertEquals((String)"Record appended to log was not read!", (int)1, (int)thirdLatestRecordSet.getSize());
                ReaderTest_Old.assertEquals((String)(log.getMessageStart() + "x" + i), (String)((LogRecord)thirdLatestRecordSet.getResults().get(0)).getMsgClear());
            }
        }
        catch (IllegalArgumentException e1) {
            ReaderTest_Old.fail((String)"IllegalArgumentException");
        }
        catch (UnsupportedFormatException e1) {
            ReaderTest_Old.fail((String)"UnsupportedFormatException");
        }
        catch (IOException e1) {
            ReaderTest_Old.fail((String)"IOException");
        }
    }

    public void performTestOldestThenNext(TestLog log) {
        try {
            ILoggingResultSet oldestRecordSet = log.readableLog.readOldestMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)oldestRecordSet.getException());
            ReaderTest_Old.assertEquals((String)"readOldestMsgRecords fails!", (int)1, (int)oldestRecordSet.getSize());
            ReaderTest_Old.assertEquals((String)("oldest message in " + log.readableLog.getFileBeingCurrentlyRead() + " wrong!"), (String)(log.getMessageStart() + 0), (String)((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear());
            ILoggingResultSet secondoldestRecordSet = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)oldestRecordSet.getException());
            ReaderTest_Old.assertEquals((String)"2nd oldest message count bad", (int)secondoldestRecordSet.getSize(), (int)1);
            ReaderTest_Old.assertEquals((String)"2nd oldest message wrong", (String)(log.getMessageStart() + 1), (String)((LogRecord)secondoldestRecordSet.getResults().get(0)).getMsgClear());
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            ReaderTest_Old.fail((String)"IllegalArgumentException");
        }
        catch (UnsupportedFormatException e1) {
            ReaderTest_Old.fail((String)"UnsupportedFormatException");
            e1.printStackTrace();
        }
        catch (IOException e1) {
            ReaderTest_Old.fail((String)"IOException");
            e1.printStackTrace();
        }
    }

    public void performTestForwardToEnd(TestLog log) {
        try {
            ILoggingResultSet aRecordSet;
            int i;
            ILoggingResultSet latestRecordSet = log.readableLog.readLatestMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)latestRecordSet.getException());
            ReaderTest_Old.assertEquals((String)"ReadLatest must find 1 record", (int)1, (int)latestRecordSet.getSize());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1999), (String)((LogRecord)latestRecordSet.getResults().get(0)).getMsgClear());
            for (i = 1; i < 2000; ++i) {
                aRecordSet = log.readableLog.readPrevMsgRecords(1);
                ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)aRecordSet.getException());
                ReaderTest_Old.assertEquals((String)("after reading " + i + " records in file " + log.readableLog.getFileBeingCurrentlyRead() + " readPrev returns wrong number of records: "), (int)1, (int)aRecordSet.getSize());
                ReaderTest_Old.assertEquals((String)"Message not expected!", (String)(log.getMessageStart() + (2000 - i - 1)), (String)((LogRecord)aRecordSet.getResults().get(0)).getMsgClear());
            }
            for (i = 0; i < 20; ++i) {
                aRecordSet = log.readableLog.readPrevMsgRecords(1);
                ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)aRecordSet.getException());
                ReaderTest_Old.assertEquals((String)(i + " readPrev after the oldest record returns wrong number of records: "), (int)0, (int)aRecordSet.getSize());
            }
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            ReaderTest_Old.fail((String)"IllegalArgumentException");
        }
        catch (UnsupportedFormatException e1) {
            ReaderTest_Old.fail((String)"UnsupportedFormatException");
            e1.printStackTrace();
        }
        catch (IOException e1) {
            ReaderTest_Old.fail((String)"IOException");
            e1.printStackTrace();
        }
    }

    public void performTestForwardAndBack(TestLog log) {
        try {
            ILoggingResultSet aRecordSet;
            int i;
            ILoggingResultSet oldestRecordSet = log.readableLog.readLatestMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)oldestRecordSet.getException());
            ReaderTest_Old.assertEquals((String)"ReadLatest must find 1 record", (int)1, (int)oldestRecordSet.getSize());
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1999), (String)((LogRecord)oldestRecordSet.getResults().get(0)).getMsgClear());
            for (i = 1; i < 1000; ++i) {
                aRecordSet = log.readableLog.readPrevMsgRecords(1);
                ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)aRecordSet.getException());
                ReaderTest_Old.assertEquals((String)"readPrev returns wrong number of records: ", (int)1, (int)aRecordSet.getSize());
                ReaderTest_Old.assertEquals((String)"Message not expected!", (String)(log.getMessageStart() + (2000 - i - 1)), (String)((LogRecord)aRecordSet.getResults().get(0)).getMsgClear());
            }
            for (i = 999; i >= 1; --i) {
                aRecordSet = log.readableLog.readNextMsgRecords(1);
                ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)aRecordSet.getException());
                ReaderTest_Old.assertEquals((int)aRecordSet.getSize(), (int)1);
                ReaderTest_Old.assertEquals((String)(log.getMessageStart() + (2000 - i)), (String)((LogRecord)aRecordSet.getResults().get(0)).getMsgClear());
            }
            ILoggingResultSet aRecordSet2 = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)aRecordSet2.getException());
            ReaderTest_Old.assertEquals((int)aRecordSet2.getSize(), (int)0);
            aRecordSet2 = log.readableLog.readNextMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)aRecordSet2.getException());
            ReaderTest_Old.assertEquals((int)aRecordSet2.getSize(), (int)0);
            aRecordSet2 = log.readableLog.readPrevMsgRecords(1);
            ReaderTest_Old.assertNull((String)("Errors during read! File=" + log), (Object)aRecordSet2.getException());
            ReaderTest_Old.assertEquals((int)aRecordSet2.getSize(), (int)1);
            ReaderTest_Old.assertEquals((String)(log.getMessageStart() + 1999), (String)((LogRecord)aRecordSet2.getResults().get(0)).getMsgClear());
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            ReaderTest_Old.fail((String)"IllegalArgumentException");
        }
        catch (UnsupportedFormatException e1) {
            ReaderTest_Old.fail((String)"UnsupportedFormatException");
            e1.printStackTrace();
        }
        catch (IOException e1) {
            ReaderTest_Old.fail((String)"IOException");
            e1.printStackTrace();
        }
    }

    private class TestLog {
        Location testLoc;
        File fileFile;
        String messageStart;
        Log logLog;
        public ReadableLog readableLog;

        TestLog(File file, String loc, String startMsg) {
            this.fileFile = file;
            this.testLoc = Location.getLocation(loc);
            this.messageStart = startMsg;
        }

        public boolean delete() {
            if (this.fileFile.exists()) {
                return this.fileFile.delete();
            }
            return true;
        }

        public String getMessageStart() {
            return this.messageStart;
        }

        public long length() {
            return this.fileFile.length();
        }

        public void buildTestLogFile(Formatter formatter) {
            this.openLog(formatter);
            this.testLoc.setEffectiveSeverity(0);
            this.testLoc.addPrivateLog(this.logLog);
            if (!this.fileFile.exists()) {
                this.writeRecords(this.messageStart, 2000);
            } else {
                System.err.println("Test file " + this.fileFile + " exists already in test case <" + ReaderTest_Old.this.getName() + ">");
            }
        }

        private void openLog(Formatter formatter) {
            try {
                this.logLog = new FileLog(this.fileFile.getCanonicalPath());
                this.logLog.setFormatter(formatter);
            }
            catch (IOException e) {
                System.exit(222);
            }
        }

        private void writeRecords(String testMsg, int nr_recs) {
            for (int i = 0; i < nr_recs; ++i) {
                this.testLoc.logT(600, testMsg + i);
            }
        }

        private void writeRecords(String testMsg) {
            this.testLoc.logT(600, testMsg);
        }

        public ReadableLog createReadableLog() throws IOException {
            this.readableLog = (ReadableLog)ReadableLog.createReadableLog(new FileLog(this.fileFile.getCanonicalPath()));
            return this.readableLog;
        }

        public void closeReadableLog() {
            if (this.readableLog != null) {
                this.readableLog.close();
                this.readableLog = null;
            }
            this.testLoc.release();
        }

        public void closeLog() {
            if (this.logLog != null) {
                this.logLog.close();
                this.logLog = null;
            }
        }

        public String toString() {
            return this.fileFile.getName() + " loc=" + this.testLoc.getName();
        }
    }
}

