/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.BaseLog;
import com.sap.tc.logging.interfaces.IFilter;
import com.sap.tc.logging.interfaces.ILoggingResultSet;
import com.sap.tc.logging.interfaces.IReadLog;
import com.sap.tc.logging.reader.ReadableLog;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ReaderTest_TestFile
extends TestCase {
    private IReadLog readLog;
    static String outFileDir = System.getProperty("cfg.path");

    public ReaderTest_TestFile(String testMethodName) {
        super(testMethodName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ReaderTest_TestFile.class);
        return suite;
    }

    protected void setUp() throws Exception {
        this.readLog = ReadableLog.createFileReadLog(outFileDir + "testLog.log");
    }

    protected void tearDown() throws Exception {
        this.readLog.close();
    }

    public void testReadFromBofToEof() {
        ILoggingResultSet rs = null;
        int counter = 0;
        try {
            this.readLog.open();
            this.readLog.moveToBOF();
            while (!this.readLog.isEOF()) {
                rs = this.readLog.readNext();
                ReaderTest_TestFile.assertTrue((rs.getSize() > 0 ? 1 : 0) != 0);
                ++counter;
            }
        }
        catch (Exception ex) {
            ReaderTest_TestFile.fail((String)ex.getMessage());
        }
        ReaderTest_TestFile.assertTrue((String)("Wrong counter value (" + counter + "/25)"), (counter == 25 ? 1 : 0) != 0);
    }

    public void testReadFromEofToBof() {
        ILoggingResultSet rs = null;
        int counter = 0;
        try {
            this.readLog.open();
            this.readLog.moveToEOF();
            while (!this.readLog.isBOF()) {
                rs = this.readLog.readPrevious();
                ReaderTest_TestFile.assertTrue((rs.getSize() > 0 ? 1 : 0) != 0);
                ++counter;
            }
        }
        catch (Exception ex) {
            ReaderTest_TestFile.fail((String)ex.getMessage());
        }
        ReaderTest_TestFile.assertTrue((String)("Wrong counter value (" + counter + "/25)"), (counter == 25 ? 1 : 0) != 0);
    }

    public void testFilter() {
        BaseLog reader = (BaseLog)((Object)this.readLog);
        TestFilter filter = new TestFilter();
        reader.addFilter(filter);
        reader.removeFilter(filter);
        ReaderTest_TestFile.assertEquals((Object)reader.getFilters(), (Object)Collections.EMPTY_LIST);
        ReaderTest_TestFile.assertNull((Object)reader.getFilter(0));
    }

    private class TestFilter
    implements IFilter {
        private TestFilter() {
        }

        public boolean isFilterEnabled() {
            return true;
        }

        public boolean setEnableFilter(boolean value) {
            return false;
        }

        public boolean beRead(byte[] record) {
            return true;
        }
    }
}

