/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SetLCRelationSeverityTest
extends LoggingTestCase {
    private Location rootLoc;
    private Location loc;
    private Location childLoc;
    private Category category;
    private Category childCategory;

    public SetLCRelationSeverityTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.rootLoc = Location.getRoot();
        this.loc = Location.getLocation("com.sap");
        this.childLoc = Location.getLocation("com.sap.tc");
        this.category = Category.getCategory("/Test");
        this.childCategory = Category.getCategory("/Test/Test_2");
    }

    public void testSeverity() {
        this.loc.setEffectiveSeverity(this.category, 400);
        SetLCRelationSeverityTest.assertTrue((String)"effective severity related to category overridden", (this.loc.beWarning(this.category) && !this.loc.beInfo(this.category) ? 1 : 0) != 0);
    }

    public void testLowerMinimumSeverity() {
        this.loc.setEffectiveSeverity(this.category, 400);
        this.childLoc.setMinimumSeverity(this.category, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower minimum severity of child location related to a category dominates", (this.childLoc.beWarning(this.category) && !this.childLoc.beInfo(this.category) ? 1 : 0) != 0);
    }

    public void testHigherMinimumSeverity() {
        this.loc.setEffectiveSeverity(this.category, 400);
        this.childLoc.setMinimumSeverity(this.category, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher minimum severity of child location related to category overridden", (this.childLoc.beError(this.category) && !this.childLoc.beWarning(this.category) ? 1 : 0) != 0);
    }

    public void testLowerMaximumSeverity() {
        this.loc.setEffectiveSeverity(this.category, 400);
        this.childLoc.setMaximumSeverity(this.category, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower maximum severity of child location related to category overridden", (this.childLoc.beInfo(this.category) && !this.childLoc.bePath(this.category) ? 1 : 0) != 0);
    }

    public void testHigherMaximumSeverity() {
        this.loc.setEffectiveSeverity(this.category, 400);
        this.childLoc.setMaximumSeverity(this.category, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher maximum severity of child location related to category dominates", (this.childLoc.beWarning(this.category) && !this.childLoc.beInfo(this.category) ? 1 : 0) != 0);
    }

    public void testToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.category, 400);
        SetLCRelationSeverityTest.assertTrue((String)"effective severity related to category dominates for child category", (this.loc.beWarning(this.childCategory) && !this.loc.beInfo(this.childCategory) ? 1 : 0) != 0);
    }

    public void testChildToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.category, 400);
        SetLCRelationSeverityTest.assertTrue((String)"effective severity related to category dominates for a child and child category", (this.childLoc.beWarning(this.childCategory) && !this.childLoc.beInfo(this.childCategory) ? 1 : 0) != 0);
    }

    public void testLowerEffectiveToCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setEffectiveSeverity(this.category, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower effective severity of child location related to category dominates for child category", (this.childLoc.beInfo(this.childCategory) && !this.childLoc.bePath(this.childCategory) ? 1 : 0) != 0);
    }

    public void testLowerEffectiveToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setEffectiveSeverity(this.category, 500);
        this.childLoc.setEffectiveSeverity(this.childCategory, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower effective severity of child location related to child category dominates", (this.childLoc.beInfo(this.childCategory) && !this.childLoc.bePath(this.childCategory) ? 1 : 0) != 0);
    }

    public void testHigherEffectiveToCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setEffectiveSeverity(this.category, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher effective severity of child location related to category dominates for child category", (this.childLoc.beError(this.childCategory) && !this.childLoc.beWarning(this.childCategory) ? 1 : 0) != 0);
    }

    public void testHigherEffectiveToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setEffectiveSeverity(this.category, 300);
        this.childLoc.setEffectiveSeverity(this.childCategory, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher effective severity of child location related to child category dominates", (this.childLoc.beError(this.childCategory) && !this.childLoc.beWarning(this.childCategory) ? 1 : 0) != 0);
    }

    public void testLowerMinimumToCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMinimumSeverity(this.category, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower minimum severity of child location related to category dominates for child category", (this.childLoc.beWarning(this.childCategory) && !this.childLoc.beInfo(this.childCategory) ? 1 : 0) != 0);
    }

    public void testLowerMinimumToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 500);
        this.childLoc.setMinimumSeverity(this.childCategory, 400);
        SetLCRelationSeverityTest.assertTrue((String)"lower minimum severity of child location related to child category dominates", (this.childLoc.beError(this.childCategory) && !this.childLoc.beWarning(this.childCategory) ? 1 : 0) != 0);
    }

    public void testHigherMinimumToCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMinimumSeverity(this.category, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher minimum severity of child location related to category overridden for child category", (this.childLoc.beError(this.childCategory) && !this.childLoc.beWarning(this.childCategory) ? 1 : 0) != 0);
    }

    public void testHigherLowerMinimumToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMinimumSeverity(this.category, 300);
        this.childLoc.setMinimumSeverity(this.childCategory, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher minimum severity of child location related to child category overridden by lower minimum severity of its parent", (this.childLoc.beError(this.childCategory) && !this.childLoc.beWarning(this.childCategory) ? 1 : 0) != 0);
    }

    public void testLowerHigherMinimumToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMinimumSeverity(this.category, 500);
        this.childLoc.setMinimumSeverity(this.childCategory, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower minimum severity of child location related to child category dominates higher minimum severity of its parent", (this.childLoc.beError(this.childCategory) && !this.childLoc.beWarning(this.childCategory) ? 1 : 0) != 0);
    }

    public void testLowerMaximumToCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMaximumSeverity(this.category, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower maximum severity of child location related to category overridden for child category", (this.childLoc.beInfo(this.childCategory) && !this.childLoc.bePath(this.childCategory) ? 1 : 0) != 0);
    }

    public void testHigherLowerMaximumToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMaximumSeverity(this.category, 300);
        this.childLoc.setMaximumSeverity(this.childCategory, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher maximum severity of child location related to child category dominates lower maximum severity of its parent", (this.childLoc.beInfo(this.childCategory) && !this.childLoc.bePath(this.childCategory) ? 1 : 0) != 0);
    }

    public void testLowerHigherMaximumToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMaximumSeverity(this.category, 500);
        this.childLoc.setMaximumSeverity(this.childCategory, 300);
        SetLCRelationSeverityTest.assertTrue((String)"lower maximum severity of child location related to child category overridden by higher maximum severity of its parent", (this.childLoc.beInfo(this.childCategory) && !this.childLoc.bePath(this.childCategory) ? 1 : 0) != 0);
    }

    public void testHigherMaximumToCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMaximumSeverity(this.category, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher maximum severity of child location related to category dominates for child category", (this.childLoc.beWarning(this.childCategory) && !this.childLoc.beInfo(this.childCategory) ? 1 : 0) != 0);
    }

    public void testHigherMaximumToChildCategorySeverity() {
        this.loc.setEffectiveSeverity(this.childCategory, 400);
        this.childLoc.setMaximumSeverity(this.category, 600);
        this.childLoc.setMaximumSeverity(this.childCategory, 500);
        SetLCRelationSeverityTest.assertTrue((String)"higher maximum severity of child location related to child category dominates", (this.childLoc.beWarning(this.childCategory) && !this.childLoc.beInfo(this.childCategory) ? 1 : 0) != 0);
    }

    public void testRootLocationInheritance() {
        Location rootLoc = Location.getRoot();
        rootLoc.setEffectiveSeverity(this.category, 400);
        SetLCRelationSeverityTest.assertTrue((String)"effective severity of root related to category not passed on to child location and category", (this.childLoc.beWarning(this.childCategory) && !this.childLoc.beInfo(this.childCategory) ? 1 : 0) != 0);
    }

    public void testRootCategoryInheritance() {
        Category rootCategory = Category.getRoot();
        this.loc.setEffectiveSeverity(rootCategory, 400);
        SetLCRelationSeverityTest.assertTrue((String)"effective severity of location related to root category not passed on to child location and category", (this.childLoc.beWarning(this.category) && !this.childLoc.beInfo(this.category) ? 1 : 0) != 0);
    }

    public void testLocationInheritance() {
        this.loc.setEffectiveSeverity(this.category, 400);
        Location childLoc = Location.getLocation("com.sap.applications");
        SetLCRelationSeverityTest.assertTrue((String)"effective severity of location related to category not passed on to new child location", (childLoc.beWarning(this.childCategory) && !childLoc.beInfo(this.childCategory) ? 1 : 0) != 0);
    }

    public void testCategoryInheritance() {
        this.loc.setEffectiveSeverity(this.category, 400);
        Category childCategory = Category.getCategory("/Test/Test_3");
        SetLCRelationSeverityTest.assertTrue((String)"effective severity of category related to location not passed on for new child location", (this.loc.beWarning(childCategory) && !this.loc.beInfo(childCategory) ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(SetLCRelationSeverityTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SetLCRelationSeverityTest.suite());
    }
}

