/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SetLCSeverityTest
extends LoggingTestCase {
    private Category category;
    private Category childCategory;

    public SetLCSeverityTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.category = Category.SYSTEM;
        this.childCategory = Category.SYS_DATABASE;
        this.category.setEffectiveSeverity(400);
        this.category.setCopyToSubtree(true);
    }

    public void testLowerEffectiveSeverity() {
        this.childCategory.setEffectiveSeverity(300);
        SetLCSeverityTest.assertTrue((String)"lower effective severity of child category overridden", (this.childCategory.beInfo() && !this.childCategory.bePath() ? 1 : 0) != 0);
    }

    public void testHigherEffectiveSeverity() {
        this.childCategory.setEffectiveSeverity(500);
        SetLCSeverityTest.assertTrue((String)"higher effective severity of child category overridden", (this.childCategory.beError() && !this.childCategory.beWarning() ? 1 : 0) != 0);
    }

    public void testLowerMinimumSeverity() {
        this.childCategory.setMinimumSeverity(300);
        SetLCSeverityTest.assertTrue((String)"lower minimum severity of child category dominates", (this.childCategory.beWarning() && !this.childCategory.beInfo() ? 1 : 0) != 0);
    }

    public void testHigherMinimumSeverity() {
        this.childCategory.setMinimumSeverity(500);
        SetLCSeverityTest.assertTrue((String)"higher minimum severity of child category overridden", (this.childCategory.beError() && !this.childCategory.beWarning() ? 1 : 0) != 0);
    }

    public void testLowerMaximumSeverity() {
        this.childCategory.setMaximumSeverity(300);
        SetLCSeverityTest.assertTrue((String)"lower maximum severity of child category overridden", (this.childCategory.beInfo() && !this.childCategory.bePath() ? 1 : 0) != 0);
    }

    public void testHigherMaximumSeverity() {
        this.childCategory.setMaximumSeverity(500);
        SetLCSeverityTest.assertTrue((String)"higher maximum severity of child category dominates", (this.childCategory.beWarning() && !this.childCategory.beInfo() ? 1 : 0) != 0);
    }

    public void testRootInheritance() {
        Category rootCategory = Category.getRoot();
        rootCategory.setEffectiveSeverity(400);
        Category childCategory = Category.APPLICATIONS;
        SetLCSeverityTest.assertTrue((String)"effective severity of root not passed on to child category", (childCategory.beWarning() && !childCategory.beInfo() ? 1 : 0) != 0);
    }

    public void testInheritance() {
        this.category.setEffectiveSeverity(400);
        Category childCategory = Category.SYS_NETWORK;
        SetLCSeverityTest.assertTrue((String)"effective severity of category not passed on to new child category", (childCategory.beWarning() && !childCategory.beInfo() ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(SetLCSeverityTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SetLCSeverityTest.suite());
    }
}

