/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.test.junit;

import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.TraceFormatter;
import com.sap.tc.logging.test.junit.LoggingTestCase;
import java.text.DateFormat;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TraceFormatterTest
extends LoggingTestCase {
    private static final String EOL = System.getProperty("line.separator");
    private Location loc;
    private Log console;
    private TraceFormatter traceFormatter;

    public TraceFormatterTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.loc = Location.getLocation((Object)this);
        this.loc.setEffectiveSeverity(300);
        this.console = new ConsoleLog();
        this.console.setSuppressing(true);
        this.loc.addLog(this.console);
        this.traceFormatter = (TraceFormatter)this.console.getFormatter();
    }

    public void testTextPattern() {
        String pattern = "Text pattern";
        this.traceFormatter.setPattern("Text pattern");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"simple text pattern incorrect", (msg != null && msg.equals("Text pattern" + EOL) ? 1 : 0) != 0);
    }

    public void testGUIdPattern() {
        this.traceFormatter.setPattern("%i");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"message identifier incorrect", (msg != null && msg.equals(lRec.getId() + EOL) ? 1 : 0) != 0);
    }

    public void testRawTimeStampPattern() {
        this.traceFormatter.setPattern("%p");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"raw time stamp incorrect", (msg != null && msg.equals(lRec.getTime().getTime() + EOL) ? 1 : 0) != 0);
    }

    public void testTimeStampPattern() {
        DateFormat timeFormatter = DateFormat.getDateTimeInstance(2, 2, new Locale("en", "US"));
        this.traceFormatter.setPattern("%d");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"time stamp incorrect", (msg != null && msg.equals(timeFormatter.format(lRec.getTime()) + EOL) ? 1 : 0) != 0);
    }

    public void testLogControllerPattern() {
        this.traceFormatter.setPattern("%c");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"log controller incorrect", (msg != null && msg.equals(this.loc.getName() + EOL) ? 1 : 0) != 0);
    }

    public void testLocationPattern() {
        this.traceFormatter.setPattern("%l");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"location incorrect", (msg != null && msg.equals(this.loc.getName() + EOL) ? 1 : 0) != 0);
    }

    public void testThreadPattern() {
        this.traceFormatter.setPattern("%t");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"thread incorrect", (msg != null && msg.equals(Thread.currentThread().toString() + EOL) ? 1 : 0) != 0);
    }

    public void testSeverityPattern() {
        this.traceFormatter.setPattern("%s");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"severity incorrect", (msg != null && msg.equals(Severity.toString(300) + EOL) ? 1 : 0) != 0);
    }

    public void testMessageTextPattern() {
        String originalMsg = "Message text";
        this.traceFormatter.setPattern("%m");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"message text incorrect", (msg != null && msg.equals("Message text" + EOL) ? 1 : 0) != 0);
    }

    public void testLongMessageTextPattern() {
        String PATTERN = "0123456789";
        int SIZE = 131080;
        int ITER = 131080 / "0123456789".length();
        StringBuffer originalMsg = new StringBuffer(131080);
        this.traceFormatter.setPattern("%m");
        for (int i = 0; i < ITER; ++i) {
            originalMsg.append("0123456789");
        }
        LogRecord lRec = this.loc.logT(300, originalMsg.toString());
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"message text incorrect", (msg != null && msg.equals(originalMsg + EOL) ? 1 : 0) != 0);
    }

    public void testPercentageSignPattern() {
        this.traceFormatter.setPattern("%%");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"percentage sign incorrect", (msg != null && msg.equals("%" + EOL) ? 1 : 0) != 0);
    }

    public void testComplexPattern() {
        String originalMsg = "Message text";
        this.traceFormatter.setPattern("%20m, %20-m, %-20m, %-20-m");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"complex pattern incorrect", (msg != null && msg.equals("Message text        , Message text        ,         Message text,     Message text    " + EOL) ? 1 : 0) != 0);
    }

    public void testIncorrectPattern() {
        String pattern = "%-m%--20t%";
        this.traceFormatter.setPattern("%-m%--20t%");
        LogRecord lRec = this.loc.logT(300, "Message text");
        String msg = this.traceFormatter.format(lRec);
        TraceFormatterTest.assertTrue((String)"incorrect pattern incorrect", (msg != null && msg.equals("%-m%--20t%" + EOL) ? 1 : 0) != 0);
    }

    protected void tearDown() {
        LoggingManager.getLoggingManager().reset();
    }

    public static Test suite() {
        return new TestSuite(TraceFormatterTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TraceFormatterTest.suite());
    }
}

